# -*- coding: utf-8 -*-

"""
wordsapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from wordsapi.api_helper import APIHelper
from wordsapi.models.frequency_details import FrequencyDetails


class FrequencyResponse(object):

    """Implementation of the 'FrequencyResponse' model.

    This custom type contains response for frequency endpoint.

    Attributes:
        word (string): The word that is searched.
        frequency (FrequencyDetails): This model contains frequency details of
            a specific word.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "word": 'word',
        "frequency": 'frequency'
    }

    _optionals = [
        'word',
        'frequency',
    ]

    _nullables = [
        'word',
    ]

    def __init__(self,
                 word=APIHelper.SKIP,
                 frequency=APIHelper.SKIP):
        """Constructor for the FrequencyResponse class"""

        # Initialize members of the class
        if word is not APIHelper.SKIP:
            self.word = word 
        if frequency is not APIHelper.SKIP:
            self.frequency = frequency 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        word = dictionary.get("word") if "word" in dictionary.keys() else APIHelper.SKIP
        frequency = FrequencyDetails.from_dictionary(dictionary.get('frequency')) if 'frequency' in dictionary.keys() else APIHelper.SKIP 
        # Return an object of this model
        return cls(word,
                   frequency)
