# -*- coding: utf-8 -*-

"""
wordsapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from wordsapi.api_helper import APIHelper


class ExamplesResponse(object):

    """Implementation of the 'ExamplesResponse' model.

    This custom type contains response for examples endpoint.

    Attributes:
        word (string): The word that is searched.
        examples (list of string): The usage examples of the searched word.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "word": 'word',
        "examples": 'examples'
    }

    _optionals = [
        'word',
        'examples',
    ]

    _nullables = [
        'word',
        'examples',
    ]

    def __init__(self,
                 word=APIHelper.SKIP,
                 examples=APIHelper.SKIP):
        """Constructor for the ExamplesResponse class"""

        # Initialize members of the class
        if word is not APIHelper.SKIP:
            self.word = word 
        if examples is not APIHelper.SKIP:
            self.examples = examples 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        word = dictionary.get("word") if "word" in dictionary.keys() else APIHelper.SKIP
        examples = dictionary.get("examples") if "examples" in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(word,
                   examples)
