# -*- coding: utf-8 -*-

"""
wordsapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

import json
import dateutil.parser

from tests.controllers.controller_test_base import ControllerTestBase
from tests.test_helper import TestHelper
from wordsapi.api_helper import APIHelper


class APIsControllerTests(ControllerTestBase):

    @classmethod
    def setUpClass(cls):
        super(APIsControllerTests, cls).setUpClass()
        cls.controller = cls.client.ap_is
        cls.response_catcher = cls.controller.http_call_back

    # Get synonyms of a word.
    def test_synonyms(self):
        # Parameters for the API call
        word = 'lovely'

        # Perform the API call through the SDK function
        result = self.controller.synonyms(word)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))

        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        expected_body = APIHelper.json_deserialize('{"word":"lovely","synonyms":["adorable","endearing","cover girl","'
            'pin-up"]}')
        received_body = APIHelper.json_deserialize(self.response_catcher.response.text)
        self.assertTrue(TestHelper.match_body(expected_body, received_body))

    # Get definitions of a word, including the part of speech.
    def test_definitions(self):
        # Parameters for the API call
        word = 'lovely'

        # Perform the API call through the SDK function
        result = self.controller.definitions(word)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))

        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        expected_body = APIHelper.json_deserialize('{"word":"lovely","definition":["lovable especially in a childlike '
            'or naive way","a very pretty girl who works as a photographer\'s m'
            'odel","appealing to the emotions as well as the eye"]}')
        received_body = APIHelper.json_deserialize(self.response_catcher.response.text)
        self.assertTrue(TestHelper.match_body(expected_body, received_body))

    # How to pronounce a word, according to the International Phonetic Alphabet. May include multiple results if the word is pronounced differently depending on its part of speech.
    def test_pronunciation(self):
        # Parameters for the API call
        word = 'wind'

        # Perform the API call through the SDK function
        result = self.controller.pronunciation(word)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))

        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        expected_body = APIHelper.json_deserialize('{"word":"wind","pronunciation":{"all":"wɪnd","noun":"wɪnd","verb":'
            '"waɪnd"}}')
        received_body = APIHelper.json_deserialize(self.response_catcher.response.text)
        self.assertTrue(TestHelper.match_body(expected_body, received_body))

    # Retrieve information about a word. Results can include definitions, part of speech, synonyms, related words, syllables, and pronunciation. This method is useful to see which relationships are attached to which definition and part of speech of a word.
    def test_word(self):
        # Parameters for the API call
        word = 'Testing'

        # Perform the API call through the SDK function
        result = self.controller.word(word)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))


    # Get examples of how the word is used.
    def test_examples(self):
        # Parameters for the API call
        word = 'wind'

        # Perform the API call through the SDK function
        result = self.controller.examples(word)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))

        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        expected_body = APIHelper.json_deserialize('{"word":"testing","examples":["there are laboratories for commerci'
            'al testing","it involved testing thousands of children for smallpo'
            'x","they agreed to end the testing of atomic weapons"]}')
        received_body = APIHelper.json_deserialize(self.response_catcher.response.text)
        self.assertTrue(TestHelper.match_body(expected_body, received_body))

    # Expands upon the frequency score returned by the main /words/{word} endpoint. Returns zipf, a score indicating how common the word is in the English language, with a range of 1 to 7; per Million, the number of times the word is likely to appear in a corpus of one million English words; and diversity, a 0-1 scale the shows the likelihood of the word appearing in an English document that is part of a corpus.
    def test_frequency(self):
        # Parameters for the API call
        word = 'lovely'

        # Perform the API call through the SDK function
        result = self.controller.frequency(word)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))

        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        expected_body = APIHelper.json_deserialize('{"word":"wind","frequency":{"zipf":4.81,"perMillion":64.22,"divers'
            'ity":0.2}}')
        received_body = APIHelper.json_deserialize(self.response_catcher.response.text)
        self.assertTrue(TestHelper.match_body(expected_body, received_body))

