# VISIONAIRE4

A suite of tools used for Visionaire4 maintenance.  
Supported function subcommand:
- `report`: Generate Visionaire4 and FRemisN status report.
- `export`: Export metrics and edge cases data from current machine to files.
- `import`: Import metrics and edge cases data from the exported files to current machine.

## Installation

Install it directly using pip:
```bash
$ pip install visionaire4 --upgrade
```

## How to Use

### Export

#### Metrics  

Before running export metrics make sure to have prometheus server to be running.  
Export monitoring metrics data by running: 
```
$ visionaire4 export metrics
```

This command will pull metrics data from prometheus server running in container named `visionaire4`.  
You can configure the container name where the prometheus server is running with:
```
$ visionaire4 export metrics --prom-name <container name>
```

This will export the file to the default directory of `~/nodeflux/export`.  
You can configure where the exported file output directory with:
```
$ visionaire4 export metrics --out-dir <output directory>
```

#### Edge Case

Before running export edge case data make sure to have visionaire4 to be running.  
Export edge case data by running:
```
$ visionaire4 export edge
```

This command will pull edge case data from visionaire4 container running in container named `visionaire4`.  
You can configure the container name where the prometheus server is running with:
```
$ visionaire4 export edge --v4-name <container name>
```

### Import

#### Metrics  

Import the exported metrics data to current machine by running:
```
$ visionaire4 import metrics -f <path to exported file>
```

This will spawn a prometheus and grafana server and you can view the grafana dashboards at http://localhost:3000
with username `admin` and password `admin`.

All the required configs to run the prometheus and grafana server will be generated to the default directory of `~/nodeflux/import`.  
You can configure the config directory with:
```
$ visionaire4 import metrics -f <path to exported file> --cfg-dir <config directory>
```

When you finished viewing the metrics data, you can shutdown the monitoring server by running:
```
$ visionaire4 import metrics --cfg-dir <config directory> --down
```

#### Edge Case  

Import the exported edge case data to current machine by running:
```
$ visionaire4 import edge -f <path to exported file>
```

This will extract edge case data and separate image data from the label into default config directory `~/nodeflux/import`.  
You can configure the config directory with:
```
$ visionaire4 import edge -f <path to exported file> --cfg-dir <config directory>
```

### Report

To generate status report for Visionaire4 and or FRemisN, run:
```bash
$ visionaire4 report
```
This will try to locate a running Visionaire4 and or FRemisN, check the system status, and generate a summary for it. 
If it can't find either Visionaire4 or FRemisN container instance it will throw an error, so make sure to have a valid 
running instance of either one of it.  
If somehow you have the valid instance running and the tool can't find it, you can specify the container name using:
```bash
$ visionaire4 report --v4-name <visionaire4 container name> --fr-name <fremisn container name>
```

If you have a custom Visionaire4 address, specify it using:
```bash
$ visionaire4 report --v4-address <IP:PORT>
```

By default the report will save the last 1000 line of logs for each container, you specify it using:
```bash
$ visionaire4 report --tail <N>
# or
$ visionaire4 report -n <N>
```

By default the report will also plot the last 5 minutes (300 seconds) of useful metrics from prometheus server, 
you can specify the time range using:
``` bash
$ visionaire4 report --range <SECONDS>
# or
$ visionaire4 report -r <SECONDS>
```
