from pkm.api.packages.package import PackageDescriptor
from pkm.api.pkm import pkm
from pkm.api.licenses import KNOWN_LICENSES
from pkm.api.projects.project_group import ProjectGroup
import os
from pathlib import Path

try:
    import pwd
    default_author = pwd.getpwuid(os.getuid()).pw_name
except:
    default_author = os.environ.get('USERNAME') or 'Johon Doe'

global ask

project_name = ask("project_name", positional_arg=0, doc="The name of your project")
package_name = PackageDescriptor.normalize_src_package_name(project_name)
version = ask("version", doc="Initial project version", default="0.1.0")
description = ask("description", prompt="Short description", default="")
readme_type = ask("readme_type", options=['Markdown', "reStructuredText"], default="Markdown", doc="Readme type")
readme_file_ext = "md" if readme_type == 'Markdown' else 'rst'

python_available_versions = [str(p.version.without_patch()) for p in pkm.repositories.installed_pythons.list()]
required_python = ask("required_python", prompt="Required Python Version", options=python_available_versions)

author = ask("author", default=default_author)

license_text = ask("license", options=KNOWN_LICENSES, autocomplete=True, default="MIT License")

group = None
cwd = Path.cwd()
if ProjectGroup.is_valid(cwd):    
    if confirm("register_into_group", prompt="Register into the project group in the current directory"):
        group = ProjectGroup.load(cwd)

def post_generation():
    if group:
        group.add(cwd/project_name)
