import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::EKS::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html
 * @external
 */
export interface CfnClusterProps {
    /**
     * `AWS::EKS::Cluster.ResourcesVpcConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-resourcesvpcconfig
     * @external
     */
    readonly resourcesVpcConfig: CfnCluster.ResourcesVpcConfigProperty | cdk.IResolvable;
    /**
     * `AWS::EKS::Cluster.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::EKS::Cluster.EncryptionConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-encryptionconfig
     * @external
     */
    readonly encryptionConfig?: Array<CfnCluster.EncryptionConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EKS::Cluster.KubernetesNetworkConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-kubernetesnetworkconfig
     * @external
     */
    readonly kubernetesNetworkConfig?: CfnCluster.KubernetesNetworkConfigProperty | cdk.IResolvable;
    /**
     * `AWS::EKS::Cluster.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::EKS::Cluster.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-version
     * @external
     */
    readonly version?: string;
}
/**
 * A CloudFormation `AWS::EKS::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html
 * @external
 * @cloudformationResource AWS::EKS::Cluster
 */
export declare class CfnCluster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EKS::Cluster";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCluster;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CertificateAuthorityData
     */
    readonly attrCertificateAuthorityData: string;
    /**
     * @external
     * @cloudformationAttribute ClusterSecurityGroupId
     */
    readonly attrClusterSecurityGroupId: string;
    /**
     * @external
     * @cloudformationAttribute EncryptionConfigKeyArn
     */
    readonly attrEncryptionConfigKeyArn: string;
    /**
     * @external
     * @cloudformationAttribute Endpoint
     */
    readonly attrEndpoint: string;
    /**
     * `AWS::EKS::Cluster.ResourcesVpcConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-resourcesvpcconfig
     * @external
     */
    resourcesVpcConfig: CfnCluster.ResourcesVpcConfigProperty | cdk.IResolvable;
    /**
     * `AWS::EKS::Cluster.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::EKS::Cluster.EncryptionConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-encryptionconfig
     * @external
     */
    encryptionConfig: Array<CfnCluster.EncryptionConfigProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EKS::Cluster.KubernetesNetworkConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-kubernetesnetworkconfig
     * @external
     */
    kubernetesNetworkConfig: CfnCluster.KubernetesNetworkConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EKS::Cluster.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::EKS::Cluster.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-version
     * @external
     */
    version: string | undefined;
    /**
     * Create a new `AWS::EKS::Cluster`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClusterProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EKS::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html
 * @external
 * @cloudformationResource AWS::EKS::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-encryptionconfig.html
     * @external
     */
    interface EncryptionConfigProperty {
        /**
         * `CfnCluster.EncryptionConfigProperty.Provider`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-encryptionconfig.html#cfn-eks-cluster-encryptionconfig-provider
         * @external
         */
        readonly provider?: CfnCluster.ProviderProperty | cdk.IResolvable;
        /**
         * `CfnCluster.EncryptionConfigProperty.Resources`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-encryptionconfig.html#cfn-eks-cluster-encryptionconfig-resources
         * @external
         */
        readonly resources?: string[];
    }
}
/**
 * A CloudFormation `AWS::EKS::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html
 * @external
 * @cloudformationResource AWS::EKS::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-kubernetesnetworkconfig.html
     * @external
     */
    interface KubernetesNetworkConfigProperty {
        /**
         * `CfnCluster.KubernetesNetworkConfigProperty.ServiceIpv4Cidr`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-kubernetesnetworkconfig.html#cfn-eks-cluster-kubernetesnetworkconfig-serviceipv4cidr
         * @external
         */
        readonly serviceIpv4Cidr?: string;
    }
}
/**
 * A CloudFormation `AWS::EKS::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html
 * @external
 * @cloudformationResource AWS::EKS::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-provider.html
     * @external
     */
    interface ProviderProperty {
        /**
         * `CfnCluster.ProviderProperty.KeyArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-provider.html#cfn-eks-cluster-provider-keyarn
         * @external
         */
        readonly keyArn?: string;
    }
}
/**
 * A CloudFormation `AWS::EKS::Cluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html
 * @external
 * @cloudformationResource AWS::EKS::Cluster
 */
export declare namespace CfnCluster {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html
     * @external
     */
    interface ResourcesVpcConfigProperty {
        /**
         * `CfnCluster.ResourcesVpcConfigProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html#cfn-eks-cluster-resourcesvpcconfig-securitygroupids
         * @external
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnCluster.ResourcesVpcConfigProperty.SubnetIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html#cfn-eks-cluster-resourcesvpcconfig-subnetids
         * @external
         */
        readonly subnetIds: string[];
    }
}
/**
 * Properties for defining a `AWS::EKS::FargateProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html
 * @external
 */
export interface CfnFargateProfileProps {
    /**
     * `AWS::EKS::FargateProfile.ClusterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-clustername
     * @external
     */
    readonly clusterName: string;
    /**
     * `AWS::EKS::FargateProfile.PodExecutionRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-podexecutionrolearn
     * @external
     */
    readonly podExecutionRoleArn: string;
    /**
     * `AWS::EKS::FargateProfile.Selectors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-selectors
     * @external
     */
    readonly selectors: Array<CfnFargateProfile.SelectorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EKS::FargateProfile.FargateProfileName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-fargateprofilename
     * @external
     */
    readonly fargateProfileName?: string;
    /**
     * `AWS::EKS::FargateProfile.Subnets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-subnets
     * @external
     */
    readonly subnets?: string[];
    /**
     * `AWS::EKS::FargateProfile.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EKS::FargateProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html
 * @external
 * @cloudformationResource AWS::EKS::FargateProfile
 */
export declare class CfnFargateProfile extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EKS::FargateProfile";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFargateProfile;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::EKS::FargateProfile.ClusterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-clustername
     * @external
     */
    clusterName: string;
    /**
     * `AWS::EKS::FargateProfile.PodExecutionRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-podexecutionrolearn
     * @external
     */
    podExecutionRoleArn: string;
    /**
     * `AWS::EKS::FargateProfile.Selectors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-selectors
     * @external
     */
    selectors: Array<CfnFargateProfile.SelectorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EKS::FargateProfile.FargateProfileName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-fargateprofilename
     * @external
     */
    fargateProfileName: string | undefined;
    /**
     * `AWS::EKS::FargateProfile.Subnets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-subnets
     * @external
     */
    subnets: string[] | undefined;
    /**
     * `AWS::EKS::FargateProfile.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EKS::FargateProfile`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFargateProfileProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EKS::FargateProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html
 * @external
 * @cloudformationResource AWS::EKS::FargateProfile
 */
export declare namespace CfnFargateProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-fargateprofile-label.html
     * @external
     */
    interface LabelProperty {
        /**
         * `CfnFargateProfile.LabelProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-fargateprofile-label.html#cfn-eks-fargateprofile-label-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnFargateProfile.LabelProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-fargateprofile-label.html#cfn-eks-fargateprofile-label-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::EKS::FargateProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html
 * @external
 * @cloudformationResource AWS::EKS::FargateProfile
 */
export declare namespace CfnFargateProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-fargateprofile-selector.html
     * @external
     */
    interface SelectorProperty {
        /**
         * `CfnFargateProfile.SelectorProperty.Labels`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-fargateprofile-selector.html#cfn-eks-fargateprofile-selector-labels
         * @external
         */
        readonly labels?: Array<CfnFargateProfile.LabelProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFargateProfile.SelectorProperty.Namespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-fargateprofile-selector.html#cfn-eks-fargateprofile-selector-namespace
         * @external
         */
        readonly namespace: string;
    }
}
/**
 * Properties for defining a `AWS::EKS::Nodegroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html
 * @external
 */
export interface CfnNodegroupProps {
    /**
     * `AWS::EKS::Nodegroup.ClusterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-clustername
     * @external
     */
    readonly clusterName: string;
    /**
     * `AWS::EKS::Nodegroup.NodeRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-noderole
     * @external
     */
    readonly nodeRole: string;
    /**
     * `AWS::EKS::Nodegroup.Subnets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-subnets
     * @external
     */
    readonly subnets: string[];
    /**
     * `AWS::EKS::Nodegroup.AmiType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-amitype
     * @external
     */
    readonly amiType?: string;
    /**
     * `AWS::EKS::Nodegroup.DiskSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-disksize
     * @external
     */
    readonly diskSize?: number;
    /**
     * `AWS::EKS::Nodegroup.ForceUpdateEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-forceupdateenabled
     * @external
     */
    readonly forceUpdateEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::EKS::Nodegroup.InstanceTypes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-instancetypes
     * @external
     */
    readonly instanceTypes?: string[];
    /**
     * `AWS::EKS::Nodegroup.Labels`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-labels
     * @external
     */
    readonly labels?: any | cdk.IResolvable;
    /**
     * `AWS::EKS::Nodegroup.LaunchTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-launchtemplate
     * @external
     */
    readonly launchTemplate?: CfnNodegroup.LaunchTemplateSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::EKS::Nodegroup.NodegroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-nodegroupname
     * @external
     */
    readonly nodegroupName?: string;
    /**
     * `AWS::EKS::Nodegroup.ReleaseVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-releaseversion
     * @external
     */
    readonly releaseVersion?: string;
    /**
     * `AWS::EKS::Nodegroup.RemoteAccess`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-remoteaccess
     * @external
     */
    readonly remoteAccess?: CfnNodegroup.RemoteAccessProperty | cdk.IResolvable;
    /**
     * `AWS::EKS::Nodegroup.ScalingConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-scalingconfig
     * @external
     */
    readonly scalingConfig?: CfnNodegroup.ScalingConfigProperty | cdk.IResolvable;
    /**
     * `AWS::EKS::Nodegroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-tags
     * @external
     */
    readonly tags?: any;
    /**
     * `AWS::EKS::Nodegroup.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-version
     * @external
     */
    readonly version?: string;
}
/**
 * A CloudFormation `AWS::EKS::Nodegroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html
 * @external
 * @cloudformationResource AWS::EKS::Nodegroup
 */
export declare class CfnNodegroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EKS::Nodegroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnNodegroup;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute ClusterName
     */
    readonly attrClusterName: string;
    /**
     * @external
     * @cloudformationAttribute NodegroupName
     */
    readonly attrNodegroupName: string;
    /**
     * `AWS::EKS::Nodegroup.ClusterName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-clustername
     * @external
     */
    clusterName: string;
    /**
     * `AWS::EKS::Nodegroup.NodeRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-noderole
     * @external
     */
    nodeRole: string;
    /**
     * `AWS::EKS::Nodegroup.Subnets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-subnets
     * @external
     */
    subnets: string[];
    /**
     * `AWS::EKS::Nodegroup.AmiType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-amitype
     * @external
     */
    amiType: string | undefined;
    /**
     * `AWS::EKS::Nodegroup.DiskSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-disksize
     * @external
     */
    diskSize: number | undefined;
    /**
     * `AWS::EKS::Nodegroup.ForceUpdateEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-forceupdateenabled
     * @external
     */
    forceUpdateEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EKS::Nodegroup.InstanceTypes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-instancetypes
     * @external
     */
    instanceTypes: string[] | undefined;
    /**
     * `AWS::EKS::Nodegroup.Labels`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-labels
     * @external
     */
    labels: any | cdk.IResolvable | undefined;
    /**
     * `AWS::EKS::Nodegroup.LaunchTemplate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-launchtemplate
     * @external
     */
    launchTemplate: CfnNodegroup.LaunchTemplateSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EKS::Nodegroup.NodegroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-nodegroupname
     * @external
     */
    nodegroupName: string | undefined;
    /**
     * `AWS::EKS::Nodegroup.ReleaseVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-releaseversion
     * @external
     */
    releaseVersion: string | undefined;
    /**
     * `AWS::EKS::Nodegroup.RemoteAccess`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-remoteaccess
     * @external
     */
    remoteAccess: CfnNodegroup.RemoteAccessProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EKS::Nodegroup.ScalingConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-scalingconfig
     * @external
     */
    scalingConfig: CfnNodegroup.ScalingConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EKS::Nodegroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EKS::Nodegroup.Version`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-version
     * @external
     */
    version: string | undefined;
    /**
     * Create a new `AWS::EKS::Nodegroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNodegroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::EKS::Nodegroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html
 * @external
 * @cloudformationResource AWS::EKS::Nodegroup
 */
export declare namespace CfnNodegroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-launchtemplatespecification.html
     * @external
     */
    interface LaunchTemplateSpecificationProperty {
        /**
         * `CfnNodegroup.LaunchTemplateSpecificationProperty.Id`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-launchtemplatespecification.html#cfn-eks-nodegroup-launchtemplatespecification-id
         * @external
         */
        readonly id?: string;
        /**
         * `CfnNodegroup.LaunchTemplateSpecificationProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-launchtemplatespecification.html#cfn-eks-nodegroup-launchtemplatespecification-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnNodegroup.LaunchTemplateSpecificationProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-launchtemplatespecification.html#cfn-eks-nodegroup-launchtemplatespecification-version
         * @external
         */
        readonly version?: string;
    }
}
/**
 * A CloudFormation `AWS::EKS::Nodegroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html
 * @external
 * @cloudformationResource AWS::EKS::Nodegroup
 */
export declare namespace CfnNodegroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-remoteaccess.html
     * @external
     */
    interface RemoteAccessProperty {
        /**
         * `CfnNodegroup.RemoteAccessProperty.Ec2SshKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-remoteaccess.html#cfn-eks-nodegroup-remoteaccess-ec2sshkey
         * @external
         */
        readonly ec2SshKey: string;
        /**
         * `CfnNodegroup.RemoteAccessProperty.SourceSecurityGroups`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-remoteaccess.html#cfn-eks-nodegroup-remoteaccess-sourcesecuritygroups
         * @external
         */
        readonly sourceSecurityGroups?: string[];
    }
}
/**
 * A CloudFormation `AWS::EKS::Nodegroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html
 * @external
 * @cloudformationResource AWS::EKS::Nodegroup
 */
export declare namespace CfnNodegroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-scalingconfig.html
     * @external
     */
    interface ScalingConfigProperty {
        /**
         * `CfnNodegroup.ScalingConfigProperty.DesiredSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-scalingconfig.html#cfn-eks-nodegroup-scalingconfig-desiredsize
         * @external
         */
        readonly desiredSize?: number;
        /**
         * `CfnNodegroup.ScalingConfigProperty.MaxSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-scalingconfig.html#cfn-eks-nodegroup-scalingconfig-maxsize
         * @external
         */
        readonly maxSize?: number;
        /**
         * `CfnNodegroup.ScalingConfigProperty.MinSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-scalingconfig.html#cfn-eks-nodegroup-scalingconfig-minsize
         * @external
         */
        readonly minSize?: number;
    }
}
