# generated by datamodel-codegen:
#   filename:  schema/metadataIngestion/databaseServiceMetadataPipeline.json
#   timestamp: 2022-04-20T15:52:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from ..security.credentials import gcsCredentials, s3Credentials
from ..type import filterPattern


class DbtProvider(Enum):
    local = 'local'
    http = 'http'
    gcs = 'gcs'
    gcs_path = 'gcs-path'
    s3 = 's3'


class LocalHttpDBTConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    dbtCatalogFilePath: str = Field(
        ...,
        description='DBT catalog file to extract dbt models with their column schemas.',
    )
    dbtManifestFilePath: str = Field(
        ...,
        description='DBT manifest file path to extract dbt models and associate with tables.',
    )


class DatabaseServiceMetadataPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    markDeletedTables: Optional[bool] = Field(
        True,
        description='Optional configuration to soft delete tables in OpenMetadata if the source tables are deleted.',
    )
    includeTables: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching metadata for tables.',
    )
    includeViews: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching metadata for views.',
    )
    generateSampleData: Optional[bool] = Field(
        True,
        description='Option to turn on/off generating sample data during metadata extraction.',
    )
    sampleDataQuery: Optional[str] = Field(
        'select * from {}.{} limit 50', description='Sample data extraction query.'
    )
    enableDataProfiler: Optional[bool] = Field(
        False,
        description='Run data profiler as part of this metadata ingestion to get table profile data.',
    )
    schemaFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch tables or databases that matches the pattern.',
    )
    tableFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex exclude tables or databases that matches the pattern.'
    )
    dbtProvider: Optional[DbtProvider] = Field(
        None,
        description="Method from which the DBT files will be fetched. Accepted values are: 's3'(Required aws s3 credentials to be provided), 'gcs'(Required gcs credentials to be provided), 'gcs-path'(path of the file containing gcs credentials), 'local'(path of dbt files on local system), 'http'(url path of dbt files).",
    )
    dbtConfig: Optional[
        Union[
            LocalHttpDBTConfig,
            gcsCredentials.GCSCredentials,
            s3Credentials.S3Credentials,
        ]
    ] = Field(None, description='DBT configuration.')
    dbtCatalogFileName: Optional[str] = Field(
        'catalog.json', description='DBT Catalog file name'
    )
    dbtManifestFileName: Optional[str] = Field(
        'manifest.json', description='DBT Manifest file name'
    )
