# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/verticaConnection.json
#   timestamp: 2022-04-20T15:52:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class VerticaType(Enum):
    Vertica = 'Vertica'


class VerticaScheme(Enum):
    vertica_vertica_python = 'vertica+vertica_python'


class VerticaConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[VerticaType] = Field('Vertica', description='Service Type')
    scheme: Optional[VerticaScheme] = Field(
        'vertica+vertica_python', description='SQLAlchemy driver scheme options.'
    )
    username: str = Field(
        ...,
        description='username to connect  to the Vertica. This user should have privileges to read all the metadata in Vertica.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the Vertica.'
    )
    hostPort: str = Field(..., description='Host and port of the data source.')
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in Vertica.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
    supportsUsageExtraction: Optional[
        connectionBasicType.SupportsUsageExtraction
    ] = None
