# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/singleStoreConnection.json
#   timestamp: 2022-04-20T15:52:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class SingleStoreType(Enum):
    SingleStore = 'SingleStore'


class SingleStoreScheme(Enum):
    mysql_pymysql = 'mysql+pymysql'


class SingleStoreConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[SingleStoreType] = Field('SingleStore', description='Service Type')
    scheme: Optional[SingleStoreScheme] = Field(
        'mysql+pymysql', description='SQLAlchemy driver scheme options.'
    )
    username: str = Field(
        ...,
        description='username to connect  to the MySQL. This user should have privileges to read all the metadata in MySQL.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the MYSQL.'
    )
    hostPort: str = Field(..., description='Host and port of the data source.')
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in MySQL.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
