# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/postgresConnection.json
#   timestamp: 2022-04-20T15:52:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class PostgresType(Enum):
    Postgres = 'Postgres'


class PostgresScheme(Enum):
    postgresql_psycopg2 = 'postgresql+psycopg2'


class PostgresConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[PostgresType] = Field('Postgres', description='Service Type')
    scheme: Optional[PostgresScheme] = Field(
        'postgresql+psycopg2', description='SQLAlchemy driver scheme options.'
    )
    username: str = Field(
        ...,
        description='username to connect  to the Postgres. This user should have privileges to read all the metadata in Postgres.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the Postgres.'
    )
    hostPort: str = Field(..., description='Host and port of the Postgres.')
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in Postgres.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
