# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/mssqlConnection.json
#   timestamp: 2022-04-20T15:52:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class MssqlType(Enum):
    Mssql = 'Mssql'


class MssqlScheme(Enum):
    mssql_pyodbc = 'mssql+pyodbc'
    mssql_pytds = 'mssql+pytds'
    mssql_pymssql = 'mssql+pymssql'


class MssqlConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[MssqlType] = Field('Mssql', description='Service Type')
    scheme: Optional[MssqlScheme] = Field(
        'mssql+pytds', description='SQLAlchemy driver scheme options.'
    )
    username: str = Field(
        ...,
        description='username to connect  to the MsSQL. This user should have privileges to read all the metadata in MsSQL.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the MsSQL.'
    )
    hostPort: str = Field(..., description='Host and port of the MsSQL.')
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in MsSQL.',
    )
    uriString: Optional[str] = Field(
        None, description='Connection URI In case of pyodbc'
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
