# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/mariaDBConnection.json
#   timestamp: 2022-04-20T15:52:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class MariaDBType(Enum):
    MariaDB = 'MariaDB'


class MariaDBScheme(Enum):
    mysql_pymysql = 'mysql+pymysql'


class MariaDBConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[MariaDBType] = Field('MariaDB', description='Service Type')
    scheme: Optional[MariaDBScheme] = Field(
        'mysql+pymysql', description='SQLAlchemy driver scheme options.'
    )
    username: str = Field(
        ...,
        description='username to connect  to the MariaDB. This user should have privileges to read all the metadata in MariaDB.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the MariaDB.'
    )
    hostPort: str = Field(..., description='Host and port of the data source.')
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in MariaDB.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
