# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/dynamoDBConnection.json
#   timestamp: 2022-04-20T15:52:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class DynamoDBType(Enum):
    DynamoDB = 'DynamoDB'


class DynamoDBConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DynamoDBType] = Field('DynamoDB', description='Service Type')
    endPointURL: str = Field(..., description='EndPoint URL for the Dynamo DB')
    awsAccessKeyId: str = Field(..., description='AWS Access key ID.')
    awsSecretAccessKey: SecretStr = Field(..., description='AWS Secret Access Key.')
    awsSessionToken: Optional[str] = Field(None, description='AWS Session Token.')
    awsRegion: str = Field(..., description='AWS Region Name.')
    database: Optional[str] = Field(
        'DynamoDB',
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in Druid.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
