# mypy-boto3-elb

[![PyPI - mypy-boto3-elb](https://img.shields.io/pypi/v/mypy-boto3-elb.svg?color=blue)](https://pypi.org/project/mypy-boto3-elb)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-elb.svg?color=blue)](https://pypi.org/project/mypy-boto3-elb)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-elb](#mypy-boto3-elb)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)

Type annotations for
[boto3.ElasticLoadBalancing 1.13.26](https://boto3.amazonaws.com/v1/documentation/api/1.13.26/reference/services/elb.html#ElasticLoadBalancing) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.4](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `ElasticLoadBalancing` service.

```bash
python -m pip install boto3-stubs[elb]
```

Use `boto3` with `mypy_boto3_elb` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_elb import ElasticLoadBalancingClient

# Now mypy can check if your code is valid.
client: ElasticLoadBalancingClient = boto3.client("elb")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ElasticLoadBalancingClient = session.client("elb")



# Waiters are also supported

import mypy_boto3_elb.waiter as elb_waiters

any_instance_in_service_waiter: elb_waiters.AnyInstanceInServiceWaiter = client.get_waiter("any_instance_in_service")
instance_deregistered_waiter: elb_waiters.InstanceDeregisteredWaiter = client.get_waiter("instance_deregistered")
instance_in_service_waiter: elb_waiters.InstanceInServiceWaiter = client.get_waiter("instance_in_service")


# Annotated paginators are included as well

import mypy_boto3_elb.paginator as elb_paginators

describe_account_limits_paginator: elb_paginators.DescribeAccountLimitsPaginator = client.get_paginator("describe_account_limits")
describe_load_balancers_paginator: elb_paginators.DescribeLoadBalancersPaginator = client.get_paginator("describe_load_balancers")
```

## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_elb` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python
import boto3

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("elb")

session_client = boto3.Session().client("elb")
```