# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    OpenAPI spec version: 6.9.1.20191223.002
    Generated by: https://openapi-generator.tech
"""


from setuptools import setup, find_packages  # noqa: H301

NAME = "first_data_gateway"
VERSION = "1.7.0"
# To install the library, run the following
#
# python setup.py install
#
# prerequisite: setuptools
# http://pypi.python.org/pypi/setuptools

REQUIRES = ["urllib3 >= 1.15", "six >= 1.10", "certifi", "python-dateutil"]

setup(
    name=NAME,
    version=VERSION,
    description="First Data Gateway RESTFUL API Python SDK",
    author="Eric Margules",
    author_email="eric.margules@firstdata.com",
    url="https://docs.firstdata.com/org/gateway",
    keywords=["Payment", "Gateway", "SDK", "Developer", "First Data"],
    install_requires=REQUIRES,
    packages=find_packages(exclude=['docs', 'tests*']),
    include_package_data=True,
    license = 'MIT',
    long_description="Python SDK to be used with a First Data Gateway account. This SDK has been created and packaged to offer the easiest way to integrate your application into the First Data Gateway. This SDK gives you the ability to run transactions such as sales, preauthorizations, postauthorizations, credits, voids, and returns; transaction inquiries; setting up scheduled payments and much more."
)