# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 6.12.0.20200605.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openapi_client.configuration import Configuration


class SharedSecretConfigurationResponseAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'store_id': 'str',
        'shared_secret': 'str',
        'response_message': 'str',
        'response_timestamp': 'int'
    }

    attribute_map = {
        'store_id': 'storeId',
        'shared_secret': 'sharedSecret',
        'response_message': 'responseMessage',
        'response_timestamp': 'responseTimestamp'
    }

    def __init__(self, store_id=None, shared_secret=None, response_message=None, response_timestamp=None, local_vars_configuration=None):  # noqa: E501
        """SharedSecretConfigurationResponseAllOf - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._store_id = None
        self._shared_secret = None
        self._response_message = None
        self._response_timestamp = None
        self.discriminator = None

        if store_id is not None:
            self.store_id = store_id
        if shared_secret is not None:
            self.shared_secret = shared_secret
        if response_message is not None:
            self.response_message = response_message
        if response_timestamp is not None:
            self.response_timestamp = response_timestamp

    @property
    def store_id(self):
        """Gets the store_id of this SharedSecretConfigurationResponseAllOf.  # noqa: E501

        An optional outlet ID for clients that support multiple stores in the same developer app.  # noqa: E501

        :return: The store_id of this SharedSecretConfigurationResponseAllOf.  # noqa: E501
        :rtype: str
        """
        return self._store_id

    @store_id.setter
    def store_id(self, store_id):
        """Sets the store_id of this SharedSecretConfigurationResponseAllOf.

        An optional outlet ID for clients that support multiple stores in the same developer app.  # noqa: E501

        :param store_id: The store_id of this SharedSecretConfigurationResponseAllOf.  # noqa: E501
        :type: str
        """

        self._store_id = store_id

    @property
    def shared_secret(self):
        """Gets the shared_secret of this SharedSecretConfigurationResponseAllOf.  # noqa: E501

        Shared secret/password for Connect.  # noqa: E501

        :return: The shared_secret of this SharedSecretConfigurationResponseAllOf.  # noqa: E501
        :rtype: str
        """
        return self._shared_secret

    @shared_secret.setter
    def shared_secret(self, shared_secret):
        """Sets the shared_secret of this SharedSecretConfigurationResponseAllOf.

        Shared secret/password for Connect.  # noqa: E501

        :param shared_secret: The shared_secret of this SharedSecretConfigurationResponseAllOf.  # noqa: E501
        :type: str
        """

        self._shared_secret = shared_secret

    @property
    def response_message(self):
        """Gets the response_message of this SharedSecretConfigurationResponseAllOf.  # noqa: E501

        The message/status received after updating shared secret service config.  # noqa: E501

        :return: The response_message of this SharedSecretConfigurationResponseAllOf.  # noqa: E501
        :rtype: str
        """
        return self._response_message

    @response_message.setter
    def response_message(self, response_message):
        """Sets the response_message of this SharedSecretConfigurationResponseAllOf.

        The message/status received after updating shared secret service config.  # noqa: E501

        :param response_message: The response_message of this SharedSecretConfigurationResponseAllOf.  # noqa: E501
        :type: str
        """

        self._response_message = response_message

    @property
    def response_timestamp(self):
        """Gets the response_timestamp of this SharedSecretConfigurationResponseAllOf.  # noqa: E501

        Response timestamp.  # noqa: E501

        :return: The response_timestamp of this SharedSecretConfigurationResponseAllOf.  # noqa: E501
        :rtype: int
        """
        return self._response_timestamp

    @response_timestamp.setter
    def response_timestamp(self, response_timestamp):
        """Sets the response_timestamp of this SharedSecretConfigurationResponseAllOf.

        Response timestamp.  # noqa: E501

        :param response_timestamp: The response_timestamp of this SharedSecretConfigurationResponseAllOf.  # noqa: E501
        :type: int
        """

        self._response_timestamp = response_timestamp

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SharedSecretConfigurationResponseAllOf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SharedSecretConfigurationResponseAllOf):
            return True

        return self.to_dict() != other.to_dict()
