# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 6.12.0.20200605.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openapi_client.configuration import Configuration


class Secure3D21AuthenticationUpdateRequestAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'method_notification_status': 'str',
        'acs_response': 'ACSResponse'
    }

    attribute_map = {
        'method_notification_status': 'methodNotificationStatus',
        'acs_response': 'acsResponse'
    }

    def __init__(self, method_notification_status=None, acs_response=None, local_vars_configuration=None):  # noqa: E501
        """Secure3D21AuthenticationUpdateRequestAllOf - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._method_notification_status = None
        self._acs_response = None
        self.discriminator = None

        if method_notification_status is not None:
            self.method_notification_status = method_notification_status
        if acs_response is not None:
            self.acs_response = acs_response

    @property
    def method_notification_status(self):
        """Gets the method_notification_status of this Secure3D21AuthenticationUpdateRequestAllOf.  # noqa: E501

        Indicates how the merchant received the 3DS method.  # noqa: E501

        :return: The method_notification_status of this Secure3D21AuthenticationUpdateRequestAllOf.  # noqa: E501
        :rtype: str
        """
        return self._method_notification_status

    @method_notification_status.setter
    def method_notification_status(self, method_notification_status):
        """Sets the method_notification_status of this Secure3D21AuthenticationUpdateRequestAllOf.

        Indicates how the merchant received the 3DS method.  # noqa: E501

        :param method_notification_status: The method_notification_status of this Secure3D21AuthenticationUpdateRequestAllOf.  # noqa: E501
        :type: str
        """
        allowed_values = ["RECEIVED", "EXPECTED_BUT_NOT_RECEIVED", "NOT_EXPECTED"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and method_notification_status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `method_notification_status` ({0}), must be one of {1}"  # noqa: E501
                .format(method_notification_status, allowed_values)
            )

        self._method_notification_status = method_notification_status

    @property
    def acs_response(self):
        """Gets the acs_response of this Secure3D21AuthenticationUpdateRequestAllOf.  # noqa: E501


        :return: The acs_response of this Secure3D21AuthenticationUpdateRequestAllOf.  # noqa: E501
        :rtype: ACSResponse
        """
        return self._acs_response

    @acs_response.setter
    def acs_response(self, acs_response):
        """Sets the acs_response of this Secure3D21AuthenticationUpdateRequestAllOf.


        :param acs_response: The acs_response of this Secure3D21AuthenticationUpdateRequestAllOf.  # noqa: E501
        :type: ACSResponse
        """

        self._acs_response = acs_response

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Secure3D21AuthenticationUpdateRequestAllOf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Secure3D21AuthenticationUpdateRequestAllOf):
            return True

        return self.to_dict() != other.to_dict()
