# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 6.12.0.20200605.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openapi_client.configuration import Configuration


class PaymentRegistrationAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'original_transaction_type': 'str',
        'issuer_response': 'IssuerResponse',
        'verification_avs': 'VerificationAvs',
        'verification3ds': 'Verification3ds',
        'verification_cvv': 'VerificationCvv',
        'registration_method': 'RegistrationMethod'
    }

    attribute_map = {
        'original_transaction_type': 'originalTransactionType',
        'issuer_response': 'issuerResponse',
        'verification_avs': 'verificationAvs',
        'verification3ds': 'verification3ds',
        'verification_cvv': 'verificationCvv',
        'registration_method': 'registrationMethod'
    }

    def __init__(self, original_transaction_type=None, issuer_response=None, verification_avs=None, verification3ds=None, verification_cvv=None, registration_method=None, local_vars_configuration=None):  # noqa: E501
        """PaymentRegistrationAllOf - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._original_transaction_type = None
        self._issuer_response = None
        self._verification_avs = None
        self._verification3ds = None
        self._verification_cvv = None
        self._registration_method = None
        self.discriminator = None

        if original_transaction_type is not None:
            self.original_transaction_type = original_transaction_type
        if issuer_response is not None:
            self.issuer_response = issuer_response
        if verification_avs is not None:
            self.verification_avs = verification_avs
        if verification3ds is not None:
            self.verification3ds = verification3ds
        if verification_cvv is not None:
            self.verification_cvv = verification_cvv
        if registration_method is not None:
            self.registration_method = registration_method

    @property
    def original_transaction_type(self):
        """Gets the original_transaction_type of this PaymentRegistrationAllOf.  # noqa: E501

        Defines the type of the original transaction that is being evaluated for the Fraud Score.  # noqa: E501

        :return: The original_transaction_type of this PaymentRegistrationAllOf.  # noqa: E501
        :rtype: str
        """
        return self._original_transaction_type

    @original_transaction_type.setter
    def original_transaction_type(self, original_transaction_type):
        """Sets the original_transaction_type of this PaymentRegistrationAllOf.

        Defines the type of the original transaction that is being evaluated for the Fraud Score.  # noqa: E501

        :param original_transaction_type: The original_transaction_type of this PaymentRegistrationAllOf.  # noqa: E501
        :type: str
        """

        self._original_transaction_type = original_transaction_type

    @property
    def issuer_response(self):
        """Gets the issuer_response of this PaymentRegistrationAllOf.  # noqa: E501


        :return: The issuer_response of this PaymentRegistrationAllOf.  # noqa: E501
        :rtype: IssuerResponse
        """
        return self._issuer_response

    @issuer_response.setter
    def issuer_response(self, issuer_response):
        """Sets the issuer_response of this PaymentRegistrationAllOf.


        :param issuer_response: The issuer_response of this PaymentRegistrationAllOf.  # noqa: E501
        :type: IssuerResponse
        """

        self._issuer_response = issuer_response

    @property
    def verification_avs(self):
        """Gets the verification_avs of this PaymentRegistrationAllOf.  # noqa: E501


        :return: The verification_avs of this PaymentRegistrationAllOf.  # noqa: E501
        :rtype: VerificationAvs
        """
        return self._verification_avs

    @verification_avs.setter
    def verification_avs(self, verification_avs):
        """Sets the verification_avs of this PaymentRegistrationAllOf.


        :param verification_avs: The verification_avs of this PaymentRegistrationAllOf.  # noqa: E501
        :type: VerificationAvs
        """

        self._verification_avs = verification_avs

    @property
    def verification3ds(self):
        """Gets the verification3ds of this PaymentRegistrationAllOf.  # noqa: E501


        :return: The verification3ds of this PaymentRegistrationAllOf.  # noqa: E501
        :rtype: Verification3ds
        """
        return self._verification3ds

    @verification3ds.setter
    def verification3ds(self, verification3ds):
        """Sets the verification3ds of this PaymentRegistrationAllOf.


        :param verification3ds: The verification3ds of this PaymentRegistrationAllOf.  # noqa: E501
        :type: Verification3ds
        """

        self._verification3ds = verification3ds

    @property
    def verification_cvv(self):
        """Gets the verification_cvv of this PaymentRegistrationAllOf.  # noqa: E501


        :return: The verification_cvv of this PaymentRegistrationAllOf.  # noqa: E501
        :rtype: VerificationCvv
        """
        return self._verification_cvv

    @verification_cvv.setter
    def verification_cvv(self, verification_cvv):
        """Sets the verification_cvv of this PaymentRegistrationAllOf.


        :param verification_cvv: The verification_cvv of this PaymentRegistrationAllOf.  # noqa: E501
        :type: VerificationCvv
        """

        self._verification_cvv = verification_cvv

    @property
    def registration_method(self):
        """Gets the registration_method of this PaymentRegistrationAllOf.  # noqa: E501


        :return: The registration_method of this PaymentRegistrationAllOf.  # noqa: E501
        :rtype: RegistrationMethod
        """
        return self._registration_method

    @registration_method.setter
    def registration_method(self, registration_method):
        """Sets the registration_method of this PaymentRegistrationAllOf.


        :param registration_method: The registration_method of this PaymentRegistrationAllOf.  # noqa: E501
        :type: RegistrationMethod
        """

        self._registration_method = registration_method

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PaymentRegistrationAllOf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PaymentRegistrationAllOf):
            return True

        return self.to_dict() != other.to_dict()
