# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 6.12.0.20200605.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openapi_client.configuration import Configuration


class FraudSettingsResponseAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'store_id': 'str',
        'blocked_card_numbers': 'list[BlockedCardNumber]',
        'blocked_names': 'list[str]',
        'blocked_domain_names': 'list[str]',
        'blocked_ip_or_class_c_addresses': 'list[str]',
        'maximum_purchase_amount': 'list[MaximumPurchaseAmount]',
        'lockout_time': 'LockoutTime',
        'country_profile': 'str'
    }

    attribute_map = {
        'store_id': 'storeId',
        'blocked_card_numbers': 'blockedCardNumbers',
        'blocked_names': 'blockedNames',
        'blocked_domain_names': 'blockedDomainNames',
        'blocked_ip_or_class_c_addresses': 'blockedIpOrClassCAddresses',
        'maximum_purchase_amount': 'maximumPurchaseAmount',
        'lockout_time': 'lockoutTime',
        'country_profile': 'countryProfile'
    }

    def __init__(self, store_id=None, blocked_card_numbers=None, blocked_names=None, blocked_domain_names=None, blocked_ip_or_class_c_addresses=None, maximum_purchase_amount=None, lockout_time=None, country_profile=None, local_vars_configuration=None):  # noqa: E501
        """FraudSettingsResponseAllOf - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._store_id = None
        self._blocked_card_numbers = None
        self._blocked_names = None
        self._blocked_domain_names = None
        self._blocked_ip_or_class_c_addresses = None
        self._maximum_purchase_amount = None
        self._lockout_time = None
        self._country_profile = None
        self.discriminator = None

        if store_id is not None:
            self.store_id = store_id
        if blocked_card_numbers is not None:
            self.blocked_card_numbers = blocked_card_numbers
        if blocked_names is not None:
            self.blocked_names = blocked_names
        if blocked_domain_names is not None:
            self.blocked_domain_names = blocked_domain_names
        if blocked_ip_or_class_c_addresses is not None:
            self.blocked_ip_or_class_c_addresses = blocked_ip_or_class_c_addresses
        if maximum_purchase_amount is not None:
            self.maximum_purchase_amount = maximum_purchase_amount
        if lockout_time is not None:
            self.lockout_time = lockout_time
        if country_profile is not None:
            self.country_profile = country_profile

    @property
    def store_id(self):
        """Gets the store_id of this FraudSettingsResponseAllOf.  # noqa: E501

        The outlet ID.  # noqa: E501

        :return: The store_id of this FraudSettingsResponseAllOf.  # noqa: E501
        :rtype: str
        """
        return self._store_id

    @store_id.setter
    def store_id(self, store_id):
        """Sets the store_id of this FraudSettingsResponseAllOf.

        The outlet ID.  # noqa: E501

        :param store_id: The store_id of this FraudSettingsResponseAllOf.  # noqa: E501
        :type: str
        """

        self._store_id = store_id

    @property
    def blocked_card_numbers(self):
        """Gets the blocked_card_numbers of this FraudSettingsResponseAllOf.  # noqa: E501

        List of blocked card numbers.  # noqa: E501

        :return: The blocked_card_numbers of this FraudSettingsResponseAllOf.  # noqa: E501
        :rtype: list[BlockedCardNumber]
        """
        return self._blocked_card_numbers

    @blocked_card_numbers.setter
    def blocked_card_numbers(self, blocked_card_numbers):
        """Sets the blocked_card_numbers of this FraudSettingsResponseAllOf.

        List of blocked card numbers.  # noqa: E501

        :param blocked_card_numbers: The blocked_card_numbers of this FraudSettingsResponseAllOf.  # noqa: E501
        :type: list[BlockedCardNumber]
        """

        self._blocked_card_numbers = blocked_card_numbers

    @property
    def blocked_names(self):
        """Gets the blocked_names of this FraudSettingsResponseAllOf.  # noqa: E501

        List of blocked fraud names.  # noqa: E501

        :return: The blocked_names of this FraudSettingsResponseAllOf.  # noqa: E501
        :rtype: list[str]
        """
        return self._blocked_names

    @blocked_names.setter
    def blocked_names(self, blocked_names):
        """Sets the blocked_names of this FraudSettingsResponseAllOf.

        List of blocked fraud names.  # noqa: E501

        :param blocked_names: The blocked_names of this FraudSettingsResponseAllOf.  # noqa: E501
        :type: list[str]
        """

        self._blocked_names = blocked_names

    @property
    def blocked_domain_names(self):
        """Gets the blocked_domain_names of this FraudSettingsResponseAllOf.  # noqa: E501

        List of blocked fraud domain names.  # noqa: E501

        :return: The blocked_domain_names of this FraudSettingsResponseAllOf.  # noqa: E501
        :rtype: list[str]
        """
        return self._blocked_domain_names

    @blocked_domain_names.setter
    def blocked_domain_names(self, blocked_domain_names):
        """Sets the blocked_domain_names of this FraudSettingsResponseAllOf.

        List of blocked fraud domain names.  # noqa: E501

        :param blocked_domain_names: The blocked_domain_names of this FraudSettingsResponseAllOf.  # noqa: E501
        :type: list[str]
        """

        self._blocked_domain_names = blocked_domain_names

    @property
    def blocked_ip_or_class_c_addresses(self):
        """Gets the blocked_ip_or_class_c_addresses of this FraudSettingsResponseAllOf.  # noqa: E501

        List of blocked fraud IP address/Class C.  # noqa: E501

        :return: The blocked_ip_or_class_c_addresses of this FraudSettingsResponseAllOf.  # noqa: E501
        :rtype: list[str]
        """
        return self._blocked_ip_or_class_c_addresses

    @blocked_ip_or_class_c_addresses.setter
    def blocked_ip_or_class_c_addresses(self, blocked_ip_or_class_c_addresses):
        """Sets the blocked_ip_or_class_c_addresses of this FraudSettingsResponseAllOf.

        List of blocked fraud IP address/Class C.  # noqa: E501

        :param blocked_ip_or_class_c_addresses: The blocked_ip_or_class_c_addresses of this FraudSettingsResponseAllOf.  # noqa: E501
        :type: list[str]
        """

        self._blocked_ip_or_class_c_addresses = blocked_ip_or_class_c_addresses

    @property
    def maximum_purchase_amount(self):
        """Gets the maximum_purchase_amount of this FraudSettingsResponseAllOf.  # noqa: E501

        Maximum purchase amount limit.  # noqa: E501

        :return: The maximum_purchase_amount of this FraudSettingsResponseAllOf.  # noqa: E501
        :rtype: list[MaximumPurchaseAmount]
        """
        return self._maximum_purchase_amount

    @maximum_purchase_amount.setter
    def maximum_purchase_amount(self, maximum_purchase_amount):
        """Sets the maximum_purchase_amount of this FraudSettingsResponseAllOf.

        Maximum purchase amount limit.  # noqa: E501

        :param maximum_purchase_amount: The maximum_purchase_amount of this FraudSettingsResponseAllOf.  # noqa: E501
        :type: list[MaximumPurchaseAmount]
        """

        self._maximum_purchase_amount = maximum_purchase_amount

    @property
    def lockout_time(self):
        """Gets the lockout_time of this FraudSettingsResponseAllOf.  # noqa: E501


        :return: The lockout_time of this FraudSettingsResponseAllOf.  # noqa: E501
        :rtype: LockoutTime
        """
        return self._lockout_time

    @lockout_time.setter
    def lockout_time(self, lockout_time):
        """Sets the lockout_time of this FraudSettingsResponseAllOf.


        :param lockout_time: The lockout_time of this FraudSettingsResponseAllOf.  # noqa: E501
        :type: LockoutTime
        """

        self._lockout_time = lockout_time

    @property
    def country_profile(self):
        """Gets the country_profile of this FraudSettingsResponseAllOf.  # noqa: E501

        Country profile.  # noqa: E501

        :return: The country_profile of this FraudSettingsResponseAllOf.  # noqa: E501
        :rtype: str
        """
        return self._country_profile

    @country_profile.setter
    def country_profile(self, country_profile):
        """Sets the country_profile of this FraudSettingsResponseAllOf.

        Country profile.  # noqa: E501

        :param country_profile: The country_profile of this FraudSettingsResponseAllOf.  # noqa: E501
        :type: str
        """

        self._country_profile = country_profile

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FraudSettingsResponseAllOf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FraudSettingsResponseAllOf):
            return True

        return self.to_dict() != other.to_dict()
