# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 6.12.0.20200605.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openapi_client.configuration import Configuration


class DecryptedSamsungPay(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_number': 'str',
        'expiration': 'str',
        'currency_code': 'str',
        'amount': 'float',
        'cardholder_name': 'str',
        'brand': 'str',
        'cryptogram': 'str',
        'eci_indicator': 'str'
    }

    attribute_map = {
        'account_number': 'accountNumber',
        'expiration': 'expiration',
        'currency_code': 'currencyCode',
        'amount': 'amount',
        'cardholder_name': 'cardholderName',
        'brand': 'brand',
        'cryptogram': 'cryptogram',
        'eci_indicator': 'eciIndicator'
    }

    def __init__(self, account_number=None, expiration=None, currency_code=None, amount=None, cardholder_name=None, brand=None, cryptogram=None, eci_indicator=None, local_vars_configuration=None):  # noqa: E501
        """DecryptedSamsungPay - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_number = None
        self._expiration = None
        self._currency_code = None
        self._amount = None
        self._cardholder_name = None
        self._brand = None
        self._cryptogram = None
        self._eci_indicator = None
        self.discriminator = None

        self.account_number = account_number
        self.expiration = expiration
        self.currency_code = currency_code
        self.amount = amount
        self.cardholder_name = cardholder_name
        self.brand = brand
        self.cryptogram = cryptogram
        self.eci_indicator = eci_indicator

    @property
    def account_number(self):
        """Gets the account_number of this DecryptedSamsungPay.  # noqa: E501

        Payment card number.  # noqa: E501

        :return: The account_number of this DecryptedSamsungPay.  # noqa: E501
        :rtype: str
        """
        return self._account_number

    @account_number.setter
    def account_number(self, account_number):
        """Sets the account_number of this DecryptedSamsungPay.

        Payment card number.  # noqa: E501

        :param account_number: The account_number of this DecryptedSamsungPay.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and account_number is None:  # noqa: E501
            raise ValueError("Invalid value for `account_number`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                account_number is not None and not re.search(r'[0-9]{13,19}', account_number)):  # noqa: E501
            raise ValueError(r"Invalid value for `account_number`, must be a follow pattern or equal to `/[0-9]{13,19}/`")  # noqa: E501

        self._account_number = account_number

    @property
    def expiration(self):
        """Gets the expiration of this DecryptedSamsungPay.  # noqa: E501

        Card expiration date in MMYYYY format.  # noqa: E501

        :return: The expiration of this DecryptedSamsungPay.  # noqa: E501
        :rtype: str
        """
        return self._expiration

    @expiration.setter
    def expiration(self, expiration):
        """Sets the expiration of this DecryptedSamsungPay.

        Card expiration date in MMYYYY format.  # noqa: E501

        :param expiration: The expiration of this DecryptedSamsungPay.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and expiration is None:  # noqa: E501
            raise ValueError("Invalid value for `expiration`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                expiration is not None and not re.search(r'[0-9]{6}', expiration)):  # noqa: E501
            raise ValueError(r"Invalid value for `expiration`, must be a follow pattern or equal to `/[0-9]{6}/`")  # noqa: E501

        self._expiration = expiration

    @property
    def currency_code(self):
        """Gets the currency_code of this DecryptedSamsungPay.  # noqa: E501

        Numeric currency code following ISO 4217 standards.  # noqa: E501

        :return: The currency_code of this DecryptedSamsungPay.  # noqa: E501
        :rtype: str
        """
        return self._currency_code

    @currency_code.setter
    def currency_code(self, currency_code):
        """Sets the currency_code of this DecryptedSamsungPay.

        Numeric currency code following ISO 4217 standards.  # noqa: E501

        :param currency_code: The currency_code of this DecryptedSamsungPay.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and currency_code is None:  # noqa: E501
            raise ValueError("Invalid value for `currency_code`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                currency_code is not None and not re.search(r'[0-9]{3}', currency_code)):  # noqa: E501
            raise ValueError(r"Invalid value for `currency_code`, must be a follow pattern or equal to `/[0-9]{3}/`")  # noqa: E501

        self._currency_code = currency_code

    @property
    def amount(self):
        """Gets the amount of this DecryptedSamsungPay.  # noqa: E501

        Amount total.  # noqa: E501

        :return: The amount of this DecryptedSamsungPay.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this DecryptedSamsungPay.

        Amount total.  # noqa: E501

        :param amount: The amount of this DecryptedSamsungPay.  # noqa: E501
        :type: float
        """
        if self.local_vars_configuration.client_side_validation and amount is None:  # noqa: E501
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def cardholder_name(self):
        """Gets the cardholder_name of this DecryptedSamsungPay.  # noqa: E501

        Name of the cardholder.  # noqa: E501

        :return: The cardholder_name of this DecryptedSamsungPay.  # noqa: E501
        :rtype: str
        """
        return self._cardholder_name

    @cardholder_name.setter
    def cardholder_name(self, cardholder_name):
        """Sets the cardholder_name of this DecryptedSamsungPay.

        Name of the cardholder.  # noqa: E501

        :param cardholder_name: The cardholder_name of this DecryptedSamsungPay.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and cardholder_name is None:  # noqa: E501
            raise ValueError("Invalid value for `cardholder_name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                cardholder_name is not None and len(cardholder_name) > 96):
            raise ValueError("Invalid value for `cardholder_name`, length must be less than or equal to `96`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                cardholder_name is not None and not re.search(r'^(?!\s*$).+', cardholder_name)):  # noqa: E501
            raise ValueError(r"Invalid value for `cardholder_name`, must be a follow pattern or equal to `/^(?!\s*$).+/`")  # noqa: E501

        self._cardholder_name = cardholder_name

    @property
    def brand(self):
        """Gets the brand of this DecryptedSamsungPay.  # noqa: E501

        Card brand.  # noqa: E501

        :return: The brand of this DecryptedSamsungPay.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """Sets the brand of this DecryptedSamsungPay.

        Card brand.  # noqa: E501

        :param brand: The brand of this DecryptedSamsungPay.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and brand is None:  # noqa: E501
            raise ValueError("Invalid value for `brand`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                brand is not None and not re.search(r'^(?!\s*$).+', brand)):  # noqa: E501
            raise ValueError(r"Invalid value for `brand`, must be a follow pattern or equal to `/^(?!\s*$).+/`")  # noqa: E501

        self._brand = brand

    @property
    def cryptogram(self):
        """Gets the cryptogram of this DecryptedSamsungPay.  # noqa: E501

        The wallet cryptogram from the decrypted data.  # noqa: E501

        :return: The cryptogram of this DecryptedSamsungPay.  # noqa: E501
        :rtype: str
        """
        return self._cryptogram

    @cryptogram.setter
    def cryptogram(self, cryptogram):
        """Sets the cryptogram of this DecryptedSamsungPay.

        The wallet cryptogram from the decrypted data.  # noqa: E501

        :param cryptogram: The cryptogram of this DecryptedSamsungPay.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and cryptogram is None:  # noqa: E501
            raise ValueError("Invalid value for `cryptogram`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                cryptogram is not None and not re.search(r'^(?!\s*$).+', cryptogram)):  # noqa: E501
            raise ValueError(r"Invalid value for `cryptogram`, must be a follow pattern or equal to `/^(?!\s*$).+/`")  # noqa: E501

        self._cryptogram = cryptogram

    @property
    def eci_indicator(self):
        """Gets the eci_indicator of this DecryptedSamsungPay.  # noqa: E501

        The ECI indicator from the decrypted data.  # noqa: E501

        :return: The eci_indicator of this DecryptedSamsungPay.  # noqa: E501
        :rtype: str
        """
        return self._eci_indicator

    @eci_indicator.setter
    def eci_indicator(self, eci_indicator):
        """Sets the eci_indicator of this DecryptedSamsungPay.

        The ECI indicator from the decrypted data.  # noqa: E501

        :param eci_indicator: The eci_indicator of this DecryptedSamsungPay.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and eci_indicator is None:  # noqa: E501
            raise ValueError("Invalid value for `eci_indicator`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                eci_indicator is not None and not re.search(r'[0-9]{2}', eci_indicator)):  # noqa: E501
            raise ValueError(r"Invalid value for `eci_indicator`, must be a follow pattern or equal to `/[0-9]{2}/`")  # noqa: E501

        self._eci_indicator = eci_indicator

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DecryptedSamsungPay):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DecryptedSamsungPay):
            return True

        return self.to_dict() != other.to_dict()
