# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 6.12.0.20200605.001
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openapi_client.api_client import ApiClient
from openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class OrderApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def order_inquiry(self, content_type, client_request_id, api_key, timestamp, order_id, **kwargs):  # noqa: E501
        """Retrieve the state of an order.  # noqa: E501

        Use this query to get the current state of an existing order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.order_inquiry(content_type, client_request_id, api_key, timestamp, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_type: Content type. (required)
        :param str client_request_id: A client-generated ID for request tracking and signature creation, unique per request.  This is also used for idempotency control. We recommend 128-bit UUID format. (required)
        :param str api_key: Key given to merchant after boarding associating their requests with the appropriate app in Apigee. (required)
        :param int timestamp: Epoch timestamp in milliseconds in the request from a client system. Used for Message Signature generation and time limit (5 mins). (required)
        :param str order_id: Gateway order identifier as returned in the parameter orderId. (required)
        :param str message_signature: Used to ensure the request has not been tampered with during transmission. The Message-Signature is the Base64 encoded HMAC hash (SHA256 algorithm with the API Secret as the key.) For more information, refer to the supporting documentation on the Developer Portal.
        :param str region: Indicates the region where the client wants the transaction to be processed. This will override the default processing region identified for the client. Available options are argentina, brazil, germany, india and northamerica. Region specific store setup and APIGEE boarding is required in order to use an alternate region for processing.
        :param str store_id: An optional outlet ID for clients that support multiple stores in the same developer app.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: OrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.order_inquiry_with_http_info(content_type, client_request_id, api_key, timestamp, order_id, **kwargs)  # noqa: E501

    def order_inquiry_with_http_info(self, content_type, client_request_id, api_key, timestamp, order_id, **kwargs):  # noqa: E501
        """Retrieve the state of an order.  # noqa: E501

        Use this query to get the current state of an existing order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.order_inquiry_with_http_info(content_type, client_request_id, api_key, timestamp, order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_type: Content type. (required)
        :param str client_request_id: A client-generated ID for request tracking and signature creation, unique per request.  This is also used for idempotency control. We recommend 128-bit UUID format. (required)
        :param str api_key: Key given to merchant after boarding associating their requests with the appropriate app in Apigee. (required)
        :param int timestamp: Epoch timestamp in milliseconds in the request from a client system. Used for Message Signature generation and time limit (5 mins). (required)
        :param str order_id: Gateway order identifier as returned in the parameter orderId. (required)
        :param str message_signature: Used to ensure the request has not been tampered with during transmission. The Message-Signature is the Base64 encoded HMAC hash (SHA256 algorithm with the API Secret as the key.) For more information, refer to the supporting documentation on the Developer Portal.
        :param str region: Indicates the region where the client wants the transaction to be processed. This will override the default processing region identified for the client. Available options are argentina, brazil, germany, india and northamerica. Region specific store setup and APIGEE boarding is required in order to use an alternate region for processing.
        :param str store_id: An optional outlet ID for clients that support multiple stores in the same developer app.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(OrderResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'content_type',
            'client_request_id',
            'api_key',
            'timestamp',
            'order_id',
            'message_signature',
            'region',
            'store_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method order_inquiry" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'content_type' is set
        if self.api_client.client_side_validation and ('content_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['content_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `content_type` when calling `order_inquiry`")  # noqa: E501
        # verify the required parameter 'client_request_id' is set
        if self.api_client.client_side_validation and ('client_request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['client_request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `client_request_id` when calling `order_inquiry`")  # noqa: E501
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `api_key` when calling `order_inquiry`")  # noqa: E501
        # verify the required parameter 'timestamp' is set
        if self.api_client.client_side_validation and ('timestamp' not in local_var_params or  # noqa: E501
                                                        local_var_params['timestamp'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `timestamp` when calling `order_inquiry`")  # noqa: E501
        # verify the required parameter 'order_id' is set
        if self.api_client.client_side_validation and ('order_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['order_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `order_id` when calling `order_inquiry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in local_var_params:
            path_params['order-id'] = local_var_params['order_id']  # noqa: E501

        query_params = []
        if 'store_id' in local_var_params and local_var_params['store_id'] is not None:  # noqa: E501
            query_params.append(('storeId', local_var_params['store_id']))  # noqa: E501

        header_params = {}
        if 'content_type' in local_var_params:
            header_params['Content-Type'] = local_var_params['content_type']  # noqa: E501
        if 'client_request_id' in local_var_params:
            header_params['Client-Request-Id'] = local_var_params['client_request_id']  # noqa: E501
        if 'api_key' in local_var_params:
            header_params['Api-Key'] = local_var_params['api_key']  # noqa: E501
        if 'timestamp' in local_var_params:
            header_params['Timestamp'] = local_var_params['timestamp']  # noqa: E501
        if 'message_signature' in local_var_params:
            header_params['Message-Signature'] = local_var_params['message_signature']  # noqa: E501
        if 'region' in local_var_params:
            header_params['Region'] = local_var_params['region']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/orders/{order-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def submit_secondary_transaction_from_order(self, content_type, client_request_id, api_key, timestamp, order_id, secondary_transaction, **kwargs):  # noqa: E501
        """Perform return or postAuth secondary transactions.  # noqa: E501

        Use this to perform a postAuth or return secondary transaction using order ID. Partial postAuths and returns are allowed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_secondary_transaction_from_order(content_type, client_request_id, api_key, timestamp, order_id, secondary_transaction, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_type: Content type. (required)
        :param str client_request_id: A client-generated ID for request tracking and signature creation, unique per request.  This is also used for idempotency control. We recommend 128-bit UUID format. (required)
        :param str api_key: Key given to merchant after boarding associating their requests with the appropriate app in Apigee. (required)
        :param int timestamp: Epoch timestamp in milliseconds in the request from a client system. Used for Message Signature generation and time limit (5 mins). (required)
        :param str order_id: Gateway order identifier as returned in the parameter orderId. (required)
        :param SecondaryTransaction secondary_transaction: Accepted request types: PostAuthTransaction, VoidTransaction, VoidPreAuthTransactions, ReturnTransaction, AchPostAuthTransaction, AchVoidTransaction and AchReturnTransaction. (required)
        :param str message_signature: Used to ensure the request has not been tampered with during transmission. The Message-Signature is the Base64 encoded HMAC hash (SHA256 algorithm with the API Secret as the key.) For more information, refer to the supporting documentation on the Developer Portal.
        :param str region: Indicates the region where the client wants the transaction to be processed. This will override the default processing region identified for the client. Available options are argentina, brazil, germany, india and northamerica. Region specific store setup and APIGEE boarding is required in order to use an alternate region for processing.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TransactionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.submit_secondary_transaction_from_order_with_http_info(content_type, client_request_id, api_key, timestamp, order_id, secondary_transaction, **kwargs)  # noqa: E501

    def submit_secondary_transaction_from_order_with_http_info(self, content_type, client_request_id, api_key, timestamp, order_id, secondary_transaction, **kwargs):  # noqa: E501
        """Perform return or postAuth secondary transactions.  # noqa: E501

        Use this to perform a postAuth or return secondary transaction using order ID. Partial postAuths and returns are allowed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_secondary_transaction_from_order_with_http_info(content_type, client_request_id, api_key, timestamp, order_id, secondary_transaction, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str content_type: Content type. (required)
        :param str client_request_id: A client-generated ID for request tracking and signature creation, unique per request.  This is also used for idempotency control. We recommend 128-bit UUID format. (required)
        :param str api_key: Key given to merchant after boarding associating their requests with the appropriate app in Apigee. (required)
        :param int timestamp: Epoch timestamp in milliseconds in the request from a client system. Used for Message Signature generation and time limit (5 mins). (required)
        :param str order_id: Gateway order identifier as returned in the parameter orderId. (required)
        :param SecondaryTransaction secondary_transaction: Accepted request types: PostAuthTransaction, VoidTransaction, VoidPreAuthTransactions, ReturnTransaction, AchPostAuthTransaction, AchVoidTransaction and AchReturnTransaction. (required)
        :param str message_signature: Used to ensure the request has not been tampered with during transmission. The Message-Signature is the Base64 encoded HMAC hash (SHA256 algorithm with the API Secret as the key.) For more information, refer to the supporting documentation on the Developer Portal.
        :param str region: Indicates the region where the client wants the transaction to be processed. This will override the default processing region identified for the client. Available options are argentina, brazil, germany, india and northamerica. Region specific store setup and APIGEE boarding is required in order to use an alternate region for processing.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TransactionResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'content_type',
            'client_request_id',
            'api_key',
            'timestamp',
            'order_id',
            'secondary_transaction',
            'message_signature',
            'region'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_secondary_transaction_from_order" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'content_type' is set
        if self.api_client.client_side_validation and ('content_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['content_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `content_type` when calling `submit_secondary_transaction_from_order`")  # noqa: E501
        # verify the required parameter 'client_request_id' is set
        if self.api_client.client_side_validation and ('client_request_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['client_request_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `client_request_id` when calling `submit_secondary_transaction_from_order`")  # noqa: E501
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `api_key` when calling `submit_secondary_transaction_from_order`")  # noqa: E501
        # verify the required parameter 'timestamp' is set
        if self.api_client.client_side_validation and ('timestamp' not in local_var_params or  # noqa: E501
                                                        local_var_params['timestamp'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `timestamp` when calling `submit_secondary_transaction_from_order`")  # noqa: E501
        # verify the required parameter 'order_id' is set
        if self.api_client.client_side_validation and ('order_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['order_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `order_id` when calling `submit_secondary_transaction_from_order`")  # noqa: E501
        # verify the required parameter 'secondary_transaction' is set
        if self.api_client.client_side_validation and ('secondary_transaction' not in local_var_params or  # noqa: E501
                                                        local_var_params['secondary_transaction'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `secondary_transaction` when calling `submit_secondary_transaction_from_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'order_id' in local_var_params:
            path_params['order-id'] = local_var_params['order_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'content_type' in local_var_params:
            header_params['Content-Type'] = local_var_params['content_type']  # noqa: E501
        if 'client_request_id' in local_var_params:
            header_params['Client-Request-Id'] = local_var_params['client_request_id']  # noqa: E501
        if 'api_key' in local_var_params:
            header_params['Api-Key'] = local_var_params['api_key']  # noqa: E501
        if 'timestamp' in local_var_params:
            header_params['Timestamp'] = local_var_params['timestamp']  # noqa: E501
        if 'message_signature' in local_var_params:
            header_params['Message-Signature'] = local_var_params['message_signature']  # noqa: E501
        if 'region' in local_var_params:
            header_params['Region'] = local_var_params['region']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'secondary_transaction' in local_var_params:
            body_params = local_var_params['secondary_transaction']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/orders/{order-id}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TransactionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
