import { Construct, IConstruct } from "constructs";
import { ConstructInfo } from "../cdk-internals";
import { FlagEnum, SerializedGraph, UnresolvedReference, UUID } from "./types";
/**
 * Generate deterministic UUID based on given value and prefix.
 * @param value The value to hash as UUID
 * @param {string} [prefix=""] Optional prefix used to prevent value conflicts
 */
export declare function generateConsistentUUID(value: any, prefix?: string): string;
/** Get UUID for a given construct */
export declare function getConstructUUID(construct: IConstruct): string;
/** Try to get *logicalId* for given construct */
export declare function tryGetLogicalId(construct: IConstruct): string | undefined;
/** Inferred node props */
export interface InferredNodeProps extends SerializedGraph.Entity {
    readonly logicalId?: string;
    readonly cfnType?: string;
    readonly constructInfo?: ConstructInfo;
    readonly dependencies: UUID[];
    readonly unresolvedReferences: UnresolvedReference[];
}
/** Infer node props from construct */
export declare function inferNodeProps(construct: Construct): InferredNodeProps;
/** Extract inspectable attributes from construct */
export declare function extractInspectableAttributes(construct: IConstruct): SerializedGraph.Attributes | undefined;
/** Pattern of ignored references. Those which are resolved during deploy-time. */
export declare const IGNORE_REF_PATTERN: RegExp;
/** Extract unresolved references from attributes for a given source */
export declare function extractUnresolvedReferences(source: UUID, from: SerializedGraph.Attributes): UnresolvedReference[];
/** Infer construct flags  */
export declare function inferFlags(construct: IConstruct, constructInfo?: ConstructInfo): FlagEnum[];
