"use strict";
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveOutdir = exports.resolveConfig = exports.DEFAULT_OUTDIR = exports.CDK_OUTDIR_VAR = exports.CDK_GRAPH_RC = void 0;
const findUp = require("find-up"); // eslint-disable-line @typescript-eslint/no-require-imports
/** CdkGraph config file name */
exports.CDK_GRAPH_RC = ".cdkgraphrc.js";
/** Variable replacement token for cdk.out directory */
exports.CDK_OUTDIR_VAR = "<cdk.out>";
/** Default graph artifact output directory */
exports.DEFAULT_OUTDIR = `${exports.CDK_OUTDIR_VAR}/cdkgraph`;
/** Default CdkGraph configuration */
const DEFAULT_CONFIG = {
    outdir: exports.DEFAULT_OUTDIR,
};
/**
 * Resolve CdkGraph runtime configuration. Will detect local file system config if available and
 * merge with default configuration.
 * @internal
 */
function resolveConfig(cwd) {
    const config = findUp.sync(exports.CDK_GRAPH_RC, { cwd });
    if (config) {
        return {
            ...DEFAULT_CONFIG,
            ...require(config),
        };
    }
    return { ...DEFAULT_CONFIG };
}
exports.resolveConfig = resolveConfig;
/**
 * Resolve CdkGraph output directory. Performs replacement of tokens in config path.
 * @internal
 */
function resolveOutdir(cdkOutdir, outdir = exports.DEFAULT_OUTDIR) {
    return outdir.replace(exports.CDK_OUTDIR_VAR, cdkOutdir);
}
exports.resolveOutdir = resolveOutdir;
//# sourceMappingURL=data:application/json;base64,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