#!/usr/bin/env python
# encoding: utf-8
#
# Copyright SAS Institute
#
#  Licensed under the Apache License, Version 2.0 (the License);
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

# NOTE: This test requires a running ESP server.  You must use an ~/.authinfo
#       file to specify your username and password.  The ESP host and port must
#       be specified using the ESPHOST and ESPPORT environment variables.
#       A specific protocol ('http' or 'https') can be set using
#       the ESPPROTOCOL environment variable.

import os
import unittest
import esppy
from . import utils as tm


class TestComputeWindow(tm.WindowTestCase):

    def test_xml(self):
        self._test_model_file('compute_field_expression.xml')

    def test_field_expression(self):
        esp = self.s

        proj = esp.create_project('project_01_UnitTest')

        cq = esp.ContinuousQuery(name='cq_01')

        src = esp.SourceWindow(name='src_win',
                               schema=('name:string','ID*:int32','city:string'))
        src.add_connector('fs', conn_name='pub', conn_type='publish',
                          type='pub',
                          fstype='csv',
                          fsname='compute_field_expression.csv',
                          transactional=True,
                          blocksize='1')

        compute_win = esp.ComputeWindow(name='computeWindow',
                                        schema=('ID*:int32', 'name:string',
                                                'city:string','match:string'))
        compute_win.set_expr_initializer(expr='integer counter counter=0',type='int32')
        compute_win.add_field_expressions('name', 'city',
                                          'counter=counter+1 return counter')
        compute_win.add_connector('fs',
                                   conn_name='sub', conn_type='subscribe',
                                   type='sub',
                                   fstype='csv',
                                   fsname='result.out',
                                   snapshot=True)

        proj.add_query(cq)
        cq.add_window(src)
        cq.add_window(compute_win)

        src.add_target(compute_win)

        self._test_model_file('compute_field_expression.xml', proj)

    @unittest.skip('Need way to load plugin')
    def test_plugin(self):
        esp = self.s

        proj = esp.create_project('project_01_UnitTest', pubsub='auto', n_threads='1')

        cq = esp.ContinuousQuery(name='cq_01')

        src = esp.SourceWindow(name='src_win',
                               schema=('ID*:int64','symbol:string',
                                       'price:double','markup:double'),
                               index_type='hash', collapse_updates=True)
        src.add_connector('fs',
                          conn_name='pub', conn_type='publish',
                          type='pub',
                          fstype='csv',
                          fsname='compute_plugin.csv',
                          transactional=True,
                          blocksize='1')

        compute_win = esp.ComputeWindow(name='compute',
                                        schema=('ID*:int64','symbol:string',
                                                'price:double','markup:double',
                                                'sum:double','diff:double',
                                                'prod:double','quot:double'),
                                        collapse_updates=True)
        compute_win.set_context_plugin('libmethod','get_context')
        compute_win.add_field_plugin('libmethod', ['copyScalarFunction',
                                                   'copyScalarFunction',
                                                   'copyScalarFunction',
                                                   'arithScalarFunction',
                                                   'arithScalarFunction',
                                                   'arithScalarFunction',
                                                   'arithScalarFunction'])
        compute_win.add_connector('fs',
                                  conn_name='sub', conn_type='subscribe',
                                  type='sub',
                                  fstype='csv',
                                  fsname='result.out',
                                  snapshot=True)

        proj.add_query(cq)
        cq.add_window(src)
        cq.add_window(compute_win)

        src.add_target(compute_win)

        self._test_model_file('compute_plugin.xml', proj)
