#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['freezerbox', 'freezerbox.cli', 'freezerbox.loaders', 'freezerbox.stepwise']

package_data = \
{'': ['*'],
 'freezerbox': ['.pytest_cache/*',
                '.pytest_cache/v/*',
                '.pytest_cache/v/cache/*'],
 'freezerbox.stepwise': ['.pytest_cache/*',
                         '.pytest_cache/v/*',
                         '.pytest_cache/v/cache/*']}

install_requires = \
['appdirs',
 'autoprop',
 'autosnapgene',
 'Biopython',
 'configurator',
 'docopt',
 'inform>=1.21',
 'more_itertools>=8.0',
 'pandas',
 'parsy',
 'setuptools',
 'stepwise',
 'stepwise_mol_bio',
 'tabulate',
 'toml',
 'tqdm',
 'voluptuous',
 'xlrd>=1.0']

extras_require = \
{'doc': ['sphinx', 'sphinx_rtd_theme', 'autoclasstoc'],
 'test': ['pytest', 'pytest-cov', 'coveralls']}

entry_points = \
{'console_scripts': ['freezerbox = freezerbox.cli.main:main'],
 'freezerbox.databases': ['excel = freezerbox.loaders.excel'],
 'stepwise.protocols': ['protocols = freezerbox.stepwise:Plugin']}

setup(name='freezerbox',
      version='0.1.0',
      description='Database of DNA sequences.',
      author='Kale Kundert',
      author_email='kale@thekunderts.net',
      url='https://github.com/kalekundert/freezerbox',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='~=3.6',
     )
