import { IAwsInvoker } from '../../interface/aws-invoker';
import { ISleepHook } from '../../interface/sleep-hook';
import { CreateStackStep, IParameterResolver } from '../../parent-steps/automation/create-stack-step';
import { AutomationSimulationBase } from './automation-simulation-base';
/**
 * Properties for CreateStackStep
 */
export interface CreateStackSimulationProps {
    /**
       * (Optional) Use this as a hook to inject an alternate IAwsInvoker (for mocking the AWS API call).
       * @default - will perform a real invocation of the JavaScript AWS SDK using ReflectiveAwsInvoker class.
       */
    readonly awsInvoker: IAwsInvoker;
    /**
       * (Optional) Whether to really perform a pause of the runtime.
       * To override sleep behavior, inject an ISleepHook impl or use the provided MockSleep class.
       * @default SleeperImpl
       */
    readonly sleepHook: ISleepHook;
    /**
     * (Optional) Resolver for secure strings in parameters.
     * Required to simulate if using tokens in parameters input.
     * @default - Treats parameters as literal
     */
    readonly parameterResolver: IParameterResolver;
}
/**
 * AutomationStep implementation for aws:createStack
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-createstack.html
 */
export declare class CreateStackSimulation extends AutomationSimulationBase {
    private static readonly InProgressStatuses;
    readonly action: string;
    private creatStackStep;
    private props;
    constructor(step: CreateStackStep, props: CreateStackSimulationProps);
    executeStep(inputs: Record<string, any>): Record<string, any>;
    private verifyUrlProps;
    private verifyUrlProp;
    private preVerifyStackSubStep;
    private preVerifyStack;
    private isStackOperationInProgress;
    private createStack;
    private resolveSecureStringsInParametersInput;
    private getStackState;
    private waitForStackCompletion;
}
