/**
 * This can be used to provide a hook for approval implementation for ApproveStep.
 */
export interface IApproveHook {
    /**
       * Ask for approval
       */
    ask(approver: string): boolean;
}
/**
 * This IApproveHook implementation provides a real ask and waits for user input of Enter.
 * This implementation does not work well on all exported JSII languages.
 * Users can provide their own impl using the IAskHook interface.
 */
export declare class ApproveImpl implements IApproveHook {
    ask(approver: string): boolean;
}
/**
 * Mock implementation of IApproveHook. Does not simulate an approval request.
 */
export declare class MockApprove implements IApproveHook {
    timesInvoked: number;
    ask(_approver: string): boolean;
}
