"""
pySeqLib: A small python library to process sequencing data.
"""

# Always prefer setuptools over distutils
from setuptools import setup, find_packages
# To use a consistent encoding
from codecs import open
from os import path
from Cython.Build import cythonize

here = path.abspath(path.dirname(__file__))

# Set __version__ for the project.
exec(open("./pyseqlib/version.py").read())

# Get the long description from the relevant file
with open(path.join(here, 'README.rst'), encoding='utf-8') as f:
    long_description = f.read()
    
reqs = ['pysam', 'Cython', 'numpy']

setup(
    name='pyseqlib',

    # Versions should comply with PEP440.  For a discussion on single-sourcing
    # the version across setup.py and the project code, see
    # https://packaging.python.org/en/latest/single_source_version.html
    version=__version__,

    description='pySeqLib: A small python library to process sequencing data.',
    long_description=long_description,

    # The project's main homepage.
    url='https://github.com/huangyh09/pyseqlib',

    # Author details
    author='Yuanhua Huang',
    author_email='yuanhua@ebi.ac.uk',

    # Choose your license
    license='Apache-2.0',

    # What does your project relate to?
    keywords=['sequencing data processing'],

    # You can just specify the packages manually here if your project is
    # simple. Or you can use find_packages().
    packages=find_packages(),#[''],#
    ext_modules=cythonize('pyseqlib/utils/*.pyx'),
    entry_points={
          'console_scripts': [
          'pymfold = pyseqlib.pymfold:main',
          'pyRNAfold = pyseqlib.pyRNAfold:main',
          'intronX = pyseqlib.intronX.intronX:main',
          'lariat-map = pyseqlib.lariat_map:main',
          'motif-score = pyseqlib.motif_score:main',
            ],
          }, 

    # List run-time dependencies here.  These will be installed by pip when
    # your project is installed. For an analysis of "install_requires" vs pip's
    # requirements files see:
    # https://packaging.python.org/en/latest/requirements.html
    
    install_requires=reqs,

    py_modules = ['pyseqlib']

    # buid the distribution: python setup.py sdist
    # upload to pypi: twine upload dist/...

)
