# coding: utf-8

"""
    flyteidl/service/admin.proto

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: version not set
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from flyteadmin.api_client import ApiClient


class AdminServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_execution(self, body, **kwargs):  # noqa: E501
        """Triggers the creation of a :ref:`ref_flyteidl.admin.Execution`  # noqa: E501

        Create a workflow execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_execution(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminExecutionCreateRequest body: (required)
        :return: AdminExecutionCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_execution_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_execution_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_execution_with_http_info(self, body, **kwargs):  # noqa: E501
        """Triggers the creation of a :ref:`ref_flyteidl.admin.Execution`  # noqa: E501

        Create a workflow execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_execution_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminExecutionCreateRequest body: (required)
        :return: AdminExecutionCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_execution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_execution`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/executions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminExecutionCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_launch_plan(self, body, **kwargs):  # noqa: E501
        """Create and upload a :ref:`ref_flyteidl.admin.LaunchPlan` definition  # noqa: E501

        Create and register a launch plan definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_launch_plan(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminLaunchPlanCreateRequest body: (required)
        :return: AdminLaunchPlanCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_launch_plan_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_launch_plan_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_launch_plan_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create and upload a :ref:`ref_flyteidl.admin.LaunchPlan` definition  # noqa: E501

        Create and register a launch plan definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_launch_plan_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminLaunchPlanCreateRequest body: (required)
        :return: AdminLaunchPlanCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_launch_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_launch_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/launch_plans', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminLaunchPlanCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_node_event(self, body, **kwargs):  # noqa: E501
        """Indicates a :ref:`ref_flyteidl.event.NodeExecutionEvent` has occurred.  # noqa: E501

        Create a node execution event recording a phase transition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_node_event(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminNodeExecutionEventRequest body: (required)
        :return: AdminNodeExecutionEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_node_event_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_node_event_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_node_event_with_http_info(self, body, **kwargs):  # noqa: E501
        """Indicates a :ref:`ref_flyteidl.event.NodeExecutionEvent` has occurred.  # noqa: E501

        Create a node execution event recording a phase transition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_node_event_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminNodeExecutionEventRequest body: (required)
        :return: AdminNodeExecutionEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_node_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_node_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/events/nodes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminNodeExecutionEventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_task(self, body, **kwargs):  # noqa: E501
        """Create and upload a :ref:`ref_flyteidl.admin.Task` definition  # noqa: E501

        Create and register a task definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_task(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminTaskCreateRequest body: (required)
        :return: AdminTaskCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_task_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_task_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_task_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create and upload a :ref:`ref_flyteidl.admin.Task` definition  # noqa: E501

        Create and register a task definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_task_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminTaskCreateRequest body: (required)
        :return: AdminTaskCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/tasks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminTaskCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_task_event(self, body, **kwargs):  # noqa: E501
        """Indicates a :ref:`ref_flyteidl.event.TaskExecutionEvent` has occurred.  # noqa: E501

        Create a task execution event recording a phase transition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_task_event(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminTaskExecutionEventRequest body: (required)
        :return: AdminTaskExecutionEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_task_event_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_task_event_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_task_event_with_http_info(self, body, **kwargs):  # noqa: E501
        """Indicates a :ref:`ref_flyteidl.event.TaskExecutionEvent` has occurred.  # noqa: E501

        Create a task execution event recording a phase transition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_task_event_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminTaskExecutionEventRequest body: (required)
        :return: AdminTaskExecutionEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_task_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_task_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/events/tasks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminTaskExecutionEventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_workflow(self, body, **kwargs):  # noqa: E501
        """Create and upload a :ref:`ref_flyteidl.admin.Workflow` definition  # noqa: E501

        Create and register a workflow definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_workflow(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminWorkflowCreateRequest body: (required)
        :return: AdminWorkflowCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_workflow_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_workflow_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_workflow_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create and upload a :ref:`ref_flyteidl.admin.Workflow` definition  # noqa: E501

        Create and register a workflow definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_workflow_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminWorkflowCreateRequest body: (required)
        :return: AdminWorkflowCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_workflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/workflows', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminWorkflowCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_workflow_event(self, body, **kwargs):  # noqa: E501
        """Indicates a :ref:`ref_flyteidl.event.WorkflowExecutionEvent` has occurred.  # noqa: E501

        Create a workflow execution event recording a phase transition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_workflow_event(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminWorkflowExecutionEventRequest body: (required)
        :return: AdminWorkflowExecutionEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_workflow_event_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_workflow_event_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_workflow_event_with_http_info(self, body, **kwargs):  # noqa: E501
        """Indicates a :ref:`ref_flyteidl.event.WorkflowExecutionEvent` has occurred.  # noqa: E501

        Create a workflow execution event recording a phase transition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_workflow_event_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminWorkflowExecutionEventRequest body: (required)
        :return: AdminWorkflowExecutionEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_workflow_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_workflow_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/events/workflows', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminWorkflowExecutionEventResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_project_domain_attributes(self, project, domain, body, **kwargs):  # noqa: E501
        """Deletes custom :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for a project and domain.  # noqa: E501

        Delete the customized resource attributes associated with a project-domain combination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_domain_attributes(project, domain, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Unique project id which this set of attributes references. +required (required)
        :param str domain: Unique domain id which this set of attributes references. +required (required)
        :param AdminProjectDomainAttributesDeleteRequest body: (required)
        :return: AdminProjectDomainAttributesDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_project_domain_attributes_with_http_info(project, domain, body, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_project_domain_attributes_with_http_info(project, domain, body, **kwargs)  # noqa: E501
            return data

    def delete_project_domain_attributes_with_http_info(self, project, domain, body, **kwargs):  # noqa: E501
        """Deletes custom :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for a project and domain.  # noqa: E501

        Delete the customized resource attributes associated with a project-domain combination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_domain_attributes_with_http_info(project, domain, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Unique project id which this set of attributes references. +required (required)
        :param str domain: Unique domain id which this set of attributes references. +required (required)
        :param AdminProjectDomainAttributesDeleteRequest body: (required)
        :return: AdminProjectDomainAttributesDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project', 'domain', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project_domain_attributes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project' is set
        if ('project' not in params or
                params['project'] is None):
            raise ValueError("Missing the required parameter `project` when calling `delete_project_domain_attributes`")  # noqa: E501
        # verify the required parameter 'domain' is set
        if ('domain' not in params or
                params['domain'] is None):
            raise ValueError("Missing the required parameter `domain` when calling `delete_project_domain_attributes`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_project_domain_attributes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in params:
            path_params['project'] = params['project']  # noqa: E501
        if 'domain' in params:
            path_params['domain'] = params['domain']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/project_domain_attributes/{project}/{domain}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminProjectDomainAttributesDeleteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_workflow_attributes(self, project, domain, workflow, body, **kwargs):  # noqa: E501
        """Deletes custom :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for a project, domain and workflow.  # noqa: E501

        Delete the customized resource attributes associated with a project, domain and workflow combination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_workflow_attributes(project, domain, workflow, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Unique project id which this set of attributes references. +required (required)
        :param str domain: Unique domain id which this set of attributes references. +required (required)
        :param str workflow: Workflow name which this set of attributes references. +required (required)
        :param AdminWorkflowAttributesDeleteRequest body: (required)
        :return: AdminWorkflowAttributesDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_workflow_attributes_with_http_info(project, domain, workflow, body, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_workflow_attributes_with_http_info(project, domain, workflow, body, **kwargs)  # noqa: E501
            return data

    def delete_workflow_attributes_with_http_info(self, project, domain, workflow, body, **kwargs):  # noqa: E501
        """Deletes custom :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for a project, domain and workflow.  # noqa: E501

        Delete the customized resource attributes associated with a project, domain and workflow combination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_workflow_attributes_with_http_info(project, domain, workflow, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Unique project id which this set of attributes references. +required (required)
        :param str domain: Unique domain id which this set of attributes references. +required (required)
        :param str workflow: Workflow name which this set of attributes references. +required (required)
        :param AdminWorkflowAttributesDeleteRequest body: (required)
        :return: AdminWorkflowAttributesDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project', 'domain', 'workflow', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workflow_attributes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project' is set
        if ('project' not in params or
                params['project'] is None):
            raise ValueError("Missing the required parameter `project` when calling `delete_workflow_attributes`")  # noqa: E501
        # verify the required parameter 'domain' is set
        if ('domain' not in params or
                params['domain'] is None):
            raise ValueError("Missing the required parameter `domain` when calling `delete_workflow_attributes`")  # noqa: E501
        # verify the required parameter 'workflow' is set
        if ('workflow' not in params or
                params['workflow'] is None):
            raise ValueError("Missing the required parameter `workflow` when calling `delete_workflow_attributes`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_workflow_attributes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in params:
            path_params['project'] = params['project']  # noqa: E501
        if 'domain' in params:
            path_params['domain'] = params['domain']  # noqa: E501
        if 'workflow' in params:
            path_params['workflow'] = params['workflow']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/workflow_attributes/{project}/{domain}/{workflow}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminWorkflowAttributesDeleteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_active_launch_plan(self, id_project, id_domain, id_name, **kwargs):  # noqa: E501
        """Fetch the active version of a :ref:`ref_flyteidl.admin.LaunchPlan`.  # noqa: E501

        Retrieve the active launch plan version specified by input request filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_launch_plan(id_project, id_domain, id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans' (required)
        :return: AdminLaunchPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_active_launch_plan_with_http_info(id_project, id_domain, id_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_active_launch_plan_with_http_info(id_project, id_domain, id_name, **kwargs)  # noqa: E501
            return data

    def get_active_launch_plan_with_http_info(self, id_project, id_domain, id_name, **kwargs):  # noqa: E501
        """Fetch the active version of a :ref:`ref_flyteidl.admin.LaunchPlan`.  # noqa: E501

        Retrieve the active launch plan version specified by input request filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_active_launch_plan_with_http_info(id_project, id_domain, id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans' (required)
        :return: AdminLaunchPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_active_launch_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `get_active_launch_plan`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `get_active_launch_plan`")  # noqa: E501
        # verify the required parameter 'id_name' is set
        if ('id_name' not in params or
                params['id_name'] is None):
            raise ValueError("Missing the required parameter `id_name` when calling `get_active_launch_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501
        if 'id_name' in params:
            path_params['id.name'] = params['id_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/active_launch_plans/{id.project}/{id.domain}/{id.name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminLaunchPlan',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_execution(self, id_project, id_domain, id_name, **kwargs):  # noqa: E501
        """Fetches a :ref:`ref_flyteidl.admin.Execution`.  # noqa: E501

        Retrieve an existing workflow execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_execution(id_project, id_domain, id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User or system provided value for the resource. (required)
        :return: AdminExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_execution_with_http_info(id_project, id_domain, id_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_execution_with_http_info(id_project, id_domain, id_name, **kwargs)  # noqa: E501
            return data

    def get_execution_with_http_info(self, id_project, id_domain, id_name, **kwargs):  # noqa: E501
        """Fetches a :ref:`ref_flyteidl.admin.Execution`.  # noqa: E501

        Retrieve an existing workflow execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_execution_with_http_info(id_project, id_domain, id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User or system provided value for the resource. (required)
        :return: AdminExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_execution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `get_execution`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `get_execution`")  # noqa: E501
        # verify the required parameter 'id_name' is set
        if ('id_name' not in params or
                params['id_name'] is None):
            raise ValueError("Missing the required parameter `id_name` when calling `get_execution`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501
        if 'id_name' in params:
            path_params['id.name'] = params['id_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/executions/{id.project}/{id.domain}/{id.name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminExecution',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_execution_data(self, id_project, id_domain, id_name, **kwargs):  # noqa: E501
        """Fetches input and output data for a :ref:`ref_flyteidl.admin.Execution`.  # noqa: E501

        Retrieve input and output data from an existing workflow execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_execution_data(id_project, id_domain, id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User or system provided value for the resource. (required)
        :return: AdminWorkflowExecutionGetDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_execution_data_with_http_info(id_project, id_domain, id_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_execution_data_with_http_info(id_project, id_domain, id_name, **kwargs)  # noqa: E501
            return data

    def get_execution_data_with_http_info(self, id_project, id_domain, id_name, **kwargs):  # noqa: E501
        """Fetches input and output data for a :ref:`ref_flyteidl.admin.Execution`.  # noqa: E501

        Retrieve input and output data from an existing workflow execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_execution_data_with_http_info(id_project, id_domain, id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User or system provided value for the resource. (required)
        :return: AdminWorkflowExecutionGetDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_execution_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `get_execution_data`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `get_execution_data`")  # noqa: E501
        # verify the required parameter 'id_name' is set
        if ('id_name' not in params or
                params['id_name'] is None):
            raise ValueError("Missing the required parameter `id_name` when calling `get_execution_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501
        if 'id_name' in params:
            path_params['id.name'] = params['id_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/data/executions/{id.project}/{id.domain}/{id.name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminWorkflowExecutionGetDataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_launch_plan(self, id_project, id_domain, id_name, id_version, **kwargs):  # noqa: E501
        """Fetch a :ref:`ref_flyteidl.admin.LaunchPlan` definition.  # noqa: E501

        Retrieve an existing launch plan definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_launch_plan(id_project, id_domain, id_name, id_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. (required)
        :param str id_version: Specific version of the resource. (required)
        :param str id_resource_type: Identifies the specific type of resource that this identifier corresponds to.   - DATASET: A dataset represents an entity modeled in Flyte DataCatalog. A Dataset is also a versioned entity and can be a compilation of multiple individual objects. Eventually all Catalog objects should be modeled similar to Flyte Objects. The Dataset entities makes it possible for the UI  and CLI to act on the objects  in a similar manner to other Flyte objects
        :return: AdminLaunchPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_launch_plan_with_http_info(id_project, id_domain, id_name, id_version, **kwargs)  # noqa: E501
        else:
            (data) = self.get_launch_plan_with_http_info(id_project, id_domain, id_name, id_version, **kwargs)  # noqa: E501
            return data

    def get_launch_plan_with_http_info(self, id_project, id_domain, id_name, id_version, **kwargs):  # noqa: E501
        """Fetch a :ref:`ref_flyteidl.admin.LaunchPlan` definition.  # noqa: E501

        Retrieve an existing launch plan definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_launch_plan_with_http_info(id_project, id_domain, id_name, id_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. (required)
        :param str id_version: Specific version of the resource. (required)
        :param str id_resource_type: Identifies the specific type of resource that this identifier corresponds to.   - DATASET: A dataset represents an entity modeled in Flyte DataCatalog. A Dataset is also a versioned entity and can be a compilation of multiple individual objects. Eventually all Catalog objects should be modeled similar to Flyte Objects. The Dataset entities makes it possible for the UI  and CLI to act on the objects  in a similar manner to other Flyte objects
        :return: AdminLaunchPlan
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name', 'id_version', 'id_resource_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_launch_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `get_launch_plan`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `get_launch_plan`")  # noqa: E501
        # verify the required parameter 'id_name' is set
        if ('id_name' not in params or
                params['id_name'] is None):
            raise ValueError("Missing the required parameter `id_name` when calling `get_launch_plan`")  # noqa: E501
        # verify the required parameter 'id_version' is set
        if ('id_version' not in params or
                params['id_version'] is None):
            raise ValueError("Missing the required parameter `id_version` when calling `get_launch_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501
        if 'id_name' in params:
            path_params['id.name'] = params['id_name']  # noqa: E501
        if 'id_version' in params:
            path_params['id.version'] = params['id_version']  # noqa: E501

        query_params = []
        if 'id_resource_type' in params:
            query_params.append(('id.resource_type', params['id_resource_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/launch_plans/{id.project}/{id.domain}/{id.name}/{id.version}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminLaunchPlan',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_named_entity(self, resource_type, id_project, id_domain, id_name, **kwargs):  # noqa: E501
        """Returns a :ref:`ref_flyteidl.admin.NamedEntity` object.  # noqa: E501

        Retrieve a NamedEntity object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_named_entity(resource_type, id_project, id_domain, id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_type: Resource type of the metadata to get. One of Task, Workflow or LaunchPlan. +required (required)
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans' (required)
        :return: AdminNamedEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_named_entity_with_http_info(resource_type, id_project, id_domain, id_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_named_entity_with_http_info(resource_type, id_project, id_domain, id_name, **kwargs)  # noqa: E501
            return data

    def get_named_entity_with_http_info(self, resource_type, id_project, id_domain, id_name, **kwargs):  # noqa: E501
        """Returns a :ref:`ref_flyteidl.admin.NamedEntity` object.  # noqa: E501

        Retrieve a NamedEntity object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_named_entity_with_http_info(resource_type, id_project, id_domain, id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_type: Resource type of the metadata to get. One of Task, Workflow or LaunchPlan. +required (required)
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans' (required)
        :return: AdminNamedEntity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['resource_type', 'id_project', 'id_domain', 'id_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_named_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'resource_type' is set
        if ('resource_type' not in params or
                params['resource_type'] is None):
            raise ValueError("Missing the required parameter `resource_type` when calling `get_named_entity`")  # noqa: E501
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `get_named_entity`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `get_named_entity`")  # noqa: E501
        # verify the required parameter 'id_name' is set
        if ('id_name' not in params or
                params['id_name'] is None):
            raise ValueError("Missing the required parameter `id_name` when calling `get_named_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'resource_type' in params:
            path_params['resource_type'] = params['resource_type']  # noqa: E501
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501
        if 'id_name' in params:
            path_params['id.name'] = params['id_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/named_entities/{resource_type}/{id.project}/{id.domain}/{id.name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminNamedEntity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_execution(self, id_execution_id_project, id_execution_id_domain, id_execution_id_name, id_node_id, **kwargs):  # noqa: E501
        """Fetches a :ref:`ref_flyteidl.admin.NodeExecution`.  # noqa: E501

        Retrieve an existing node execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_execution(id_execution_id_project, id_execution_id_domain, id_execution_id_name, id_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_execution_id_project: Name of the project the resource belongs to. (required)
        :param str id_execution_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_execution_id_name: User or system provided value for the resource. (required)
        :param str id_node_id: (required)
        :return: FlyteidladminNodeExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_execution_with_http_info(id_execution_id_project, id_execution_id_domain, id_execution_id_name, id_node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_execution_with_http_info(id_execution_id_project, id_execution_id_domain, id_execution_id_name, id_node_id, **kwargs)  # noqa: E501
            return data

    def get_node_execution_with_http_info(self, id_execution_id_project, id_execution_id_domain, id_execution_id_name, id_node_id, **kwargs):  # noqa: E501
        """Fetches a :ref:`ref_flyteidl.admin.NodeExecution`.  # noqa: E501

        Retrieve an existing node execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_execution_with_http_info(id_execution_id_project, id_execution_id_domain, id_execution_id_name, id_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_execution_id_project: Name of the project the resource belongs to. (required)
        :param str id_execution_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_execution_id_name: User or system provided value for the resource. (required)
        :param str id_node_id: (required)
        :return: FlyteidladminNodeExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_execution_id_project', 'id_execution_id_domain', 'id_execution_id_name', 'id_node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_execution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_execution_id_project' is set
        if ('id_execution_id_project' not in params or
                params['id_execution_id_project'] is None):
            raise ValueError("Missing the required parameter `id_execution_id_project` when calling `get_node_execution`")  # noqa: E501
        # verify the required parameter 'id_execution_id_domain' is set
        if ('id_execution_id_domain' not in params or
                params['id_execution_id_domain'] is None):
            raise ValueError("Missing the required parameter `id_execution_id_domain` when calling `get_node_execution`")  # noqa: E501
        # verify the required parameter 'id_execution_id_name' is set
        if ('id_execution_id_name' not in params or
                params['id_execution_id_name'] is None):
            raise ValueError("Missing the required parameter `id_execution_id_name` when calling `get_node_execution`")  # noqa: E501
        # verify the required parameter 'id_node_id' is set
        if ('id_node_id' not in params or
                params['id_node_id'] is None):
            raise ValueError("Missing the required parameter `id_node_id` when calling `get_node_execution`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_execution_id_project' in params:
            path_params['id.execution_id.project'] = params['id_execution_id_project']  # noqa: E501
        if 'id_execution_id_domain' in params:
            path_params['id.execution_id.domain'] = params['id_execution_id_domain']  # noqa: E501
        if 'id_execution_id_name' in params:
            path_params['id.execution_id.name'] = params['id_execution_id_name']  # noqa: E501
        if 'id_node_id' in params:
            path_params['id.node_id'] = params['id_node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/node_executions/{id.execution_id.project}/{id.execution_id.domain}/{id.execution_id.name}/{id.node_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FlyteidladminNodeExecution',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_execution_data(self, id_execution_id_project, id_execution_id_domain, id_execution_id_name, id_node_id, **kwargs):  # noqa: E501
        """Fetches input and output data for a :ref:`ref_flyteidl.admin.NodeExecution`.  # noqa: E501

        Retrieve input and output data from an existing node execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_execution_data(id_execution_id_project, id_execution_id_domain, id_execution_id_name, id_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_execution_id_project: Name of the project the resource belongs to. (required)
        :param str id_execution_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_execution_id_name: User or system provided value for the resource. (required)
        :param str id_node_id: (required)
        :return: AdminNodeExecutionGetDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_execution_data_with_http_info(id_execution_id_project, id_execution_id_domain, id_execution_id_name, id_node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_execution_data_with_http_info(id_execution_id_project, id_execution_id_domain, id_execution_id_name, id_node_id, **kwargs)  # noqa: E501
            return data

    def get_node_execution_data_with_http_info(self, id_execution_id_project, id_execution_id_domain, id_execution_id_name, id_node_id, **kwargs):  # noqa: E501
        """Fetches input and output data for a :ref:`ref_flyteidl.admin.NodeExecution`.  # noqa: E501

        Retrieve input and output data from an existing node execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_execution_data_with_http_info(id_execution_id_project, id_execution_id_domain, id_execution_id_name, id_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_execution_id_project: Name of the project the resource belongs to. (required)
        :param str id_execution_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_execution_id_name: User or system provided value for the resource. (required)
        :param str id_node_id: (required)
        :return: AdminNodeExecutionGetDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_execution_id_project', 'id_execution_id_domain', 'id_execution_id_name', 'id_node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_execution_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_execution_id_project' is set
        if ('id_execution_id_project' not in params or
                params['id_execution_id_project'] is None):
            raise ValueError("Missing the required parameter `id_execution_id_project` when calling `get_node_execution_data`")  # noqa: E501
        # verify the required parameter 'id_execution_id_domain' is set
        if ('id_execution_id_domain' not in params or
                params['id_execution_id_domain'] is None):
            raise ValueError("Missing the required parameter `id_execution_id_domain` when calling `get_node_execution_data`")  # noqa: E501
        # verify the required parameter 'id_execution_id_name' is set
        if ('id_execution_id_name' not in params or
                params['id_execution_id_name'] is None):
            raise ValueError("Missing the required parameter `id_execution_id_name` when calling `get_node_execution_data`")  # noqa: E501
        # verify the required parameter 'id_node_id' is set
        if ('id_node_id' not in params or
                params['id_node_id'] is None):
            raise ValueError("Missing the required parameter `id_node_id` when calling `get_node_execution_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_execution_id_project' in params:
            path_params['id.execution_id.project'] = params['id_execution_id_project']  # noqa: E501
        if 'id_execution_id_domain' in params:
            path_params['id.execution_id.domain'] = params['id_execution_id_domain']  # noqa: E501
        if 'id_execution_id_name' in params:
            path_params['id.execution_id.name'] = params['id_execution_id_name']  # noqa: E501
        if 'id_node_id' in params:
            path_params['id.node_id'] = params['id_node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/data/node_executions/{id.execution_id.project}/{id.execution_id.domain}/{id.execution_id.name}/{id.node_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminNodeExecutionGetDataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_project_domain_attributes(self, project, domain, **kwargs):  # noqa: E501
        """Fetches custom :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for a project and domain.  # noqa: E501

        Retrieve the customized resource attributes associated with a project-domain combination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_domain_attributes(project, domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Unique project id which this set of attributes references. +required (required)
        :param str domain: Unique domain id which this set of attributes references. +required (required)
        :param str resource_type: Which type of matchable attributes to return. +required.   - TASK_RESOURCE: Applies to customizable task resource requests and limits.  - CLUSTER_RESOURCE: Applies to configuring templated kubernetes cluster resources.  - EXECUTION_QUEUE: Configures task and dynamic task execution queue assignment.  - EXECUTION_CLUSTER_LABEL: Configures the K8s cluster label to be used for execution to be run  - QUALITY_OF_SERVICE_SPECIFICATION: Configures default quality of service when undefined in an execution spec.  - PLUGIN_OVERRIDE: Selects configurable plugin implementation behavior for a given task type.  - WORKFLOW_EXECUTION_CONFIG: Adds defaults for customizable workflow-execution specifications and overrides.  - CLUSTER_ASSIGNMENT: Controls how to select an available cluster on which this execution should run.
        :return: AdminProjectDomainAttributesGetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_project_domain_attributes_with_http_info(project, domain, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_domain_attributes_with_http_info(project, domain, **kwargs)  # noqa: E501
            return data

    def get_project_domain_attributes_with_http_info(self, project, domain, **kwargs):  # noqa: E501
        """Fetches custom :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for a project and domain.  # noqa: E501

        Retrieve the customized resource attributes associated with a project-domain combination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_domain_attributes_with_http_info(project, domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Unique project id which this set of attributes references. +required (required)
        :param str domain: Unique domain id which this set of attributes references. +required (required)
        :param str resource_type: Which type of matchable attributes to return. +required.   - TASK_RESOURCE: Applies to customizable task resource requests and limits.  - CLUSTER_RESOURCE: Applies to configuring templated kubernetes cluster resources.  - EXECUTION_QUEUE: Configures task and dynamic task execution queue assignment.  - EXECUTION_CLUSTER_LABEL: Configures the K8s cluster label to be used for execution to be run  - QUALITY_OF_SERVICE_SPECIFICATION: Configures default quality of service when undefined in an execution spec.  - PLUGIN_OVERRIDE: Selects configurable plugin implementation behavior for a given task type.  - WORKFLOW_EXECUTION_CONFIG: Adds defaults for customizable workflow-execution specifications and overrides.  - CLUSTER_ASSIGNMENT: Controls how to select an available cluster on which this execution should run.
        :return: AdminProjectDomainAttributesGetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project', 'domain', 'resource_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project_domain_attributes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project' is set
        if ('project' not in params or
                params['project'] is None):
            raise ValueError("Missing the required parameter `project` when calling `get_project_domain_attributes`")  # noqa: E501
        # verify the required parameter 'domain' is set
        if ('domain' not in params or
                params['domain'] is None):
            raise ValueError("Missing the required parameter `domain` when calling `get_project_domain_attributes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in params:
            path_params['project'] = params['project']  # noqa: E501
        if 'domain' in params:
            path_params['domain'] = params['domain']  # noqa: E501

        query_params = []
        if 'resource_type' in params:
            query_params.append(('resource_type', params['resource_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/project_domain_attributes/{project}/{domain}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminProjectDomainAttributesGetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task(self, id_project, id_domain, id_name, id_version, **kwargs):  # noqa: E501
        """Fetch a :ref:`ref_flyteidl.admin.Task` definition.  # noqa: E501

        Retrieve an existing task definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task(id_project, id_domain, id_name, id_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. (required)
        :param str id_version: Specific version of the resource. (required)
        :param str id_resource_type: Identifies the specific type of resource that this identifier corresponds to.   - DATASET: A dataset represents an entity modeled in Flyte DataCatalog. A Dataset is also a versioned entity and can be a compilation of multiple individual objects. Eventually all Catalog objects should be modeled similar to Flyte Objects. The Dataset entities makes it possible for the UI  and CLI to act on the objects  in a similar manner to other Flyte objects
        :return: AdminTask
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_task_with_http_info(id_project, id_domain, id_name, id_version, **kwargs)  # noqa: E501
        else:
            (data) = self.get_task_with_http_info(id_project, id_domain, id_name, id_version, **kwargs)  # noqa: E501
            return data

    def get_task_with_http_info(self, id_project, id_domain, id_name, id_version, **kwargs):  # noqa: E501
        """Fetch a :ref:`ref_flyteidl.admin.Task` definition.  # noqa: E501

        Retrieve an existing task definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_with_http_info(id_project, id_domain, id_name, id_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. (required)
        :param str id_version: Specific version of the resource. (required)
        :param str id_resource_type: Identifies the specific type of resource that this identifier corresponds to.   - DATASET: A dataset represents an entity modeled in Flyte DataCatalog. A Dataset is also a versioned entity and can be a compilation of multiple individual objects. Eventually all Catalog objects should be modeled similar to Flyte Objects. The Dataset entities makes it possible for the UI  and CLI to act on the objects  in a similar manner to other Flyte objects
        :return: AdminTask
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name', 'id_version', 'id_resource_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `get_task`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `get_task`")  # noqa: E501
        # verify the required parameter 'id_name' is set
        if ('id_name' not in params or
                params['id_name'] is None):
            raise ValueError("Missing the required parameter `id_name` when calling `get_task`")  # noqa: E501
        # verify the required parameter 'id_version' is set
        if ('id_version' not in params or
                params['id_version'] is None):
            raise ValueError("Missing the required parameter `id_version` when calling `get_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501
        if 'id_name' in params:
            path_params['id.name'] = params['id_name']  # noqa: E501
        if 'id_version' in params:
            path_params['id.version'] = params['id_version']  # noqa: E501

        query_params = []
        if 'id_resource_type' in params:
            query_params.append(('id.resource_type', params['id_resource_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/tasks/{id.project}/{id.domain}/{id.name}/{id.version}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminTask',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_execution(self, id_node_execution_id_execution_id_project, id_node_execution_id_execution_id_domain, id_node_execution_id_execution_id_name, id_node_execution_id_node_id, id_task_id_project, id_task_id_domain, id_task_id_name, id_task_id_version, id_retry_attempt, **kwargs):  # noqa: E501
        """Fetches a :ref:`ref_flyteidl.admin.TaskExecution`.  # noqa: E501

        Retrieve an existing task execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_execution(id_node_execution_id_execution_id_project, id_node_execution_id_execution_id_domain, id_node_execution_id_execution_id_name, id_node_execution_id_node_id, id_task_id_project, id_task_id_domain, id_task_id_name, id_task_id_version, id_retry_attempt, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_node_execution_id_execution_id_project: Name of the project the resource belongs to. (required)
        :param str id_node_execution_id_execution_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_node_execution_id_execution_id_name: User or system provided value for the resource. (required)
        :param str id_node_execution_id_node_id: (required)
        :param str id_task_id_project: Name of the project the resource belongs to. (required)
        :param str id_task_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_task_id_name: User provided value for the resource. (required)
        :param str id_task_id_version: Specific version of the resource. (required)
        :param int id_retry_attempt: (required)
        :param str id_task_id_resource_type: Identifies the specific type of resource that this identifier corresponds to.   - DATASET: A dataset represents an entity modeled in Flyte DataCatalog. A Dataset is also a versioned entity and can be a compilation of multiple individual objects. Eventually all Catalog objects should be modeled similar to Flyte Objects. The Dataset entities makes it possible for the UI  and CLI to act on the objects  in a similar manner to other Flyte objects
        :return: FlyteidladminTaskExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_task_execution_with_http_info(id_node_execution_id_execution_id_project, id_node_execution_id_execution_id_domain, id_node_execution_id_execution_id_name, id_node_execution_id_node_id, id_task_id_project, id_task_id_domain, id_task_id_name, id_task_id_version, id_retry_attempt, **kwargs)  # noqa: E501
        else:
            (data) = self.get_task_execution_with_http_info(id_node_execution_id_execution_id_project, id_node_execution_id_execution_id_domain, id_node_execution_id_execution_id_name, id_node_execution_id_node_id, id_task_id_project, id_task_id_domain, id_task_id_name, id_task_id_version, id_retry_attempt, **kwargs)  # noqa: E501
            return data

    def get_task_execution_with_http_info(self, id_node_execution_id_execution_id_project, id_node_execution_id_execution_id_domain, id_node_execution_id_execution_id_name, id_node_execution_id_node_id, id_task_id_project, id_task_id_domain, id_task_id_name, id_task_id_version, id_retry_attempt, **kwargs):  # noqa: E501
        """Fetches a :ref:`ref_flyteidl.admin.TaskExecution`.  # noqa: E501

        Retrieve an existing task execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_execution_with_http_info(id_node_execution_id_execution_id_project, id_node_execution_id_execution_id_domain, id_node_execution_id_execution_id_name, id_node_execution_id_node_id, id_task_id_project, id_task_id_domain, id_task_id_name, id_task_id_version, id_retry_attempt, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_node_execution_id_execution_id_project: Name of the project the resource belongs to. (required)
        :param str id_node_execution_id_execution_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_node_execution_id_execution_id_name: User or system provided value for the resource. (required)
        :param str id_node_execution_id_node_id: (required)
        :param str id_task_id_project: Name of the project the resource belongs to. (required)
        :param str id_task_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_task_id_name: User provided value for the resource. (required)
        :param str id_task_id_version: Specific version of the resource. (required)
        :param int id_retry_attempt: (required)
        :param str id_task_id_resource_type: Identifies the specific type of resource that this identifier corresponds to.   - DATASET: A dataset represents an entity modeled in Flyte DataCatalog. A Dataset is also a versioned entity and can be a compilation of multiple individual objects. Eventually all Catalog objects should be modeled similar to Flyte Objects. The Dataset entities makes it possible for the UI  and CLI to act on the objects  in a similar manner to other Flyte objects
        :return: FlyteidladminTaskExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_node_execution_id_execution_id_project', 'id_node_execution_id_execution_id_domain', 'id_node_execution_id_execution_id_name', 'id_node_execution_id_node_id', 'id_task_id_project', 'id_task_id_domain', 'id_task_id_name', 'id_task_id_version', 'id_retry_attempt', 'id_task_id_resource_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_execution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_node_execution_id_execution_id_project' is set
        if ('id_node_execution_id_execution_id_project' not in params or
                params['id_node_execution_id_execution_id_project'] is None):
            raise ValueError("Missing the required parameter `id_node_execution_id_execution_id_project` when calling `get_task_execution`")  # noqa: E501
        # verify the required parameter 'id_node_execution_id_execution_id_domain' is set
        if ('id_node_execution_id_execution_id_domain' not in params or
                params['id_node_execution_id_execution_id_domain'] is None):
            raise ValueError("Missing the required parameter `id_node_execution_id_execution_id_domain` when calling `get_task_execution`")  # noqa: E501
        # verify the required parameter 'id_node_execution_id_execution_id_name' is set
        if ('id_node_execution_id_execution_id_name' not in params or
                params['id_node_execution_id_execution_id_name'] is None):
            raise ValueError("Missing the required parameter `id_node_execution_id_execution_id_name` when calling `get_task_execution`")  # noqa: E501
        # verify the required parameter 'id_node_execution_id_node_id' is set
        if ('id_node_execution_id_node_id' not in params or
                params['id_node_execution_id_node_id'] is None):
            raise ValueError("Missing the required parameter `id_node_execution_id_node_id` when calling `get_task_execution`")  # noqa: E501
        # verify the required parameter 'id_task_id_project' is set
        if ('id_task_id_project' not in params or
                params['id_task_id_project'] is None):
            raise ValueError("Missing the required parameter `id_task_id_project` when calling `get_task_execution`")  # noqa: E501
        # verify the required parameter 'id_task_id_domain' is set
        if ('id_task_id_domain' not in params or
                params['id_task_id_domain'] is None):
            raise ValueError("Missing the required parameter `id_task_id_domain` when calling `get_task_execution`")  # noqa: E501
        # verify the required parameter 'id_task_id_name' is set
        if ('id_task_id_name' not in params or
                params['id_task_id_name'] is None):
            raise ValueError("Missing the required parameter `id_task_id_name` when calling `get_task_execution`")  # noqa: E501
        # verify the required parameter 'id_task_id_version' is set
        if ('id_task_id_version' not in params or
                params['id_task_id_version'] is None):
            raise ValueError("Missing the required parameter `id_task_id_version` when calling `get_task_execution`")  # noqa: E501
        # verify the required parameter 'id_retry_attempt' is set
        if ('id_retry_attempt' not in params or
                params['id_retry_attempt'] is None):
            raise ValueError("Missing the required parameter `id_retry_attempt` when calling `get_task_execution`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_node_execution_id_execution_id_project' in params:
            path_params['id.node_execution_id.execution_id.project'] = params['id_node_execution_id_execution_id_project']  # noqa: E501
        if 'id_node_execution_id_execution_id_domain' in params:
            path_params['id.node_execution_id.execution_id.domain'] = params['id_node_execution_id_execution_id_domain']  # noqa: E501
        if 'id_node_execution_id_execution_id_name' in params:
            path_params['id.node_execution_id.execution_id.name'] = params['id_node_execution_id_execution_id_name']  # noqa: E501
        if 'id_node_execution_id_node_id' in params:
            path_params['id.node_execution_id.node_id'] = params['id_node_execution_id_node_id']  # noqa: E501
        if 'id_task_id_project' in params:
            path_params['id.task_id.project'] = params['id_task_id_project']  # noqa: E501
        if 'id_task_id_domain' in params:
            path_params['id.task_id.domain'] = params['id_task_id_domain']  # noqa: E501
        if 'id_task_id_name' in params:
            path_params['id.task_id.name'] = params['id_task_id_name']  # noqa: E501
        if 'id_task_id_version' in params:
            path_params['id.task_id.version'] = params['id_task_id_version']  # noqa: E501
        if 'id_retry_attempt' in params:
            path_params['id.retry_attempt'] = params['id_retry_attempt']  # noqa: E501

        query_params = []
        if 'id_task_id_resource_type' in params:
            query_params.append(('id.task_id.resource_type', params['id_task_id_resource_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/task_executions/{id.node_execution_id.execution_id.project}/{id.node_execution_id.execution_id.domain}/{id.node_execution_id.execution_id.name}/{id.node_execution_id.node_id}/{id.task_id.project}/{id.task_id.domain}/{id.task_id.name}/{id.task_id.version}/{id.retry_attempt}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FlyteidladminTaskExecution',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_execution_data(self, id_node_execution_id_execution_id_project, id_node_execution_id_execution_id_domain, id_node_execution_id_execution_id_name, id_node_execution_id_node_id, id_task_id_project, id_task_id_domain, id_task_id_name, id_task_id_version, id_retry_attempt, **kwargs):  # noqa: E501
        """Fetches input and output data for a :ref:`ref_flyteidl.admin.TaskExecution`.  # noqa: E501

        Retrieve input and output data from an existing task execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_execution_data(id_node_execution_id_execution_id_project, id_node_execution_id_execution_id_domain, id_node_execution_id_execution_id_name, id_node_execution_id_node_id, id_task_id_project, id_task_id_domain, id_task_id_name, id_task_id_version, id_retry_attempt, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_node_execution_id_execution_id_project: Name of the project the resource belongs to. (required)
        :param str id_node_execution_id_execution_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_node_execution_id_execution_id_name: User or system provided value for the resource. (required)
        :param str id_node_execution_id_node_id: (required)
        :param str id_task_id_project: Name of the project the resource belongs to. (required)
        :param str id_task_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_task_id_name: User provided value for the resource. (required)
        :param str id_task_id_version: Specific version of the resource. (required)
        :param int id_retry_attempt: (required)
        :param str id_task_id_resource_type: Identifies the specific type of resource that this identifier corresponds to.   - DATASET: A dataset represents an entity modeled in Flyte DataCatalog. A Dataset is also a versioned entity and can be a compilation of multiple individual objects. Eventually all Catalog objects should be modeled similar to Flyte Objects. The Dataset entities makes it possible for the UI  and CLI to act on the objects  in a similar manner to other Flyte objects
        :return: AdminTaskExecutionGetDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_task_execution_data_with_http_info(id_node_execution_id_execution_id_project, id_node_execution_id_execution_id_domain, id_node_execution_id_execution_id_name, id_node_execution_id_node_id, id_task_id_project, id_task_id_domain, id_task_id_name, id_task_id_version, id_retry_attempt, **kwargs)  # noqa: E501
        else:
            (data) = self.get_task_execution_data_with_http_info(id_node_execution_id_execution_id_project, id_node_execution_id_execution_id_domain, id_node_execution_id_execution_id_name, id_node_execution_id_node_id, id_task_id_project, id_task_id_domain, id_task_id_name, id_task_id_version, id_retry_attempt, **kwargs)  # noqa: E501
            return data

    def get_task_execution_data_with_http_info(self, id_node_execution_id_execution_id_project, id_node_execution_id_execution_id_domain, id_node_execution_id_execution_id_name, id_node_execution_id_node_id, id_task_id_project, id_task_id_domain, id_task_id_name, id_task_id_version, id_retry_attempt, **kwargs):  # noqa: E501
        """Fetches input and output data for a :ref:`ref_flyteidl.admin.TaskExecution`.  # noqa: E501

        Retrieve input and output data from an existing task execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_execution_data_with_http_info(id_node_execution_id_execution_id_project, id_node_execution_id_execution_id_domain, id_node_execution_id_execution_id_name, id_node_execution_id_node_id, id_task_id_project, id_task_id_domain, id_task_id_name, id_task_id_version, id_retry_attempt, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_node_execution_id_execution_id_project: Name of the project the resource belongs to. (required)
        :param str id_node_execution_id_execution_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_node_execution_id_execution_id_name: User or system provided value for the resource. (required)
        :param str id_node_execution_id_node_id: (required)
        :param str id_task_id_project: Name of the project the resource belongs to. (required)
        :param str id_task_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_task_id_name: User provided value for the resource. (required)
        :param str id_task_id_version: Specific version of the resource. (required)
        :param int id_retry_attempt: (required)
        :param str id_task_id_resource_type: Identifies the specific type of resource that this identifier corresponds to.   - DATASET: A dataset represents an entity modeled in Flyte DataCatalog. A Dataset is also a versioned entity and can be a compilation of multiple individual objects. Eventually all Catalog objects should be modeled similar to Flyte Objects. The Dataset entities makes it possible for the UI  and CLI to act on the objects  in a similar manner to other Flyte objects
        :return: AdminTaskExecutionGetDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_node_execution_id_execution_id_project', 'id_node_execution_id_execution_id_domain', 'id_node_execution_id_execution_id_name', 'id_node_execution_id_node_id', 'id_task_id_project', 'id_task_id_domain', 'id_task_id_name', 'id_task_id_version', 'id_retry_attempt', 'id_task_id_resource_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_execution_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_node_execution_id_execution_id_project' is set
        if ('id_node_execution_id_execution_id_project' not in params or
                params['id_node_execution_id_execution_id_project'] is None):
            raise ValueError("Missing the required parameter `id_node_execution_id_execution_id_project` when calling `get_task_execution_data`")  # noqa: E501
        # verify the required parameter 'id_node_execution_id_execution_id_domain' is set
        if ('id_node_execution_id_execution_id_domain' not in params or
                params['id_node_execution_id_execution_id_domain'] is None):
            raise ValueError("Missing the required parameter `id_node_execution_id_execution_id_domain` when calling `get_task_execution_data`")  # noqa: E501
        # verify the required parameter 'id_node_execution_id_execution_id_name' is set
        if ('id_node_execution_id_execution_id_name' not in params or
                params['id_node_execution_id_execution_id_name'] is None):
            raise ValueError("Missing the required parameter `id_node_execution_id_execution_id_name` when calling `get_task_execution_data`")  # noqa: E501
        # verify the required parameter 'id_node_execution_id_node_id' is set
        if ('id_node_execution_id_node_id' not in params or
                params['id_node_execution_id_node_id'] is None):
            raise ValueError("Missing the required parameter `id_node_execution_id_node_id` when calling `get_task_execution_data`")  # noqa: E501
        # verify the required parameter 'id_task_id_project' is set
        if ('id_task_id_project' not in params or
                params['id_task_id_project'] is None):
            raise ValueError("Missing the required parameter `id_task_id_project` when calling `get_task_execution_data`")  # noqa: E501
        # verify the required parameter 'id_task_id_domain' is set
        if ('id_task_id_domain' not in params or
                params['id_task_id_domain'] is None):
            raise ValueError("Missing the required parameter `id_task_id_domain` when calling `get_task_execution_data`")  # noqa: E501
        # verify the required parameter 'id_task_id_name' is set
        if ('id_task_id_name' not in params or
                params['id_task_id_name'] is None):
            raise ValueError("Missing the required parameter `id_task_id_name` when calling `get_task_execution_data`")  # noqa: E501
        # verify the required parameter 'id_task_id_version' is set
        if ('id_task_id_version' not in params or
                params['id_task_id_version'] is None):
            raise ValueError("Missing the required parameter `id_task_id_version` when calling `get_task_execution_data`")  # noqa: E501
        # verify the required parameter 'id_retry_attempt' is set
        if ('id_retry_attempt' not in params or
                params['id_retry_attempt'] is None):
            raise ValueError("Missing the required parameter `id_retry_attempt` when calling `get_task_execution_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_node_execution_id_execution_id_project' in params:
            path_params['id.node_execution_id.execution_id.project'] = params['id_node_execution_id_execution_id_project']  # noqa: E501
        if 'id_node_execution_id_execution_id_domain' in params:
            path_params['id.node_execution_id.execution_id.domain'] = params['id_node_execution_id_execution_id_domain']  # noqa: E501
        if 'id_node_execution_id_execution_id_name' in params:
            path_params['id.node_execution_id.execution_id.name'] = params['id_node_execution_id_execution_id_name']  # noqa: E501
        if 'id_node_execution_id_node_id' in params:
            path_params['id.node_execution_id.node_id'] = params['id_node_execution_id_node_id']  # noqa: E501
        if 'id_task_id_project' in params:
            path_params['id.task_id.project'] = params['id_task_id_project']  # noqa: E501
        if 'id_task_id_domain' in params:
            path_params['id.task_id.domain'] = params['id_task_id_domain']  # noqa: E501
        if 'id_task_id_name' in params:
            path_params['id.task_id.name'] = params['id_task_id_name']  # noqa: E501
        if 'id_task_id_version' in params:
            path_params['id.task_id.version'] = params['id_task_id_version']  # noqa: E501
        if 'id_retry_attempt' in params:
            path_params['id.retry_attempt'] = params['id_retry_attempt']  # noqa: E501

        query_params = []
        if 'id_task_id_resource_type' in params:
            query_params.append(('id.task_id.resource_type', params['id_task_id_resource_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/data/task_executions/{id.node_execution_id.execution_id.project}/{id.node_execution_id.execution_id.domain}/{id.node_execution_id.execution_id.name}/{id.node_execution_id.node_id}/{id.task_id.project}/{id.task_id.domain}/{id.task_id.name}/{id.task_id.version}/{id.retry_attempt}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminTaskExecutionGetDataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_version(self, **kwargs):  # noqa: E501
        """get_version  # noqa: E501

        Retrieve the Version (including the Build  information) for FlyteAdmin service  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_version(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AdminGetVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_version_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_version_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_version_with_http_info(self, **kwargs):  # noqa: E501
        """get_version  # noqa: E501

        Retrieve the Version (including the Build  information) for FlyteAdmin service  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_version_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AdminGetVersionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_version" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/version', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminGetVersionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow(self, id_project, id_domain, id_name, id_version, **kwargs):  # noqa: E501
        """Fetch a :ref:`ref_flyteidl.admin.Workflow` definition.  # noqa: E501

        Retrieve an existing workflow definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow(id_project, id_domain, id_name, id_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. (required)
        :param str id_version: Specific version of the resource. (required)
        :param str id_resource_type: Identifies the specific type of resource that this identifier corresponds to.   - DATASET: A dataset represents an entity modeled in Flyte DataCatalog. A Dataset is also a versioned entity and can be a compilation of multiple individual objects. Eventually all Catalog objects should be modeled similar to Flyte Objects. The Dataset entities makes it possible for the UI  and CLI to act on the objects  in a similar manner to other Flyte objects
        :return: AdminWorkflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workflow_with_http_info(id_project, id_domain, id_name, id_version, **kwargs)  # noqa: E501
        else:
            (data) = self.get_workflow_with_http_info(id_project, id_domain, id_name, id_version, **kwargs)  # noqa: E501
            return data

    def get_workflow_with_http_info(self, id_project, id_domain, id_name, id_version, **kwargs):  # noqa: E501
        """Fetch a :ref:`ref_flyteidl.admin.Workflow` definition.  # noqa: E501

        Retrieve an existing workflow definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_with_http_info(id_project, id_domain, id_name, id_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. (required)
        :param str id_version: Specific version of the resource. (required)
        :param str id_resource_type: Identifies the specific type of resource that this identifier corresponds to.   - DATASET: A dataset represents an entity modeled in Flyte DataCatalog. A Dataset is also a versioned entity and can be a compilation of multiple individual objects. Eventually all Catalog objects should be modeled similar to Flyte Objects. The Dataset entities makes it possible for the UI  and CLI to act on the objects  in a similar manner to other Flyte objects
        :return: AdminWorkflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name', 'id_version', 'id_resource_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `get_workflow`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `get_workflow`")  # noqa: E501
        # verify the required parameter 'id_name' is set
        if ('id_name' not in params or
                params['id_name'] is None):
            raise ValueError("Missing the required parameter `id_name` when calling `get_workflow`")  # noqa: E501
        # verify the required parameter 'id_version' is set
        if ('id_version' not in params or
                params['id_version'] is None):
            raise ValueError("Missing the required parameter `id_version` when calling `get_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501
        if 'id_name' in params:
            path_params['id.name'] = params['id_name']  # noqa: E501
        if 'id_version' in params:
            path_params['id.version'] = params['id_version']  # noqa: E501

        query_params = []
        if 'id_resource_type' in params:
            query_params.append(('id.resource_type', params['id_resource_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/workflows/{id.project}/{id.domain}/{id.name}/{id.version}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminWorkflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_attributes(self, project, domain, workflow, **kwargs):  # noqa: E501
        """Fetches custom :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for a project, domain and workflow.  # noqa: E501

        Retrieve the customized resource attributes associated with a project, domain and workflow combination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_attributes(project, domain, workflow, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Unique project id which this set of attributes references. +required (required)
        :param str domain: Unique domain id which this set of attributes references. +required (required)
        :param str workflow: Workflow name which this set of attributes references. +required (required)
        :param str resource_type: Which type of matchable attributes to return. +required.   - TASK_RESOURCE: Applies to customizable task resource requests and limits.  - CLUSTER_RESOURCE: Applies to configuring templated kubernetes cluster resources.  - EXECUTION_QUEUE: Configures task and dynamic task execution queue assignment.  - EXECUTION_CLUSTER_LABEL: Configures the K8s cluster label to be used for execution to be run  - QUALITY_OF_SERVICE_SPECIFICATION: Configures default quality of service when undefined in an execution spec.  - PLUGIN_OVERRIDE: Selects configurable plugin implementation behavior for a given task type.  - WORKFLOW_EXECUTION_CONFIG: Adds defaults for customizable workflow-execution specifications and overrides.  - CLUSTER_ASSIGNMENT: Controls how to select an available cluster on which this execution should run.
        :return: AdminWorkflowAttributesGetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workflow_attributes_with_http_info(project, domain, workflow, **kwargs)  # noqa: E501
        else:
            (data) = self.get_workflow_attributes_with_http_info(project, domain, workflow, **kwargs)  # noqa: E501
            return data

    def get_workflow_attributes_with_http_info(self, project, domain, workflow, **kwargs):  # noqa: E501
        """Fetches custom :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for a project, domain and workflow.  # noqa: E501

        Retrieve the customized resource attributes associated with a project, domain and workflow combination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_attributes_with_http_info(project, domain, workflow, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Unique project id which this set of attributes references. +required (required)
        :param str domain: Unique domain id which this set of attributes references. +required (required)
        :param str workflow: Workflow name which this set of attributes references. +required (required)
        :param str resource_type: Which type of matchable attributes to return. +required.   - TASK_RESOURCE: Applies to customizable task resource requests and limits.  - CLUSTER_RESOURCE: Applies to configuring templated kubernetes cluster resources.  - EXECUTION_QUEUE: Configures task and dynamic task execution queue assignment.  - EXECUTION_CLUSTER_LABEL: Configures the K8s cluster label to be used for execution to be run  - QUALITY_OF_SERVICE_SPECIFICATION: Configures default quality of service when undefined in an execution spec.  - PLUGIN_OVERRIDE: Selects configurable plugin implementation behavior for a given task type.  - WORKFLOW_EXECUTION_CONFIG: Adds defaults for customizable workflow-execution specifications and overrides.  - CLUSTER_ASSIGNMENT: Controls how to select an available cluster on which this execution should run.
        :return: AdminWorkflowAttributesGetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project', 'domain', 'workflow', 'resource_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_attributes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project' is set
        if ('project' not in params or
                params['project'] is None):
            raise ValueError("Missing the required parameter `project` when calling `get_workflow_attributes`")  # noqa: E501
        # verify the required parameter 'domain' is set
        if ('domain' not in params or
                params['domain'] is None):
            raise ValueError("Missing the required parameter `domain` when calling `get_workflow_attributes`")  # noqa: E501
        # verify the required parameter 'workflow' is set
        if ('workflow' not in params or
                params['workflow'] is None):
            raise ValueError("Missing the required parameter `workflow` when calling `get_workflow_attributes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in params:
            path_params['project'] = params['project']  # noqa: E501
        if 'domain' in params:
            path_params['domain'] = params['domain']  # noqa: E501
        if 'workflow' in params:
            path_params['workflow'] = params['workflow']  # noqa: E501

        query_params = []
        if 'resource_type' in params:
            query_params.append(('resource_type', params['resource_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/workflow_attributes/{project}/{domain}/{workflow}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminWorkflowAttributesGetResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_active_launch_plans(self, project, domain, **kwargs):  # noqa: E501
        """List active versions of :ref:`ref_flyteidl.admin.LaunchPlan`.  # noqa: E501

        Fetch the active launch plan versions specified by input request filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_active_launch_plans(project, domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Name of the project that contains the identifiers. +required. (required)
        :param str domain: Name of the domain the identifiers belongs to within the project. +required. (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, the server-provided token can be used to fetch the next page in a query. +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminLaunchPlanList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_active_launch_plans_with_http_info(project, domain, **kwargs)  # noqa: E501
        else:
            (data) = self.list_active_launch_plans_with_http_info(project, domain, **kwargs)  # noqa: E501
            return data

    def list_active_launch_plans_with_http_info(self, project, domain, **kwargs):  # noqa: E501
        """List active versions of :ref:`ref_flyteidl.admin.LaunchPlan`.  # noqa: E501

        Fetch the active launch plan versions specified by input request filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_active_launch_plans_with_http_info(project, domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Name of the project that contains the identifiers. +required. (required)
        :param str domain: Name of the domain the identifiers belongs to within the project. +required. (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, the server-provided token can be used to fetch the next page in a query. +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminLaunchPlanList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project', 'domain', 'limit', 'token', 'sort_by_key', 'sort_by_direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_active_launch_plans" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project' is set
        if ('project' not in params or
                params['project'] is None):
            raise ValueError("Missing the required parameter `project` when calling `list_active_launch_plans`")  # noqa: E501
        # verify the required parameter 'domain' is set
        if ('domain' not in params or
                params['domain'] is None):
            raise ValueError("Missing the required parameter `domain` when calling `list_active_launch_plans`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in params:
            path_params['project'] = params['project']  # noqa: E501
        if 'domain' in params:
            path_params['domain'] = params['domain']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/active_launch_plans/{project}/{domain}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminLaunchPlanList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_executions(self, id_project, id_domain, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.Execution`.  # noqa: E501

        Fetch existing workflow executions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_executions(id_project, id_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans'.
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminExecutionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_executions_with_http_info(id_project, id_domain, **kwargs)  # noqa: E501
        else:
            (data) = self.list_executions_with_http_info(id_project, id_domain, **kwargs)  # noqa: E501
            return data

    def list_executions_with_http_info(self, id_project, id_domain, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.Execution`.  # noqa: E501

        Fetch existing workflow executions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_executions_with_http_info(id_project, id_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans'.
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminExecutionList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name', 'limit', 'token', 'filters', 'sort_by_key', 'sort_by_direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_executions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `list_executions`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `list_executions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501

        query_params = []
        if 'id_name' in params:
            query_params.append(('id.name', params['id_name']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/executions/{id.project}/{id.domain}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminExecutionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_launch_plan_ids(self, project, domain, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.NamedEntityIdentifier` of launch plan objects.  # noqa: E501

        Fetch existing launch plan definition identifiers matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_launch_plan_ids(project, domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Name of the project that contains the identifiers. +required (required)
        :param str domain: Name of the domain the identifiers belongs to within the project. +required (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, the server-provided token can be used to fetch the next page in a query. +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :param str filters: Indicates a list of filters passed as string. +optional.
        :return: AdminNamedEntityIdentifierList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_launch_plan_ids_with_http_info(project, domain, **kwargs)  # noqa: E501
        else:
            (data) = self.list_launch_plan_ids_with_http_info(project, domain, **kwargs)  # noqa: E501
            return data

    def list_launch_plan_ids_with_http_info(self, project, domain, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.NamedEntityIdentifier` of launch plan objects.  # noqa: E501

        Fetch existing launch plan definition identifiers matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_launch_plan_ids_with_http_info(project, domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Name of the project that contains the identifiers. +required (required)
        :param str domain: Name of the domain the identifiers belongs to within the project. +required (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, the server-provided token can be used to fetch the next page in a query. +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :param str filters: Indicates a list of filters passed as string. +optional.
        :return: AdminNamedEntityIdentifierList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project', 'domain', 'limit', 'token', 'sort_by_key', 'sort_by_direction', 'filters']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_launch_plan_ids" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project' is set
        if ('project' not in params or
                params['project'] is None):
            raise ValueError("Missing the required parameter `project` when calling `list_launch_plan_ids`")  # noqa: E501
        # verify the required parameter 'domain' is set
        if ('domain' not in params or
                params['domain'] is None):
            raise ValueError("Missing the required parameter `domain` when calling `list_launch_plan_ids`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in params:
            path_params['project'] = params['project']  # noqa: E501
        if 'domain' in params:
            path_params['domain'] = params['domain']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/launch_plan_ids/{project}/{domain}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminNamedEntityIdentifierList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_launch_plans(self, id_project, id_domain, id_name, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.LaunchPlan` definitions.  # noqa: E501

        Fetch existing launch plan definitions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_launch_plans(id_project, id_domain, id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans' (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminLaunchPlanList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_launch_plans_with_http_info(id_project, id_domain, id_name, **kwargs)  # noqa: E501
        else:
            (data) = self.list_launch_plans_with_http_info(id_project, id_domain, id_name, **kwargs)  # noqa: E501
            return data

    def list_launch_plans_with_http_info(self, id_project, id_domain, id_name, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.LaunchPlan` definitions.  # noqa: E501

        Fetch existing launch plan definitions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_launch_plans_with_http_info(id_project, id_domain, id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans' (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminLaunchPlanList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name', 'limit', 'token', 'filters', 'sort_by_key', 'sort_by_direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_launch_plans" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `list_launch_plans`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `list_launch_plans`")  # noqa: E501
        # verify the required parameter 'id_name' is set
        if ('id_name' not in params or
                params['id_name'] is None):
            raise ValueError("Missing the required parameter `id_name` when calling `list_launch_plans`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501
        if 'id_name' in params:
            path_params['id.name'] = params['id_name']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/launch_plans/{id.project}/{id.domain}/{id.name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminLaunchPlanList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_launch_plans2(self, id_project, id_domain, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.LaunchPlan` definitions.  # noqa: E501

        Fetch existing launch plan definitions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_launch_plans2(id_project, id_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans'.
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminLaunchPlanList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_launch_plans2_with_http_info(id_project, id_domain, **kwargs)  # noqa: E501
        else:
            (data) = self.list_launch_plans2_with_http_info(id_project, id_domain, **kwargs)  # noqa: E501
            return data

    def list_launch_plans2_with_http_info(self, id_project, id_domain, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.LaunchPlan` definitions.  # noqa: E501

        Fetch existing launch plan definitions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_launch_plans2_with_http_info(id_project, id_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans'.
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminLaunchPlanList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name', 'limit', 'token', 'filters', 'sort_by_key', 'sort_by_direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_launch_plans2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `list_launch_plans2`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `list_launch_plans2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501

        query_params = []
        if 'id_name' in params:
            query_params.append(('id.name', params['id_name']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/launch_plans/{id.project}/{id.domain}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminLaunchPlanList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_matchable_attributes(self, **kwargs):  # noqa: E501
        """Lists custom :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for a specific resource type.  # noqa: E501

        Retrieve a list of MatchableAttributesConfiguration objects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_matchable_attributes(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_type: +required.   - TASK_RESOURCE: Applies to customizable task resource requests and limits.  - CLUSTER_RESOURCE: Applies to configuring templated kubernetes cluster resources.  - EXECUTION_QUEUE: Configures task and dynamic task execution queue assignment.  - EXECUTION_CLUSTER_LABEL: Configures the K8s cluster label to be used for execution to be run  - QUALITY_OF_SERVICE_SPECIFICATION: Configures default quality of service when undefined in an execution spec.  - PLUGIN_OVERRIDE: Selects configurable plugin implementation behavior for a given task type.  - WORKFLOW_EXECUTION_CONFIG: Adds defaults for customizable workflow-execution specifications and overrides.  - CLUSTER_ASSIGNMENT: Controls how to select an available cluster on which this execution should run.
        :return: AdminListMatchableAttributesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_matchable_attributes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_matchable_attributes_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_matchable_attributes_with_http_info(self, **kwargs):  # noqa: E501
        """Lists custom :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for a specific resource type.  # noqa: E501

        Retrieve a list of MatchableAttributesConfiguration objects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_matchable_attributes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_type: +required.   - TASK_RESOURCE: Applies to customizable task resource requests and limits.  - CLUSTER_RESOURCE: Applies to configuring templated kubernetes cluster resources.  - EXECUTION_QUEUE: Configures task and dynamic task execution queue assignment.  - EXECUTION_CLUSTER_LABEL: Configures the K8s cluster label to be used for execution to be run  - QUALITY_OF_SERVICE_SPECIFICATION: Configures default quality of service when undefined in an execution spec.  - PLUGIN_OVERRIDE: Selects configurable plugin implementation behavior for a given task type.  - WORKFLOW_EXECUTION_CONFIG: Adds defaults for customizable workflow-execution specifications and overrides.  - CLUSTER_ASSIGNMENT: Controls how to select an available cluster on which this execution should run.
        :return: AdminListMatchableAttributesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['resource_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_matchable_attributes" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'resource_type' in params:
            query_params.append(('resource_type', params['resource_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/matchable_attributes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminListMatchableAttributesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_named_entities(self, resource_type, project, domain, **kwargs):  # noqa: E501
        """Returns a list of :ref:`ref_flyteidl.admin.NamedEntity` objects.  # noqa: E501

        Retrieve a list of NamedEntity objects sharing a common resource type, project, and domain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_named_entities(resource_type, project, domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_type: Resource type of the metadata to query. One of Task, Workflow or LaunchPlan. +required (required)
        :param str project: Name of the project that contains the identifiers. +required (required)
        :param str domain: Name of the domain the identifiers belongs to within the project. (required)
        :param int limit: Indicates the number of resources to be returned.
        :param str token: In the case of multiple pages of results, the server-provided token can be used to fetch the next page in a query. +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :param str filters: Indicates a list of filters passed as string. +optional.
        :return: AdminNamedEntityList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_named_entities_with_http_info(resource_type, project, domain, **kwargs)  # noqa: E501
        else:
            (data) = self.list_named_entities_with_http_info(resource_type, project, domain, **kwargs)  # noqa: E501
            return data

    def list_named_entities_with_http_info(self, resource_type, project, domain, **kwargs):  # noqa: E501
        """Returns a list of :ref:`ref_flyteidl.admin.NamedEntity` objects.  # noqa: E501

        Retrieve a list of NamedEntity objects sharing a common resource type, project, and domain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_named_entities_with_http_info(resource_type, project, domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_type: Resource type of the metadata to query. One of Task, Workflow or LaunchPlan. +required (required)
        :param str project: Name of the project that contains the identifiers. +required (required)
        :param str domain: Name of the domain the identifiers belongs to within the project. (required)
        :param int limit: Indicates the number of resources to be returned.
        :param str token: In the case of multiple pages of results, the server-provided token can be used to fetch the next page in a query. +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :param str filters: Indicates a list of filters passed as string. +optional.
        :return: AdminNamedEntityList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['resource_type', 'project', 'domain', 'limit', 'token', 'sort_by_key', 'sort_by_direction', 'filters']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_named_entities" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'resource_type' is set
        if ('resource_type' not in params or
                params['resource_type'] is None):
            raise ValueError("Missing the required parameter `resource_type` when calling `list_named_entities`")  # noqa: E501
        # verify the required parameter 'project' is set
        if ('project' not in params or
                params['project'] is None):
            raise ValueError("Missing the required parameter `project` when calling `list_named_entities`")  # noqa: E501
        # verify the required parameter 'domain' is set
        if ('domain' not in params or
                params['domain'] is None):
            raise ValueError("Missing the required parameter `domain` when calling `list_named_entities`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'resource_type' in params:
            path_params['resource_type'] = params['resource_type']  # noqa: E501
        if 'project' in params:
            path_params['project'] = params['project']  # noqa: E501
        if 'domain' in params:
            path_params['domain'] = params['domain']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/named_entities/{resource_type}/{project}/{domain}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminNamedEntityList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_node_executions(self, workflow_execution_id_project, workflow_execution_id_domain, workflow_execution_id_name, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.NodeExecution`.  # noqa: E501

        Fetch existing node executions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_node_executions(workflow_execution_id_project, workflow_execution_id_domain, workflow_execution_id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workflow_execution_id_project: Name of the project the resource belongs to. (required)
        :param str workflow_execution_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str workflow_execution_id_name: User or system provided value for the resource. (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token:
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :param str unique_parent_id: Unique identifier of the parent node in the execution +optional.
        :return: AdminNodeExecutionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_node_executions_with_http_info(workflow_execution_id_project, workflow_execution_id_domain, workflow_execution_id_name, **kwargs)  # noqa: E501
        else:
            (data) = self.list_node_executions_with_http_info(workflow_execution_id_project, workflow_execution_id_domain, workflow_execution_id_name, **kwargs)  # noqa: E501
            return data

    def list_node_executions_with_http_info(self, workflow_execution_id_project, workflow_execution_id_domain, workflow_execution_id_name, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.NodeExecution`.  # noqa: E501

        Fetch existing node executions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_node_executions_with_http_info(workflow_execution_id_project, workflow_execution_id_domain, workflow_execution_id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workflow_execution_id_project: Name of the project the resource belongs to. (required)
        :param str workflow_execution_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str workflow_execution_id_name: User or system provided value for the resource. (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token:
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :param str unique_parent_id: Unique identifier of the parent node in the execution +optional.
        :return: AdminNodeExecutionList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_execution_id_project', 'workflow_execution_id_domain', 'workflow_execution_id_name', 'limit', 'token', 'filters', 'sort_by_key', 'sort_by_direction', 'unique_parent_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_node_executions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_execution_id_project' is set
        if ('workflow_execution_id_project' not in params or
                params['workflow_execution_id_project'] is None):
            raise ValueError("Missing the required parameter `workflow_execution_id_project` when calling `list_node_executions`")  # noqa: E501
        # verify the required parameter 'workflow_execution_id_domain' is set
        if ('workflow_execution_id_domain' not in params or
                params['workflow_execution_id_domain'] is None):
            raise ValueError("Missing the required parameter `workflow_execution_id_domain` when calling `list_node_executions`")  # noqa: E501
        # verify the required parameter 'workflow_execution_id_name' is set
        if ('workflow_execution_id_name' not in params or
                params['workflow_execution_id_name'] is None):
            raise ValueError("Missing the required parameter `workflow_execution_id_name` when calling `list_node_executions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_execution_id_project' in params:
            path_params['workflow_execution_id.project'] = params['workflow_execution_id_project']  # noqa: E501
        if 'workflow_execution_id_domain' in params:
            path_params['workflow_execution_id.domain'] = params['workflow_execution_id_domain']  # noqa: E501
        if 'workflow_execution_id_name' in params:
            path_params['workflow_execution_id.name'] = params['workflow_execution_id_name']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501
        if 'unique_parent_id' in params:
            query_params.append(('unique_parent_id', params['unique_parent_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/node_executions/{workflow_execution_id.project}/{workflow_execution_id.domain}/{workflow_execution_id.name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminNodeExecutionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_node_executions_for_task(self, task_execution_id_node_execution_id_execution_id_project, task_execution_id_node_execution_id_execution_id_domain, task_execution_id_node_execution_id_execution_id_name, task_execution_id_node_execution_id_node_id, task_execution_id_task_id_project, task_execution_id_task_id_domain, task_execution_id_task_id_name, task_execution_id_task_id_version, task_execution_id_retry_attempt, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.NodeExecution` launched by the reference :ref:`ref_flyteidl.admin.TaskExecution`.  # noqa: E501

        Fetch child node executions launched by the specified task execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_node_executions_for_task(task_execution_id_node_execution_id_execution_id_project, task_execution_id_node_execution_id_execution_id_domain, task_execution_id_node_execution_id_execution_id_name, task_execution_id_node_execution_id_node_id, task_execution_id_task_id_project, task_execution_id_task_id_domain, task_execution_id_task_id_name, task_execution_id_task_id_version, task_execution_id_retry_attempt, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_execution_id_node_execution_id_execution_id_project: Name of the project the resource belongs to. (required)
        :param str task_execution_id_node_execution_id_execution_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str task_execution_id_node_execution_id_execution_id_name: User or system provided value for the resource. (required)
        :param str task_execution_id_node_execution_id_node_id: (required)
        :param str task_execution_id_task_id_project: Name of the project the resource belongs to. (required)
        :param str task_execution_id_task_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str task_execution_id_task_id_name: User provided value for the resource. (required)
        :param str task_execution_id_task_id_version: Specific version of the resource. (required)
        :param int task_execution_id_retry_attempt: (required)
        :param str task_execution_id_task_id_resource_type: Identifies the specific type of resource that this identifier corresponds to.   - DATASET: A dataset represents an entity modeled in Flyte DataCatalog. A Dataset is also a versioned entity and can be a compilation of multiple individual objects. Eventually all Catalog objects should be modeled similar to Flyte Objects. The Dataset entities makes it possible for the UI  and CLI to act on the objects  in a similar manner to other Flyte objects
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, the, server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminNodeExecutionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_node_executions_for_task_with_http_info(task_execution_id_node_execution_id_execution_id_project, task_execution_id_node_execution_id_execution_id_domain, task_execution_id_node_execution_id_execution_id_name, task_execution_id_node_execution_id_node_id, task_execution_id_task_id_project, task_execution_id_task_id_domain, task_execution_id_task_id_name, task_execution_id_task_id_version, task_execution_id_retry_attempt, **kwargs)  # noqa: E501
        else:
            (data) = self.list_node_executions_for_task_with_http_info(task_execution_id_node_execution_id_execution_id_project, task_execution_id_node_execution_id_execution_id_domain, task_execution_id_node_execution_id_execution_id_name, task_execution_id_node_execution_id_node_id, task_execution_id_task_id_project, task_execution_id_task_id_domain, task_execution_id_task_id_name, task_execution_id_task_id_version, task_execution_id_retry_attempt, **kwargs)  # noqa: E501
            return data

    def list_node_executions_for_task_with_http_info(self, task_execution_id_node_execution_id_execution_id_project, task_execution_id_node_execution_id_execution_id_domain, task_execution_id_node_execution_id_execution_id_name, task_execution_id_node_execution_id_node_id, task_execution_id_task_id_project, task_execution_id_task_id_domain, task_execution_id_task_id_name, task_execution_id_task_id_version, task_execution_id_retry_attempt, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.NodeExecution` launched by the reference :ref:`ref_flyteidl.admin.TaskExecution`.  # noqa: E501

        Fetch child node executions launched by the specified task execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_node_executions_for_task_with_http_info(task_execution_id_node_execution_id_execution_id_project, task_execution_id_node_execution_id_execution_id_domain, task_execution_id_node_execution_id_execution_id_name, task_execution_id_node_execution_id_node_id, task_execution_id_task_id_project, task_execution_id_task_id_domain, task_execution_id_task_id_name, task_execution_id_task_id_version, task_execution_id_retry_attempt, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str task_execution_id_node_execution_id_execution_id_project: Name of the project the resource belongs to. (required)
        :param str task_execution_id_node_execution_id_execution_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str task_execution_id_node_execution_id_execution_id_name: User or system provided value for the resource. (required)
        :param str task_execution_id_node_execution_id_node_id: (required)
        :param str task_execution_id_task_id_project: Name of the project the resource belongs to. (required)
        :param str task_execution_id_task_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str task_execution_id_task_id_name: User provided value for the resource. (required)
        :param str task_execution_id_task_id_version: Specific version of the resource. (required)
        :param int task_execution_id_retry_attempt: (required)
        :param str task_execution_id_task_id_resource_type: Identifies the specific type of resource that this identifier corresponds to.   - DATASET: A dataset represents an entity modeled in Flyte DataCatalog. A Dataset is also a versioned entity and can be a compilation of multiple individual objects. Eventually all Catalog objects should be modeled similar to Flyte Objects. The Dataset entities makes it possible for the UI  and CLI to act on the objects  in a similar manner to other Flyte objects
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, the, server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminNodeExecutionList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['task_execution_id_node_execution_id_execution_id_project', 'task_execution_id_node_execution_id_execution_id_domain', 'task_execution_id_node_execution_id_execution_id_name', 'task_execution_id_node_execution_id_node_id', 'task_execution_id_task_id_project', 'task_execution_id_task_id_domain', 'task_execution_id_task_id_name', 'task_execution_id_task_id_version', 'task_execution_id_retry_attempt', 'task_execution_id_task_id_resource_type', 'limit', 'token', 'filters', 'sort_by_key', 'sort_by_direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_node_executions_for_task" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'task_execution_id_node_execution_id_execution_id_project' is set
        if ('task_execution_id_node_execution_id_execution_id_project' not in params or
                params['task_execution_id_node_execution_id_execution_id_project'] is None):
            raise ValueError("Missing the required parameter `task_execution_id_node_execution_id_execution_id_project` when calling `list_node_executions_for_task`")  # noqa: E501
        # verify the required parameter 'task_execution_id_node_execution_id_execution_id_domain' is set
        if ('task_execution_id_node_execution_id_execution_id_domain' not in params or
                params['task_execution_id_node_execution_id_execution_id_domain'] is None):
            raise ValueError("Missing the required parameter `task_execution_id_node_execution_id_execution_id_domain` when calling `list_node_executions_for_task`")  # noqa: E501
        # verify the required parameter 'task_execution_id_node_execution_id_execution_id_name' is set
        if ('task_execution_id_node_execution_id_execution_id_name' not in params or
                params['task_execution_id_node_execution_id_execution_id_name'] is None):
            raise ValueError("Missing the required parameter `task_execution_id_node_execution_id_execution_id_name` when calling `list_node_executions_for_task`")  # noqa: E501
        # verify the required parameter 'task_execution_id_node_execution_id_node_id' is set
        if ('task_execution_id_node_execution_id_node_id' not in params or
                params['task_execution_id_node_execution_id_node_id'] is None):
            raise ValueError("Missing the required parameter `task_execution_id_node_execution_id_node_id` when calling `list_node_executions_for_task`")  # noqa: E501
        # verify the required parameter 'task_execution_id_task_id_project' is set
        if ('task_execution_id_task_id_project' not in params or
                params['task_execution_id_task_id_project'] is None):
            raise ValueError("Missing the required parameter `task_execution_id_task_id_project` when calling `list_node_executions_for_task`")  # noqa: E501
        # verify the required parameter 'task_execution_id_task_id_domain' is set
        if ('task_execution_id_task_id_domain' not in params or
                params['task_execution_id_task_id_domain'] is None):
            raise ValueError("Missing the required parameter `task_execution_id_task_id_domain` when calling `list_node_executions_for_task`")  # noqa: E501
        # verify the required parameter 'task_execution_id_task_id_name' is set
        if ('task_execution_id_task_id_name' not in params or
                params['task_execution_id_task_id_name'] is None):
            raise ValueError("Missing the required parameter `task_execution_id_task_id_name` when calling `list_node_executions_for_task`")  # noqa: E501
        # verify the required parameter 'task_execution_id_task_id_version' is set
        if ('task_execution_id_task_id_version' not in params or
                params['task_execution_id_task_id_version'] is None):
            raise ValueError("Missing the required parameter `task_execution_id_task_id_version` when calling `list_node_executions_for_task`")  # noqa: E501
        # verify the required parameter 'task_execution_id_retry_attempt' is set
        if ('task_execution_id_retry_attempt' not in params or
                params['task_execution_id_retry_attempt'] is None):
            raise ValueError("Missing the required parameter `task_execution_id_retry_attempt` when calling `list_node_executions_for_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'task_execution_id_node_execution_id_execution_id_project' in params:
            path_params['task_execution_id.node_execution_id.execution_id.project'] = params['task_execution_id_node_execution_id_execution_id_project']  # noqa: E501
        if 'task_execution_id_node_execution_id_execution_id_domain' in params:
            path_params['task_execution_id.node_execution_id.execution_id.domain'] = params['task_execution_id_node_execution_id_execution_id_domain']  # noqa: E501
        if 'task_execution_id_node_execution_id_execution_id_name' in params:
            path_params['task_execution_id.node_execution_id.execution_id.name'] = params['task_execution_id_node_execution_id_execution_id_name']  # noqa: E501
        if 'task_execution_id_node_execution_id_node_id' in params:
            path_params['task_execution_id.node_execution_id.node_id'] = params['task_execution_id_node_execution_id_node_id']  # noqa: E501
        if 'task_execution_id_task_id_project' in params:
            path_params['task_execution_id.task_id.project'] = params['task_execution_id_task_id_project']  # noqa: E501
        if 'task_execution_id_task_id_domain' in params:
            path_params['task_execution_id.task_id.domain'] = params['task_execution_id_task_id_domain']  # noqa: E501
        if 'task_execution_id_task_id_name' in params:
            path_params['task_execution_id.task_id.name'] = params['task_execution_id_task_id_name']  # noqa: E501
        if 'task_execution_id_task_id_version' in params:
            path_params['task_execution_id.task_id.version'] = params['task_execution_id_task_id_version']  # noqa: E501
        if 'task_execution_id_retry_attempt' in params:
            path_params['task_execution_id.retry_attempt'] = params['task_execution_id_retry_attempt']  # noqa: E501

        query_params = []
        if 'task_execution_id_task_id_resource_type' in params:
            query_params.append(('task_execution_id.task_id.resource_type', params['task_execution_id_task_id_resource_type']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/children/task_executions/{task_execution_id.node_execution_id.execution_id.project}/{task_execution_id.node_execution_id.execution_id.domain}/{task_execution_id.node_execution_id.execution_id.name}/{task_execution_id.node_execution_id.node_id}/{task_execution_id.task_id.project}/{task_execution_id.task_id.domain}/{task_execution_id.task_id.name}/{task_execution_id.task_id.version}/{task_execution_id.retry_attempt}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminNodeExecutionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_projects(self, **kwargs):  # noqa: E501
        """Fetches a list of :ref:`ref_flyteidl.admin.Project`  # noqa: E501

        Fetch registered projects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_projects(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Indicates the number of projects to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminProjects
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_projects_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_projects_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_projects_with_http_info(self, **kwargs):  # noqa: E501
        """Fetches a list of :ref:`ref_flyteidl.admin.Project`  # noqa: E501

        Fetch registered projects.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_projects_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Indicates the number of projects to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminProjects
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'token', 'filters', 'sort_by_key', 'sort_by_direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_projects" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/projects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminProjects',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_task_executions(self, node_execution_id_execution_id_project, node_execution_id_execution_id_domain, node_execution_id_execution_id_name, node_execution_id_node_id, **kwargs):  # noqa: E501
        """Fetches a list of :ref:`ref_flyteidl.admin.TaskExecution`.  # noqa: E501

        Fetch existing task executions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_task_executions(node_execution_id_execution_id_project, node_execution_id_execution_id_domain, node_execution_id_execution_id_name, node_execution_id_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str node_execution_id_execution_id_project: Name of the project the resource belongs to. (required)
        :param str node_execution_id_execution_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str node_execution_id_execution_id_name: User or system provided value for the resource. (required)
        :param str node_execution_id_node_id: (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, the server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminTaskExecutionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_task_executions_with_http_info(node_execution_id_execution_id_project, node_execution_id_execution_id_domain, node_execution_id_execution_id_name, node_execution_id_node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_task_executions_with_http_info(node_execution_id_execution_id_project, node_execution_id_execution_id_domain, node_execution_id_execution_id_name, node_execution_id_node_id, **kwargs)  # noqa: E501
            return data

    def list_task_executions_with_http_info(self, node_execution_id_execution_id_project, node_execution_id_execution_id_domain, node_execution_id_execution_id_name, node_execution_id_node_id, **kwargs):  # noqa: E501
        """Fetches a list of :ref:`ref_flyteidl.admin.TaskExecution`.  # noqa: E501

        Fetch existing task executions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_task_executions_with_http_info(node_execution_id_execution_id_project, node_execution_id_execution_id_domain, node_execution_id_execution_id_name, node_execution_id_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str node_execution_id_execution_id_project: Name of the project the resource belongs to. (required)
        :param str node_execution_id_execution_id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str node_execution_id_execution_id_name: User or system provided value for the resource. (required)
        :param str node_execution_id_node_id: (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, the server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminTaskExecutionList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_execution_id_execution_id_project', 'node_execution_id_execution_id_domain', 'node_execution_id_execution_id_name', 'node_execution_id_node_id', 'limit', 'token', 'filters', 'sort_by_key', 'sort_by_direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_task_executions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_execution_id_execution_id_project' is set
        if ('node_execution_id_execution_id_project' not in params or
                params['node_execution_id_execution_id_project'] is None):
            raise ValueError("Missing the required parameter `node_execution_id_execution_id_project` when calling `list_task_executions`")  # noqa: E501
        # verify the required parameter 'node_execution_id_execution_id_domain' is set
        if ('node_execution_id_execution_id_domain' not in params or
                params['node_execution_id_execution_id_domain'] is None):
            raise ValueError("Missing the required parameter `node_execution_id_execution_id_domain` when calling `list_task_executions`")  # noqa: E501
        # verify the required parameter 'node_execution_id_execution_id_name' is set
        if ('node_execution_id_execution_id_name' not in params or
                params['node_execution_id_execution_id_name'] is None):
            raise ValueError("Missing the required parameter `node_execution_id_execution_id_name` when calling `list_task_executions`")  # noqa: E501
        # verify the required parameter 'node_execution_id_node_id' is set
        if ('node_execution_id_node_id' not in params or
                params['node_execution_id_node_id'] is None):
            raise ValueError("Missing the required parameter `node_execution_id_node_id` when calling `list_task_executions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'node_execution_id_execution_id_project' in params:
            path_params['node_execution_id.execution_id.project'] = params['node_execution_id_execution_id_project']  # noqa: E501
        if 'node_execution_id_execution_id_domain' in params:
            path_params['node_execution_id.execution_id.domain'] = params['node_execution_id_execution_id_domain']  # noqa: E501
        if 'node_execution_id_execution_id_name' in params:
            path_params['node_execution_id.execution_id.name'] = params['node_execution_id_execution_id_name']  # noqa: E501
        if 'node_execution_id_node_id' in params:
            path_params['node_execution_id.node_id'] = params['node_execution_id_node_id']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/task_executions/{node_execution_id.execution_id.project}/{node_execution_id.execution_id.domain}/{node_execution_id.execution_id.name}/{node_execution_id.node_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminTaskExecutionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_task_ids(self, project, domain, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.NamedEntityIdentifier` of task objects.  # noqa: E501

        Fetch existing task definition identifiers matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_task_ids(project, domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Name of the project that contains the identifiers. +required (required)
        :param str domain: Name of the domain the identifiers belongs to within the project. +required (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, the server-provided token can be used to fetch the next page in a query. +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :param str filters: Indicates a list of filters passed as string. +optional.
        :return: AdminNamedEntityIdentifierList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_task_ids_with_http_info(project, domain, **kwargs)  # noqa: E501
        else:
            (data) = self.list_task_ids_with_http_info(project, domain, **kwargs)  # noqa: E501
            return data

    def list_task_ids_with_http_info(self, project, domain, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.NamedEntityIdentifier` of task objects.  # noqa: E501

        Fetch existing task definition identifiers matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_task_ids_with_http_info(project, domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Name of the project that contains the identifiers. +required (required)
        :param str domain: Name of the domain the identifiers belongs to within the project. +required (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, the server-provided token can be used to fetch the next page in a query. +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :param str filters: Indicates a list of filters passed as string. +optional.
        :return: AdminNamedEntityIdentifierList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project', 'domain', 'limit', 'token', 'sort_by_key', 'sort_by_direction', 'filters']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_task_ids" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project' is set
        if ('project' not in params or
                params['project'] is None):
            raise ValueError("Missing the required parameter `project` when calling `list_task_ids`")  # noqa: E501
        # verify the required parameter 'domain' is set
        if ('domain' not in params or
                params['domain'] is None):
            raise ValueError("Missing the required parameter `domain` when calling `list_task_ids`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in params:
            path_params['project'] = params['project']  # noqa: E501
        if 'domain' in params:
            path_params['domain'] = params['domain']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/task_ids/{project}/{domain}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminNamedEntityIdentifierList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_tasks(self, id_project, id_domain, id_name, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.Task` definitions.  # noqa: E501

        Fetch existing task definitions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tasks(id_project, id_domain, id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans' (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminTaskList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_tasks_with_http_info(id_project, id_domain, id_name, **kwargs)  # noqa: E501
        else:
            (data) = self.list_tasks_with_http_info(id_project, id_domain, id_name, **kwargs)  # noqa: E501
            return data

    def list_tasks_with_http_info(self, id_project, id_domain, id_name, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.Task` definitions.  # noqa: E501

        Fetch existing task definitions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tasks_with_http_info(id_project, id_domain, id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans' (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminTaskList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name', 'limit', 'token', 'filters', 'sort_by_key', 'sort_by_direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_tasks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `list_tasks`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `list_tasks`")  # noqa: E501
        # verify the required parameter 'id_name' is set
        if ('id_name' not in params or
                params['id_name'] is None):
            raise ValueError("Missing the required parameter `id_name` when calling `list_tasks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501
        if 'id_name' in params:
            path_params['id.name'] = params['id_name']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/tasks/{id.project}/{id.domain}/{id.name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminTaskList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_tasks2(self, id_project, id_domain, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.Task` definitions.  # noqa: E501

        Fetch existing task definitions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tasks2(id_project, id_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans'.
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminTaskList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_tasks2_with_http_info(id_project, id_domain, **kwargs)  # noqa: E501
        else:
            (data) = self.list_tasks2_with_http_info(id_project, id_domain, **kwargs)  # noqa: E501
            return data

    def list_tasks2_with_http_info(self, id_project, id_domain, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.Task` definitions.  # noqa: E501

        Fetch existing task definitions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tasks2_with_http_info(id_project, id_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans'.
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminTaskList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name', 'limit', 'token', 'filters', 'sort_by_key', 'sort_by_direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_tasks2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `list_tasks2`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `list_tasks2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501

        query_params = []
        if 'id_name' in params:
            query_params.append(('id.name', params['id_name']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/tasks/{id.project}/{id.domain}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminTaskList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_workflow_ids(self, project, domain, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.NamedEntityIdentifier` of workflow objects.  # noqa: E501

        Fetch an existing workflow definition identifiers matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workflow_ids(project, domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Name of the project that contains the identifiers. +required (required)
        :param str domain: Name of the domain the identifiers belongs to within the project. +required (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, the server-provided token can be used to fetch the next page in a query. +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :param str filters: Indicates a list of filters passed as string. +optional.
        :return: AdminNamedEntityIdentifierList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_workflow_ids_with_http_info(project, domain, **kwargs)  # noqa: E501
        else:
            (data) = self.list_workflow_ids_with_http_info(project, domain, **kwargs)  # noqa: E501
            return data

    def list_workflow_ids_with_http_info(self, project, domain, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.NamedEntityIdentifier` of workflow objects.  # noqa: E501

        Fetch an existing workflow definition identifiers matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workflow_ids_with_http_info(project, domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project: Name of the project that contains the identifiers. +required (required)
        :param str domain: Name of the domain the identifiers belongs to within the project. +required (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, the server-provided token can be used to fetch the next page in a query. +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :param str filters: Indicates a list of filters passed as string. +optional.
        :return: AdminNamedEntityIdentifierList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project', 'domain', 'limit', 'token', 'sort_by_key', 'sort_by_direction', 'filters']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_workflow_ids" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project' is set
        if ('project' not in params or
                params['project'] is None):
            raise ValueError("Missing the required parameter `project` when calling `list_workflow_ids`")  # noqa: E501
        # verify the required parameter 'domain' is set
        if ('domain' not in params or
                params['domain'] is None):
            raise ValueError("Missing the required parameter `domain` when calling `list_workflow_ids`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project' in params:
            path_params['project'] = params['project']  # noqa: E501
        if 'domain' in params:
            path_params['domain'] = params['domain']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/workflow_ids/{project}/{domain}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminNamedEntityIdentifierList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_workflows(self, id_project, id_domain, id_name, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.Workflow` definitions.  # noqa: E501

        Fetch existing workflow definitions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workflows(id_project, id_domain, id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans' (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminWorkflowList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_workflows_with_http_info(id_project, id_domain, id_name, **kwargs)  # noqa: E501
        else:
            (data) = self.list_workflows_with_http_info(id_project, id_domain, id_name, **kwargs)  # noqa: E501
            return data

    def list_workflows_with_http_info(self, id_project, id_domain, id_name, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.Workflow` definitions.  # noqa: E501

        Fetch existing workflow definitions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workflows_with_http_info(id_project, id_domain, id_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans' (required)
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminWorkflowList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name', 'limit', 'token', 'filters', 'sort_by_key', 'sort_by_direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_workflows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `list_workflows`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `list_workflows`")  # noqa: E501
        # verify the required parameter 'id_name' is set
        if ('id_name' not in params or
                params['id_name'] is None):
            raise ValueError("Missing the required parameter `id_name` when calling `list_workflows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501
        if 'id_name' in params:
            path_params['id.name'] = params['id_name']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/workflows/{id.project}/{id.domain}/{id.name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminWorkflowList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_workflows2(self, id_project, id_domain, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.Workflow` definitions.  # noqa: E501

        Fetch existing workflow definitions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workflows2(id_project, id_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans'.
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminWorkflowList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_workflows2_with_http_info(id_project, id_domain, **kwargs)  # noqa: E501
        else:
            (data) = self.list_workflows2_with_http_info(id_project, id_domain, **kwargs)  # noqa: E501
            return data

    def list_workflows2_with_http_info(self, id_project, id_domain, **kwargs):  # noqa: E501
        """Fetch a list of :ref:`ref_flyteidl.admin.Workflow` definitions.  # noqa: E501

        Fetch existing workflow definitions matching input filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workflows2_with_http_info(id_project, id_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans'.
        :param int limit: Indicates the number of resources to be returned. +required.
        :param str token: In the case of multiple pages of results, this server-provided token can be used to fetch the next page in a query. +optional.
        :param str filters: Indicates a list of filters passed as string. More info on constructing filters : <Link> +optional.
        :param str sort_by_key: Indicates an attribute to sort the response values. +required.
        :param str sort_by_direction: Indicates the direction to apply sort key for response values. +optional.   - DESCENDING: By default, fields are sorted in descending order.
        :return: AdminWorkflowList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name', 'limit', 'token', 'filters', 'sort_by_key', 'sort_by_direction']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_workflows2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `list_workflows2`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `list_workflows2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501

        query_params = []
        if 'id_name' in params:
            query_params.append(('id.name', params['id_name']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'token' in params:
            query_params.append(('token', params['token']))  # noqa: E501
        if 'filters' in params:
            query_params.append(('filters', params['filters']))  # noqa: E501
        if 'sort_by_key' in params:
            query_params.append(('sort_by.key', params['sort_by_key']))  # noqa: E501
        if 'sort_by_direction' in params:
            query_params.append(('sort_by.direction', params['sort_by_direction']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/workflows/{id.project}/{id.domain}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminWorkflowList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def recover_execution(self, body, **kwargs):  # noqa: E501
        """Recreates a previously-run workflow execution that will only start executing from the last known failure point. In Recover mode, users cannot change any input parameters or update the version of the execution. This is extremely useful to recover from system errors and byzantine faults like - Loss of K8s cluster, bugs in platform or instability, machine failures, downstream system failures (downstream services), or simply to recover executions that failed because of retry exhaustion and should complete if tried again. See :ref:`ref_flyteidl.admin.ExecutionRecoverRequest` for more details.  # noqa: E501

        Recreates a previously-run workflow execution that will only start executing from the last known failure point. In Recover mode, users cannot change any input parameters or update the version of the execution. This is extremely useful to recover from system errors and byzantine faults like - Loss of K8s cluster, bugs in platform or instability, machine failures, downstream system failures (downstream services), or simply to recover executions that failed because of retry exhaustion and should complete if tried again.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.recover_execution(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminExecutionRecoverRequest body: (required)
        :return: AdminExecutionCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.recover_execution_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.recover_execution_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def recover_execution_with_http_info(self, body, **kwargs):  # noqa: E501
        """Recreates a previously-run workflow execution that will only start executing from the last known failure point. In Recover mode, users cannot change any input parameters or update the version of the execution. This is extremely useful to recover from system errors and byzantine faults like - Loss of K8s cluster, bugs in platform or instability, machine failures, downstream system failures (downstream services), or simply to recover executions that failed because of retry exhaustion and should complete if tried again. See :ref:`ref_flyteidl.admin.ExecutionRecoverRequest` for more details.  # noqa: E501

        Recreates a previously-run workflow execution that will only start executing from the last known failure point. In Recover mode, users cannot change any input parameters or update the version of the execution. This is extremely useful to recover from system errors and byzantine faults like - Loss of K8s cluster, bugs in platform or instability, machine failures, downstream system failures (downstream services), or simply to recover executions that failed because of retry exhaustion and should complete if tried again.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.recover_execution_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminExecutionRecoverRequest body: (required)
        :return: AdminExecutionCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recover_execution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `recover_execution`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/executions/recover', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminExecutionCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_project(self, body, **kwargs):  # noqa: E501
        """Registers a :ref:`ref_flyteidl.admin.Project` with the Flyte deployment.  # noqa: E501

        Register a project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_project(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminProjectRegisterRequest body: (required)
        :return: AdminProjectRegisterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_project_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.register_project_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def register_project_with_http_info(self, body, **kwargs):  # noqa: E501
        """Registers a :ref:`ref_flyteidl.admin.Project` with the Flyte deployment.  # noqa: E501

        Register a project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_project_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminProjectRegisterRequest body: (required)
        :return: AdminProjectRegisterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `register_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/projects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminProjectRegisterResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def relaunch_execution(self, body, **kwargs):  # noqa: E501
        """Triggers the creation of an identical :ref:`ref_flyteidl.admin.Execution`  # noqa: E501

        Relaunch a workflow execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.relaunch_execution(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminExecutionRelaunchRequest body: (required)
        :return: AdminExecutionCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.relaunch_execution_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.relaunch_execution_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def relaunch_execution_with_http_info(self, body, **kwargs):  # noqa: E501
        """Triggers the creation of an identical :ref:`ref_flyteidl.admin.Execution`  # noqa: E501

        Relaunch a workflow execution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.relaunch_execution_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AdminExecutionRelaunchRequest body: (required)
        :return: AdminExecutionCreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method relaunch_execution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `relaunch_execution`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/executions/relaunch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminExecutionCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def terminate_execution(self, id_project, id_domain, id_name, body, **kwargs):  # noqa: E501
        """Terminates an in-progress :ref:`ref_flyteidl.admin.Execution`.  # noqa: E501

        Terminate the active workflow execution specified in the request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.terminate_execution(id_project, id_domain, id_name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User or system provided value for the resource. (required)
        :param AdminExecutionTerminateRequest body: (required)
        :return: AdminExecutionTerminateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.terminate_execution_with_http_info(id_project, id_domain, id_name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.terminate_execution_with_http_info(id_project, id_domain, id_name, body, **kwargs)  # noqa: E501
            return data

    def terminate_execution_with_http_info(self, id_project, id_domain, id_name, body, **kwargs):  # noqa: E501
        """Terminates an in-progress :ref:`ref_flyteidl.admin.Execution`.  # noqa: E501

        Terminate the active workflow execution specified in the request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.terminate_execution_with_http_info(id_project, id_domain, id_name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User or system provided value for the resource. (required)
        :param AdminExecutionTerminateRequest body: (required)
        :return: AdminExecutionTerminateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method terminate_execution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `terminate_execution`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `terminate_execution`")  # noqa: E501
        # verify the required parameter 'id_name' is set
        if ('id_name' not in params or
                params['id_name'] is None):
            raise ValueError("Missing the required parameter `id_name` when calling `terminate_execution`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `terminate_execution`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501
        if 'id_name' in params:
            path_params['id.name'] = params['id_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/executions/{id.project}/{id.domain}/{id.name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminExecutionTerminateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_execution(self, id_project, id_domain, id_name, body, **kwargs):  # noqa: E501
        """Update execution belonging to project domain :ref:`ref_flyteidl.admin.Execution`.  # noqa: E501

        Update execution belonging to project domain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_execution(id_project, id_domain, id_name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User or system provided value for the resource. (required)
        :param AdminExecutionUpdateRequest body: (required)
        :return: AdminExecutionUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_execution_with_http_info(id_project, id_domain, id_name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_execution_with_http_info(id_project, id_domain, id_name, body, **kwargs)  # noqa: E501
            return data

    def update_execution_with_http_info(self, id_project, id_domain, id_name, body, **kwargs):  # noqa: E501
        """Update execution belonging to project domain :ref:`ref_flyteidl.admin.Execution`.  # noqa: E501

        Update execution belonging to project domain.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_execution_with_http_info(id_project, id_domain, id_name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User or system provided value for the resource. (required)
        :param AdminExecutionUpdateRequest body: (required)
        :return: AdminExecutionUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_execution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `update_execution`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `update_execution`")  # noqa: E501
        # verify the required parameter 'id_name' is set
        if ('id_name' not in params or
                params['id_name'] is None):
            raise ValueError("Missing the required parameter `id_name` when calling `update_execution`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_execution`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501
        if 'id_name' in params:
            path_params['id.name'] = params['id_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/executions/{id.project}/{id.domain}/{id.name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminExecutionUpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_launch_plan(self, id_project, id_domain, id_name, id_version, body, **kwargs):  # noqa: E501
        """Updates the status of a registered :ref:`ref_flyteidl.admin.LaunchPlan`.  # noqa: E501

        Update the status of an existing launch plan definition. At most one launch plan version for a given {project, domain, name} can be active at a time. If this call sets a launch plan to active and existing version is already active, the result of this call will be that the formerly active launch plan will be made inactive and specified launch plan in this request will be made active. In the event that the formerly active launch plan had a schedule associated it with it, this schedule will be disabled. If the reference launch plan in this request is being set to active and has a schedule associated with it, the schedule will be enabled.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_launch_plan(id_project, id_domain, id_name, id_version, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. (required)
        :param str id_version: Specific version of the resource. (required)
        :param AdminLaunchPlanUpdateRequest body: (required)
        :return: AdminLaunchPlanUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_launch_plan_with_http_info(id_project, id_domain, id_name, id_version, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_launch_plan_with_http_info(id_project, id_domain, id_name, id_version, body, **kwargs)  # noqa: E501
            return data

    def update_launch_plan_with_http_info(self, id_project, id_domain, id_name, id_version, body, **kwargs):  # noqa: E501
        """Updates the status of a registered :ref:`ref_flyteidl.admin.LaunchPlan`.  # noqa: E501

        Update the status of an existing launch plan definition. At most one launch plan version for a given {project, domain, name} can be active at a time. If this call sets a launch plan to active and existing version is already active, the result of this call will be that the formerly active launch plan will be made inactive and specified launch plan in this request will be made active. In the event that the formerly active launch plan had a schedule associated it with it, this schedule will be disabled. If the reference launch plan in this request is being set to active and has a schedule associated with it, the schedule will be enabled.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_launch_plan_with_http_info(id_project, id_domain, id_name, id_version, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. (required)
        :param str id_version: Specific version of the resource. (required)
        :param AdminLaunchPlanUpdateRequest body: (required)
        :return: AdminLaunchPlanUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_project', 'id_domain', 'id_name', 'id_version', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_launch_plan" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `update_launch_plan`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `update_launch_plan`")  # noqa: E501
        # verify the required parameter 'id_name' is set
        if ('id_name' not in params or
                params['id_name'] is None):
            raise ValueError("Missing the required parameter `id_name` when calling `update_launch_plan`")  # noqa: E501
        # verify the required parameter 'id_version' is set
        if ('id_version' not in params or
                params['id_version'] is None):
            raise ValueError("Missing the required parameter `id_version` when calling `update_launch_plan`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_launch_plan`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501
        if 'id_name' in params:
            path_params['id.name'] = params['id_name']  # noqa: E501
        if 'id_version' in params:
            path_params['id.version'] = params['id_version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/launch_plans/{id.project}/{id.domain}/{id.name}/{id.version}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminLaunchPlanUpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_named_entity(self, resource_type, id_project, id_domain, id_name, body, **kwargs):  # noqa: E501
        """Updates a :ref:`ref_flyteidl.admin.NamedEntity` object.  # noqa: E501

        Update the fields associated with a NamedEntity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_named_entity(resource_type, id_project, id_domain, id_name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_type: Resource type of the metadata to update +required (required)
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans' (required)
        :param AdminNamedEntityUpdateRequest body: (required)
        :return: AdminNamedEntityUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_named_entity_with_http_info(resource_type, id_project, id_domain, id_name, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_named_entity_with_http_info(resource_type, id_project, id_domain, id_name, body, **kwargs)  # noqa: E501
            return data

    def update_named_entity_with_http_info(self, resource_type, id_project, id_domain, id_name, body, **kwargs):  # noqa: E501
        """Updates a :ref:`ref_flyteidl.admin.NamedEntity` object.  # noqa: E501

        Update the fields associated with a NamedEntity  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_named_entity_with_http_info(resource_type, id_project, id_domain, id_name, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str resource_type: Resource type of the metadata to update +required (required)
        :param str id_project: Name of the project the resource belongs to. (required)
        :param str id_domain: Name of the domain the resource belongs to. A domain can be considered as a subset within a specific project. (required)
        :param str id_name: User provided value for the resource. The combination of project + domain + name uniquely identifies the resource. +optional - in certain contexts - like 'List API', 'Launch plans' (required)
        :param AdminNamedEntityUpdateRequest body: (required)
        :return: AdminNamedEntityUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['resource_type', 'id_project', 'id_domain', 'id_name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_named_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'resource_type' is set
        if ('resource_type' not in params or
                params['resource_type'] is None):
            raise ValueError("Missing the required parameter `resource_type` when calling `update_named_entity`")  # noqa: E501
        # verify the required parameter 'id_project' is set
        if ('id_project' not in params or
                params['id_project'] is None):
            raise ValueError("Missing the required parameter `id_project` when calling `update_named_entity`")  # noqa: E501
        # verify the required parameter 'id_domain' is set
        if ('id_domain' not in params or
                params['id_domain'] is None):
            raise ValueError("Missing the required parameter `id_domain` when calling `update_named_entity`")  # noqa: E501
        # verify the required parameter 'id_name' is set
        if ('id_name' not in params or
                params['id_name'] is None):
            raise ValueError("Missing the required parameter `id_name` when calling `update_named_entity`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_named_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'resource_type' in params:
            path_params['resource_type'] = params['resource_type']  # noqa: E501
        if 'id_project' in params:
            path_params['id.project'] = params['id_project']  # noqa: E501
        if 'id_domain' in params:
            path_params['id.domain'] = params['id_domain']  # noqa: E501
        if 'id_name' in params:
            path_params['id.name'] = params['id_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/named_entities/{resource_type}/{id.project}/{id.domain}/{id.name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminNamedEntityUpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_project(self, id, body, **kwargs):  # noqa: E501
        """Updates an existing :ref:`ref_flyteidl.admin.Project`  flyteidl.admin.Project should be passed but the domains property should be empty; it will be ignored in the handler as domains cannot be updated via this API.  # noqa: E501

        Update a project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Globally unique project name. (required)
        :param AdminProject body: (required)
        :return: AdminProjectUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_project_with_http_info(id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_project_with_http_info(id, body, **kwargs)  # noqa: E501
            return data

    def update_project_with_http_info(self, id, body, **kwargs):  # noqa: E501
        """Updates an existing :ref:`ref_flyteidl.admin.Project`  flyteidl.admin.Project should be passed but the domains property should be empty; it will be ignored in the handler as domains cannot be updated via this API.  # noqa: E501

        Update a project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_with_http_info(id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Globally unique project name. (required)
        :param AdminProject body: (required)
        :return: AdminProjectUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_project`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_project`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/projects/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminProjectUpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_project_domain_attributes(self, attributes_project, attributes_domain, body, **kwargs):  # noqa: E501
        """Creates or updates custom :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for a project and domain.  # noqa: E501

        Update the customized resource attributes associated with a project-domain combination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_domain_attributes(attributes_project, attributes_domain, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str attributes_project: Unique project id for which this set of attributes will be applied. (required)
        :param str attributes_domain: Unique domain id for which this set of attributes will be applied. (required)
        :param AdminProjectDomainAttributesUpdateRequest body: (required)
        :return: AdminProjectDomainAttributesUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_project_domain_attributes_with_http_info(attributes_project, attributes_domain, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_project_domain_attributes_with_http_info(attributes_project, attributes_domain, body, **kwargs)  # noqa: E501
            return data

    def update_project_domain_attributes_with_http_info(self, attributes_project, attributes_domain, body, **kwargs):  # noqa: E501
        """Creates or updates custom :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for a project and domain.  # noqa: E501

        Update the customized resource attributes associated with a project-domain combination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_domain_attributes_with_http_info(attributes_project, attributes_domain, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str attributes_project: Unique project id for which this set of attributes will be applied. (required)
        :param str attributes_domain: Unique domain id for which this set of attributes will be applied. (required)
        :param AdminProjectDomainAttributesUpdateRequest body: (required)
        :return: AdminProjectDomainAttributesUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['attributes_project', 'attributes_domain', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project_domain_attributes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'attributes_project' is set
        if ('attributes_project' not in params or
                params['attributes_project'] is None):
            raise ValueError("Missing the required parameter `attributes_project` when calling `update_project_domain_attributes`")  # noqa: E501
        # verify the required parameter 'attributes_domain' is set
        if ('attributes_domain' not in params or
                params['attributes_domain'] is None):
            raise ValueError("Missing the required parameter `attributes_domain` when calling `update_project_domain_attributes`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_project_domain_attributes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'attributes_project' in params:
            path_params['attributes.project'] = params['attributes_project']  # noqa: E501
        if 'attributes_domain' in params:
            path_params['attributes.domain'] = params['attributes_domain']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/project_domain_attributes/{attributes.project}/{attributes.domain}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminProjectDomainAttributesUpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_workflow_attributes(self, attributes_project, attributes_domain, attributes_workflow, body, **kwargs):  # noqa: E501
        """Creates or updates custom :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for a project, domain and workflow.  # noqa: E501

        Update the customized resource attributes associated with a project, domain and workflow combination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workflow_attributes(attributes_project, attributes_domain, attributes_workflow, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str attributes_project: Unique project id for which this set of attributes will be applied. (required)
        :param str attributes_domain: Unique domain id for which this set of attributes will be applied. (required)
        :param str attributes_workflow: Workflow name for which this set of attributes will be applied. (required)
        :param AdminWorkflowAttributesUpdateRequest body: (required)
        :return: AdminWorkflowAttributesUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_workflow_attributes_with_http_info(attributes_project, attributes_domain, attributes_workflow, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_workflow_attributes_with_http_info(attributes_project, attributes_domain, attributes_workflow, body, **kwargs)  # noqa: E501
            return data

    def update_workflow_attributes_with_http_info(self, attributes_project, attributes_domain, attributes_workflow, body, **kwargs):  # noqa: E501
        """Creates or updates custom :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for a project, domain and workflow.  # noqa: E501

        Update the customized resource attributes associated with a project, domain and workflow combination  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workflow_attributes_with_http_info(attributes_project, attributes_domain, attributes_workflow, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str attributes_project: Unique project id for which this set of attributes will be applied. (required)
        :param str attributes_domain: Unique domain id for which this set of attributes will be applied. (required)
        :param str attributes_workflow: Workflow name for which this set of attributes will be applied. (required)
        :param AdminWorkflowAttributesUpdateRequest body: (required)
        :return: AdminWorkflowAttributesUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['attributes_project', 'attributes_domain', 'attributes_workflow', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_workflow_attributes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'attributes_project' is set
        if ('attributes_project' not in params or
                params['attributes_project'] is None):
            raise ValueError("Missing the required parameter `attributes_project` when calling `update_workflow_attributes`")  # noqa: E501
        # verify the required parameter 'attributes_domain' is set
        if ('attributes_domain' not in params or
                params['attributes_domain'] is None):
            raise ValueError("Missing the required parameter `attributes_domain` when calling `update_workflow_attributes`")  # noqa: E501
        # verify the required parameter 'attributes_workflow' is set
        if ('attributes_workflow' not in params or
                params['attributes_workflow'] is None):
            raise ValueError("Missing the required parameter `attributes_workflow` when calling `update_workflow_attributes`")  # noqa: E501
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_workflow_attributes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'attributes_project' in params:
            path_params['attributes.project'] = params['attributes_project']  # noqa: E501
        if 'attributes_domain' in params:
            path_params['attributes.domain'] = params['attributes_domain']  # noqa: E501
        if 'attributes_workflow' in params:
            path_params['attributes.workflow'] = params['attributes_workflow']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/workflow_attributes/{attributes.project}/{attributes.domain}/{attributes.workflow}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdminWorkflowAttributesUpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
