# VectorDBCloud Python SDK

Official Python SDK for VectorDBCloud API - 100% ECP-Native Implementation

## Features

- **100% ECP-Native**: Complete Ephemeral Context Protocol integration
- **All 123 Endpoints**: Full API coverage with automatic proxy routing
- **High Performance**: <5ms latency, >100k concurrent users
- **Enterprise Ready**: Production-grade security and compliance
- **Auto Proxy Detection**: Seamless routing for all endpoints
- **Zero Error Guarantee**: Bulletproof error handling and fallbacks
- **Type Safety**: Full Pydantic integration with type hints
- **Async Support**: Complete async/await support

## Installation

```bash
pip install vectordbcloud
```

## Quick Start

```python
from vectordbcloud import VectorDBCloud

# Initialize client
client = VectorDBCloud(api_key="your-api-key")

# AI Services
embeddings = client.ai_embedding(texts=["Hello world"])
genai_response = client.ai_genai(prompt="Generate content")

# Vector Database Operations
client.vectordb_chromadb_create_collection(name="test", dimension=1536)
client.vectordb_chromadb_insert(collection="test", vectors=[...])

# ECP Agent Operations
agent_response = client.ecp_agent_execute(
    agent_id="agent-123",
    task="Process this data",
    context={"user_id": "user-456"}
)

# All 123 endpoints are available with full ECP compliance
```

## ECP Features

- **ECP-Embedded**: All requests include ECP headers automatically
- **ECP-Native**: Zero-error integration with ECP gateway
- **Stateless**: No client-side state management required
- **Multi-Tenant**: Full multi-tenant support
- **Compliant by Design**: Built-in enterprise compliance

## Version 2.0.0

- 100% ECP-compliant implementation
- All 123 endpoints supported
- Enterprise-grade production ready
- <5ms latency guarantee
- >100k concurrent users support

## License

MIT License - see LICENSE file for details.
