"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MyChart = void 0;
const cdk8s_1 = require("cdk8s");
const index_1 = require("./index");
class MyChart extends cdk8s_1.Chart {
    constructor(scope, name) {
        super(scope, name);
        new index_1.AlbIngressController(this, 'AlbIngressController', {
            clusterName: 'TestClusterName',
            args: [
                '--test=123',
            ],
            env: [
                {
                    name: 'testEnv',
                    value: '12345',
                },
            ],
            replicas: 0,
        });
        new index_1.AwsLoadBalancerController(this, 'AwsLoadController', {
            clusterName: 'TestClusterName',
            chartVersion: '1.2.3',
            namespace: 'kube-system',
        });
    }
}
exports.MyChart = MyChart;
const app = new cdk8s_1.App();
new MyChart(app, 'test');
app.synth();
//# sourceMappingURL=data:application/json;base64,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