"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancePolicy = exports.awsLoadBalancerControllerPolicyV2 = exports.awsLoadBalancerControllerPolicyV1 = exports.VersionsLists = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * @stability stable
 */
var VersionsLists;
(function (VersionsLists) {
    VersionsLists["AWS_LOAD_BALANCER_CONTROLLER_POLICY_V1"] = "v1";
    VersionsLists["AWS_LOAD_BALANCER_CONTROLLER_POLICY_V2"] = "v2";
})(VersionsLists = exports.VersionsLists || (exports.VersionsLists = {}));
exports.awsLoadBalancerControllerPolicyV1 = {
    actions: [
        'acm:DescribeCertificate',
        'acm:ListCertificates',
        'acm:GetCertificate',
        'ec2:AuthorizeSecurityGroupIngress',
        'ec2:CreateSecurityGroup',
        'ec2:CreateTags',
        'ec2:DeleteTags',
        'ec2:DeleteSecurityGroup',
        'ec2:DescribeAccountAttributes',
        'ec2:DescribeAddresses',
        'ec2:DescribeInstances',
        'ec2:DescribeInstanceStatus',
        'ec2:DescribeInternetGateways',
        'ec2:DescribeNetworkInterfaces',
        'ec2:DescribeSecurityGroups',
        'ec2:DescribeSubnets',
        'ec2:DescribeTags',
        'ec2:DescribeVpcs',
        'ec2:ModifyInstanceAttribute',
        'ec2:ModifyNetworkInterfaceAttribute',
        'ec2:RevokeSecurityGroupIngress',
        'elasticloadbalancing:AddListenerCertificates',
        'elasticloadbalancing:AddTags',
        'elasticloadbalancing:CreateListener',
        'elasticloadbalancing:CreateLoadBalancer',
        'elasticloadbalancing:CreateRule',
        'elasticloadbalancing:CreateTargetGroup',
        'elasticloadbalancing:DeleteListener',
        'elasticloadbalancing:DeleteLoadBalancer',
        'elasticloadbalancing:DeleteRule',
        'elasticloadbalancing:DeleteTargetGroup',
        'elasticloadbalancing:DeregisterTargets',
        'elasticloadbalancing:DescribeListenerCertificates',
        'elasticloadbalancing:DescribeListeners',
        'elasticloadbalancing:DescribeLoadBalancers',
        'elasticloadbalancing:DescribeLoadBalancerAttributes',
        'elasticloadbalancing:DescribeRules',
        'elasticloadbalancing:DescribeSSLPolicies',
        'elasticloadbalancing:DescribeTags',
        'elasticloadbalancing:DescribeTargetGroups',
        'elasticloadbalancing:DescribeTargetGroupAttributes',
        'elasticloadbalancing:DescribeTargetHealth',
        'elasticloadbalancing:ModifyListener',
        'elasticloadbalancing:ModifyLoadBalancerAttributes',
        'elasticloadbalancing:ModifyRule',
        'elasticloadbalancing:ModifyTargetGroup',
        'elasticloadbalancing:ModifyTargetGroupAttributes',
        'elasticloadbalancing:RegisterTargets',
        'elasticloadbalancing:RemoveListenerCertificates',
        'elasticloadbalancing:RemoveTags',
        'elasticloadbalancing:SetIpAddressType',
        'elasticloadbalancing:SetSecurityGroups',
        'elasticloadbalancing:SetSubnets',
        'elasticloadbalancing:SetWebAcl',
        'iam:CreateServiceLinkedRole',
        'iam:GetServerCertificate',
        'iam:ListServerCertificates',
        'cognito-idp:DescribeUserPoolClient',
        'waf-regional:GetWebACLForResource',
        'waf-regional:GetWebACL',
        'waf-regional:AssociateWebACL',
        'waf-regional:DisassociateWebACL',
        'tag:GetResources',
        'tag:TagResources',
        'waf:GetWebACL',
        'wafv2:GetWebACL',
        'wafv2:GetWebACLForResource',
        'wafv2:AssociateWebACL',
        'wafv2:DisassociateWebACL',
        'shield:DescribeProtection',
        'shield:GetSubscriptionState',
        'shield:DeleteProtection',
        'shield:CreateProtection',
        'shield:DescribeSubscription',
    ],
    resources: ['*'],
};
exports.awsLoadBalancerControllerPolicyV2 = [
    {
        Effect: 'Allow',
        Action: [
            'iam:CreateServiceLinkedRole',
            'ec2:DescribeAccountAttributes',
            'ec2:DescribeAddresses',
            'ec2:DescribeAvailabilityZones',
            'ec2:DescribeInternetGateways',
            'ec2:DescribeVpcs',
            'ec2:DescribeSubnets',
            'ec2:DescribeSecurityGroups',
            'ec2:DescribeInstances',
            'ec2:DescribeNetworkInterfaces',
            'ec2:DescribeTags',
            'ec2:GetCoipPoolUsage',
            'ec2:DescribeCoipPools',
            'elasticloadbalancing:DescribeLoadBalancers',
            'elasticloadbalancing:DescribeLoadBalancerAttributes',
            'elasticloadbalancing:DescribeListeners',
            'elasticloadbalancing:DescribeListenerCertificates',
            'elasticloadbalancing:DescribeSSLPolicies',
            'elasticloadbalancing:DescribeRules',
            'elasticloadbalancing:DescribeTargetGroups',
            'elasticloadbalancing:DescribeTargetGroupAttributes',
            'elasticloadbalancing:DescribeTargetHealth',
            'elasticloadbalancing:DescribeTags',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'cognito-idp:DescribeUserPoolClient',
            'acm:ListCertificates',
            'acm:DescribeCertificate',
            'iam:ListServerCertificates',
            'iam:GetServerCertificate',
            'waf-regional:GetWebACL',
            'waf-regional:GetWebACLForResource',
            'waf-regional:AssociateWebACL',
            'waf-regional:DisassociateWebACL',
            'wafv2:GetWebACL',
            'wafv2:GetWebACLForResource',
            'wafv2:AssociateWebACL',
            'wafv2:DisassociateWebACL',
            'shield:GetSubscriptionState',
            'shield:DescribeProtection',
            'shield:CreateProtection',
            'shield:DeleteProtection',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:AuthorizeSecurityGroupIngress',
            'ec2:RevokeSecurityGroupIngress',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:CreateSecurityGroup',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:CreateTags',
        ],
        Resource: 'arn:aws:ec2:*:*:security-group/*',
        Condition: {
            StringEquals: {
                'ec2:CreateAction': 'CreateSecurityGroup',
            },
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:CreateTags',
            'ec2:DeleteTags',
        ],
        Resource: 'arn:aws:ec2:*:*:security-group/*',
        Condition: {
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'true',
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:AuthorizeSecurityGroupIngress',
            'ec2:RevokeSecurityGroupIngress',
            'ec2:DeleteSecurityGroup',
        ],
        Resource: '*',
        Condition: {
            Null: {
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:CreateLoadBalancer',
            'elasticloadbalancing:CreateTargetGroup',
        ],
        Resource: '*',
        Condition: {
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:CreateListener',
            'elasticloadbalancing:DeleteListener',
            'elasticloadbalancing:CreateRule',
            'elasticloadbalancing:DeleteRule',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:AddTags',
            'elasticloadbalancing:RemoveTags',
        ],
        Resource: [
            'arn:aws:elasticloadbalancing:*:*:targetgroup/*/*',
            'arn:aws:elasticloadbalancing:*:*:loadbalancer/net/*/*',
            'arn:aws:elasticloadbalancing:*:*:loadbalancer/app/*/*',
        ],
        Condition: {
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'true',
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:AddTags',
            'elasticloadbalancing:RemoveTags',
        ],
        Resource: [
            'arn:aws:elasticloadbalancing:*:*:listener/net/*/*/*',
            'arn:aws:elasticloadbalancing:*:*:listener/app/*/*/*',
            'arn:aws:elasticloadbalancing:*:*:listener-rule/net/*/*/*',
            'arn:aws:elasticloadbalancing:*:*:listener-rule/app/*/*/*',
        ],
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:ModifyLoadBalancerAttributes',
            'elasticloadbalancing:SetIpAddressType',
            'elasticloadbalancing:SetSecurityGroups',
            'elasticloadbalancing:SetSubnets',
            'elasticloadbalancing:DeleteLoadBalancer',
            'elasticloadbalancing:ModifyTargetGroup',
            'elasticloadbalancing:ModifyTargetGroupAttributes',
            'elasticloadbalancing:DeleteTargetGroup',
        ],
        Resource: '*',
        Condition: {
            Null: {
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:RegisterTargets',
            'elasticloadbalancing:DeregisterTargets',
        ],
        Resource: 'arn:aws:elasticloadbalancing:*:*:targetgroup/*/*',
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:SetWebAcl',
            'elasticloadbalancing:ModifyListener',
            'elasticloadbalancing:AddListenerCertificates',
            'elasticloadbalancing:RemoveListenerCertificates',
            'elasticloadbalancing:ModifyRule',
        ],
        Resource: '*',
    },
];
/**
 * awsLoadBalancePolicy class ,help you add policy to your Iam Role for service account.
 *
 * @stability stable
 */
class AwsLoadBalancePolicy {
    /**
     * @stability stable
     */
    static addPolicy(version, role) {
        if (version == 'v1') {
            role.addToPrincipalPolicy(new iam.PolicyStatement(exports.awsLoadBalancerControllerPolicyV1));
        }
        else if (version == 'v2') {
            exports.awsLoadBalancerControllerPolicyV2.forEach(element => {
                role.addToPrincipalPolicy(iam.PolicyStatement.fromJson(element));
            });
        }
    }
}
exports.AwsLoadBalancePolicy = AwsLoadBalancePolicy;
_a = JSII_RTTI_SYMBOL_1;
AwsLoadBalancePolicy[_a] = { fqn: "cdk8s-aws-load-balancer-controller.AwsLoadBalancePolicy", version: "2.3.2" };
;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWxiLWNvbnRyb2xsZXItcG9saWN5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2FsYi1jb250cm9sbGVyLXBvbGljeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLHdDQUF3Qzs7OztBQUN4QyxJQUFZLGFBS1g7QUFMRCxXQUFZLGFBQWE7SUFFdkIsOERBQTZDLENBQUE7SUFFN0MsOERBQTZDLENBQUE7QUFDL0MsQ0FBQyxFQUxXLGFBQWEsR0FBYixxQkFBYSxLQUFiLHFCQUFhLFFBS3hCO0FBQ1ksUUFBQSxpQ0FBaUMsR0FBRztJQUMvQyxPQUFPLEVBQUU7UUFDUCx5QkFBeUI7UUFDekIsc0JBQXNCO1FBQ3RCLG9CQUFvQjtRQUNwQixtQ0FBbUM7UUFDbkMseUJBQXlCO1FBQ3pCLGdCQUFnQjtRQUNoQixnQkFBZ0I7UUFDaEIseUJBQXlCO1FBQ3pCLCtCQUErQjtRQUMvQix1QkFBdUI7UUFDdkIsdUJBQXVCO1FBQ3ZCLDRCQUE0QjtRQUM1Qiw4QkFBOEI7UUFDOUIsK0JBQStCO1FBQy9CLDRCQUE0QjtRQUM1QixxQkFBcUI7UUFDckIsa0JBQWtCO1FBQ2xCLGtCQUFrQjtRQUNsQiw2QkFBNkI7UUFDN0IscUNBQXFDO1FBQ3JDLGdDQUFnQztRQUNoQyw4Q0FBOEM7UUFDOUMsOEJBQThCO1FBQzlCLHFDQUFxQztRQUNyQyx5Q0FBeUM7UUFDekMsaUNBQWlDO1FBQ2pDLHdDQUF3QztRQUN4QyxxQ0FBcUM7UUFDckMseUNBQXlDO1FBQ3pDLGlDQUFpQztRQUNqQyx3Q0FBd0M7UUFDeEMsd0NBQXdDO1FBQ3hDLG1EQUFtRDtRQUNuRCx3Q0FBd0M7UUFDeEMsNENBQTRDO1FBQzVDLHFEQUFxRDtRQUNyRCxvQ0FBb0M7UUFDcEMsMENBQTBDO1FBQzFDLG1DQUFtQztRQUNuQywyQ0FBMkM7UUFDM0Msb0RBQW9EO1FBQ3BELDJDQUEyQztRQUMzQyxxQ0FBcUM7UUFDckMsbURBQW1EO1FBQ25ELGlDQUFpQztRQUNqQyx3Q0FBd0M7UUFDeEMsa0RBQWtEO1FBQ2xELHNDQUFzQztRQUN0QyxpREFBaUQ7UUFDakQsaUNBQWlDO1FBQ2pDLHVDQUF1QztRQUN2Qyx3Q0FBd0M7UUFDeEMsaUNBQWlDO1FBQ2pDLGdDQUFnQztRQUNoQyw2QkFBNkI7UUFDN0IsMEJBQTBCO1FBQzFCLDRCQUE0QjtRQUM1QixvQ0FBb0M7UUFDcEMsbUNBQW1DO1FBQ25DLHdCQUF3QjtRQUN4Qiw4QkFBOEI7UUFDOUIsaUNBQWlDO1FBQ2pDLGtCQUFrQjtRQUNsQixrQkFBa0I7UUFDbEIsZUFBZTtRQUNmLGlCQUFpQjtRQUNqQiw0QkFBNEI7UUFDNUIsdUJBQXVCO1FBQ3ZCLDBCQUEwQjtRQUMxQiwyQkFBMkI7UUFDM0IsNkJBQTZCO1FBQzdCLHlCQUF5QjtRQUN6Qix5QkFBeUI7UUFDekIsNkJBQTZCO0tBQzlCO0lBQ0QsU0FBUyxFQUFFLENBQUMsR0FBRyxDQUFDO0NBQ2pCLENBQUM7QUFHVyxRQUFBLGlDQUFpQyxHQUFHO0lBQy9DO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTiw2QkFBNkI7WUFDN0IsK0JBQStCO1lBQy9CLHVCQUF1QjtZQUN2QiwrQkFBK0I7WUFDL0IsOEJBQThCO1lBQzlCLGtCQUFrQjtZQUNsQixxQkFBcUI7WUFDckIsNEJBQTRCO1lBQzVCLHVCQUF1QjtZQUN2QiwrQkFBK0I7WUFDL0Isa0JBQWtCO1lBQ2xCLHNCQUFzQjtZQUN0Qix1QkFBdUI7WUFDdkIsNENBQTRDO1lBQzVDLHFEQUFxRDtZQUNyRCx3Q0FBd0M7WUFDeEMsbURBQW1EO1lBQ25ELDBDQUEwQztZQUMxQyxvQ0FBb0M7WUFDcEMsMkNBQTJDO1lBQzNDLG9EQUFvRDtZQUNwRCwyQ0FBMkM7WUFDM0MsbUNBQW1DO1NBQ3BDO1FBQ0QsUUFBUSxFQUFFLEdBQUc7S0FDZDtJQUNEO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTixvQ0FBb0M7WUFDcEMsc0JBQXNCO1lBQ3RCLHlCQUF5QjtZQUN6Qiw0QkFBNEI7WUFDNUIsMEJBQTBCO1lBQzFCLHdCQUF3QjtZQUN4QixtQ0FBbUM7WUFDbkMsOEJBQThCO1lBQzlCLGlDQUFpQztZQUNqQyxpQkFBaUI7WUFDakIsNEJBQTRCO1lBQzVCLHVCQUF1QjtZQUN2QiwwQkFBMEI7WUFDMUIsNkJBQTZCO1lBQzdCLDJCQUEyQjtZQUMzQix5QkFBeUI7WUFDekIseUJBQXlCO1NBQzFCO1FBQ0QsUUFBUSxFQUFFLEdBQUc7S0FDZDtJQUNEO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTixtQ0FBbUM7WUFDbkMsZ0NBQWdDO1NBQ2pDO1FBQ0QsUUFBUSxFQUFFLEdBQUc7S0FDZDtJQUNEO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTix5QkFBeUI7U0FDMUI7UUFDRCxRQUFRLEVBQUUsR0FBRztLQUNkO0lBQ0Q7UUFDRSxNQUFNLEVBQUUsT0FBTztRQUNmLE1BQU0sRUFBRTtZQUNOLGdCQUFnQjtTQUNqQjtRQUNELFFBQVEsRUFBRSxrQ0FBa0M7UUFDNUMsU0FBUyxFQUFFO1lBQ1QsWUFBWSxFQUFFO2dCQUNaLGtCQUFrQixFQUFFLHFCQUFxQjthQUMxQztZQUNELElBQUksRUFBRTtnQkFDSixzQ0FBc0MsRUFBRSxPQUFPO2FBQ2hEO1NBQ0Y7S0FDRjtJQUNEO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTixnQkFBZ0I7WUFDaEIsZ0JBQWdCO1NBQ2pCO1FBQ0QsUUFBUSxFQUFFLGtDQUFrQztRQUM1QyxTQUFTLEVBQUU7WUFDVCxJQUFJLEVBQUU7Z0JBQ0osc0NBQXNDLEVBQUUsTUFBTTtnQkFDOUMsdUNBQXVDLEVBQUUsT0FBTzthQUNqRDtTQUNGO0tBQ0Y7SUFDRDtRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04sbUNBQW1DO1lBQ25DLGdDQUFnQztZQUNoQyx5QkFBeUI7U0FDMUI7UUFDRCxRQUFRLEVBQUUsR0FBRztRQUNiLFNBQVMsRUFBRTtZQUNULElBQUksRUFBRTtnQkFDSix1Q0FBdUMsRUFBRSxPQUFPO2FBQ2pEO1NBQ0Y7S0FDRjtJQUNEO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTix5Q0FBeUM7WUFDekMsd0NBQXdDO1NBQ3pDO1FBQ0QsUUFBUSxFQUFFLEdBQUc7UUFDYixTQUFTLEVBQUU7WUFDVCxJQUFJLEVBQUU7Z0JBQ0osc0NBQXNDLEVBQUUsT0FBTzthQUNoRDtTQUNGO0tBQ0Y7SUFDRDtRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04scUNBQXFDO1lBQ3JDLHFDQUFxQztZQUNyQyxpQ0FBaUM7WUFDakMsaUNBQWlDO1NBQ2xDO1FBQ0QsUUFBUSxFQUFFLEdBQUc7S0FDZDtJQUNEO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTiw4QkFBOEI7WUFDOUIsaUNBQWlDO1NBQ2xDO1FBQ0QsUUFBUSxFQUFFO1lBQ1Isa0RBQWtEO1lBQ2xELHVEQUF1RDtZQUN2RCx1REFBdUQ7U0FDeEQ7UUFDRCxTQUFTLEVBQUU7WUFDVCxJQUFJLEVBQUU7Z0JBQ0osc0NBQXNDLEVBQUUsTUFBTTtnQkFDOUMsdUNBQXVDLEVBQUUsT0FBTzthQUNqRDtTQUNGO0tBQ0Y7SUFDRDtRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04sOEJBQThCO1lBQzlCLGlDQUFpQztTQUNsQztRQUNELFFBQVEsRUFBRTtZQUNSLHFEQUFxRDtZQUNyRCxxREFBcUQ7WUFDckQsMERBQTBEO1lBQzFELDBEQUEwRDtTQUMzRDtLQUNGO0lBQ0Q7UUFDRSxNQUFNLEVBQUUsT0FBTztRQUNmLE1BQU0sRUFBRTtZQUNOLG1EQUFtRDtZQUNuRCx1Q0FBdUM7WUFDdkMsd0NBQXdDO1lBQ3hDLGlDQUFpQztZQUNqQyx5Q0FBeUM7WUFDekMsd0NBQXdDO1lBQ3hDLGtEQUFrRDtZQUNsRCx3Q0FBd0M7U0FDekM7UUFDRCxRQUFRLEVBQUUsR0FBRztRQUNiLFNBQVMsRUFBRTtZQUNULElBQUksRUFBRTtnQkFDSix1Q0FBdUMsRUFBRSxPQUFPO2FBQ2pEO1NBQ0Y7S0FDRjtJQUNEO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTixzQ0FBc0M7WUFDdEMsd0NBQXdDO1NBQ3pDO1FBQ0QsUUFBUSxFQUFFLGtEQUFrRDtLQUM3RDtJQUNEO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTixnQ0FBZ0M7WUFDaEMscUNBQXFDO1lBQ3JDLDhDQUE4QztZQUM5QyxpREFBaUQ7WUFDakQsaUNBQWlDO1NBQ2xDO1FBQ0QsUUFBUSxFQUFFLEdBQUc7S0FDZDtDQUNGLENBQUM7Ozs7OztBQUdGLE1BQWEsb0JBQW9COzs7O0lBQ3hCLE1BQU0sQ0FBQyxTQUFTLENBQUMsT0FBZSxFQUFFLElBQVM7UUFDaEQsSUFBSSxPQUFPLElBQUksSUFBSSxFQUFFO1lBQ25CLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUUseUNBQWlDLENBQUUsQ0FBQyxDQUFDO1NBQ3pGO2FBQU0sSUFBSSxPQUFPLElBQUksSUFBSSxFQUFFO1lBQzFCLHlDQUFpQyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsRUFBRTtnQkFDbEQsSUFBSSxDQUFDLG9CQUFvQixDQUFDLEdBQUcsQ0FBQyxlQUFlLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7WUFDbkUsQ0FBQyxDQUFDLENBQUM7U0FDSjtJQUNILENBQUM7O0FBVEgsb0RBVUM7OztBQUFBLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5leHBvcnQgZW51bSBWZXJzaW9uc0xpc3RzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgQVdTX0xPQURfQkFMQU5DRVJfQ09OVFJPTExFUl9QT0xJQ1lfVjEgPSAndjEnLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFXU19MT0FEX0JBTEFOQ0VSX0NPTlRST0xMRVJfUE9MSUNZX1YyID0gJ3YyJyxcbn1cbmV4cG9ydCBjb25zdCBhd3NMb2FkQmFsYW5jZXJDb250cm9sbGVyUG9saWN5VjEgPSB7XG4gIGFjdGlvbnM6IFtcbiAgICAnYWNtOkRlc2NyaWJlQ2VydGlmaWNhdGUnLFxuICAgICdhY206TGlzdENlcnRpZmljYXRlcycsXG4gICAgJ2FjbTpHZXRDZXJ0aWZpY2F0ZScsXG4gICAgJ2VjMjpBdXRob3JpemVTZWN1cml0eUdyb3VwSW5ncmVzcycsXG4gICAgJ2VjMjpDcmVhdGVTZWN1cml0eUdyb3VwJyxcbiAgICAnZWMyOkNyZWF0ZVRhZ3MnLFxuICAgICdlYzI6RGVsZXRlVGFncycsXG4gICAgJ2VjMjpEZWxldGVTZWN1cml0eUdyb3VwJyxcbiAgICAnZWMyOkRlc2NyaWJlQWNjb3VudEF0dHJpYnV0ZXMnLFxuICAgICdlYzI6RGVzY3JpYmVBZGRyZXNzZXMnLFxuICAgICdlYzI6RGVzY3JpYmVJbnN0YW5jZXMnLFxuICAgICdlYzI6RGVzY3JpYmVJbnN0YW5jZVN0YXR1cycsXG4gICAgJ2VjMjpEZXNjcmliZUludGVybmV0R2F0ZXdheXMnLFxuICAgICdlYzI6RGVzY3JpYmVOZXR3b3JrSW50ZXJmYWNlcycsXG4gICAgJ2VjMjpEZXNjcmliZVNlY3VyaXR5R3JvdXBzJyxcbiAgICAnZWMyOkRlc2NyaWJlU3VibmV0cycsXG4gICAgJ2VjMjpEZXNjcmliZVRhZ3MnLFxuICAgICdlYzI6RGVzY3JpYmVWcGNzJyxcbiAgICAnZWMyOk1vZGlmeUluc3RhbmNlQXR0cmlidXRlJyxcbiAgICAnZWMyOk1vZGlmeU5ldHdvcmtJbnRlcmZhY2VBdHRyaWJ1dGUnLFxuICAgICdlYzI6UmV2b2tlU2VjdXJpdHlHcm91cEluZ3Jlc3MnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpBZGRMaXN0ZW5lckNlcnRpZmljYXRlcycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkFkZFRhZ3MnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpDcmVhdGVMaXN0ZW5lcicsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkNyZWF0ZUxvYWRCYWxhbmNlcicsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkNyZWF0ZVJ1bGUnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpDcmVhdGVUYXJnZXRHcm91cCcsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlbGV0ZUxpc3RlbmVyJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVsZXRlTG9hZEJhbGFuY2VyJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVsZXRlUnVsZScsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlbGV0ZVRhcmdldEdyb3VwJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVyZWdpc3RlclRhcmdldHMnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZUxpc3RlbmVyQ2VydGlmaWNhdGVzJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVMaXN0ZW5lcnMnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZUxvYWRCYWxhbmNlcnMnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZUxvYWRCYWxhbmNlckF0dHJpYnV0ZXMnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZVJ1bGVzJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVTU0xQb2xpY2llcycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlc2NyaWJlVGFncycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlc2NyaWJlVGFyZ2V0R3JvdXBzJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVUYXJnZXRHcm91cEF0dHJpYnV0ZXMnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZVRhcmdldEhlYWx0aCcsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOk1vZGlmeUxpc3RlbmVyJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6TW9kaWZ5TG9hZEJhbGFuY2VyQXR0cmlidXRlcycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOk1vZGlmeVJ1bGUnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpNb2RpZnlUYXJnZXRHcm91cCcsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOk1vZGlmeVRhcmdldEdyb3VwQXR0cmlidXRlcycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlJlZ2lzdGVyVGFyZ2V0cycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlJlbW92ZUxpc3RlbmVyQ2VydGlmaWNhdGVzJyxcbiAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6UmVtb3ZlVGFncycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlNldElwQWRkcmVzc1R5cGUnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpTZXRTZWN1cml0eUdyb3VwcycsXG4gICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlNldFN1Ym5ldHMnLFxuICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpTZXRXZWJBY2wnLFxuICAgICdpYW06Q3JlYXRlU2VydmljZUxpbmtlZFJvbGUnLFxuICAgICdpYW06R2V0U2VydmVyQ2VydGlmaWNhdGUnLFxuICAgICdpYW06TGlzdFNlcnZlckNlcnRpZmljYXRlcycsXG4gICAgJ2NvZ25pdG8taWRwOkRlc2NyaWJlVXNlclBvb2xDbGllbnQnLFxuICAgICd3YWYtcmVnaW9uYWw6R2V0V2ViQUNMRm9yUmVzb3VyY2UnLFxuICAgICd3YWYtcmVnaW9uYWw6R2V0V2ViQUNMJyxcbiAgICAnd2FmLXJlZ2lvbmFsOkFzc29jaWF0ZVdlYkFDTCcsXG4gICAgJ3dhZi1yZWdpb25hbDpEaXNhc3NvY2lhdGVXZWJBQ0wnLFxuICAgICd0YWc6R2V0UmVzb3VyY2VzJyxcbiAgICAndGFnOlRhZ1Jlc291cmNlcycsXG4gICAgJ3dhZjpHZXRXZWJBQ0wnLFxuICAgICd3YWZ2MjpHZXRXZWJBQ0wnLFxuICAgICd3YWZ2MjpHZXRXZWJBQ0xGb3JSZXNvdXJjZScsXG4gICAgJ3dhZnYyOkFzc29jaWF0ZVdlYkFDTCcsXG4gICAgJ3dhZnYyOkRpc2Fzc29jaWF0ZVdlYkFDTCcsXG4gICAgJ3NoaWVsZDpEZXNjcmliZVByb3RlY3Rpb24nLFxuICAgICdzaGllbGQ6R2V0U3Vic2NyaXB0aW9uU3RhdGUnLFxuICAgICdzaGllbGQ6RGVsZXRlUHJvdGVjdGlvbicsXG4gICAgJ3NoaWVsZDpDcmVhdGVQcm90ZWN0aW9uJyxcbiAgICAnc2hpZWxkOkRlc2NyaWJlU3Vic2NyaXB0aW9uJyxcbiAgXSxcbiAgcmVzb3VyY2VzOiBbJyonXSxcbn07XG5cblxuZXhwb3J0IGNvbnN0IGF3c0xvYWRCYWxhbmNlckNvbnRyb2xsZXJQb2xpY3lWMiA9IFtcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdpYW06Q3JlYXRlU2VydmljZUxpbmtlZFJvbGUnLFxuICAgICAgJ2VjMjpEZXNjcmliZUFjY291bnRBdHRyaWJ1dGVzJyxcbiAgICAgICdlYzI6RGVzY3JpYmVBZGRyZXNzZXMnLFxuICAgICAgJ2VjMjpEZXNjcmliZUF2YWlsYWJpbGl0eVpvbmVzJyxcbiAgICAgICdlYzI6RGVzY3JpYmVJbnRlcm5ldEdhdGV3YXlzJyxcbiAgICAgICdlYzI6RGVzY3JpYmVWcGNzJyxcbiAgICAgICdlYzI6RGVzY3JpYmVTdWJuZXRzJyxcbiAgICAgICdlYzI6RGVzY3JpYmVTZWN1cml0eUdyb3VwcycsXG4gICAgICAnZWMyOkRlc2NyaWJlSW5zdGFuY2VzJyxcbiAgICAgICdlYzI6RGVzY3JpYmVOZXR3b3JrSW50ZXJmYWNlcycsXG4gICAgICAnZWMyOkRlc2NyaWJlVGFncycsXG4gICAgICAnZWMyOkdldENvaXBQb29sVXNhZ2UnLFxuICAgICAgJ2VjMjpEZXNjcmliZUNvaXBQb29scycsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVMb2FkQmFsYW5jZXJzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZUxvYWRCYWxhbmNlckF0dHJpYnV0ZXMnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlc2NyaWJlTGlzdGVuZXJzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZUxpc3RlbmVyQ2VydGlmaWNhdGVzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZVNTTFBvbGljaWVzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZVJ1bGVzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZVRhcmdldEdyb3VwcycsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVUYXJnZXRHcm91cEF0dHJpYnV0ZXMnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlc2NyaWJlVGFyZ2V0SGVhbHRoJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZVRhZ3MnLFxuICAgIF0sXG4gICAgUmVzb3VyY2U6ICcqJyxcbiAgfSxcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdjb2duaXRvLWlkcDpEZXNjcmliZVVzZXJQb29sQ2xpZW50JyxcbiAgICAgICdhY206TGlzdENlcnRpZmljYXRlcycsXG4gICAgICAnYWNtOkRlc2NyaWJlQ2VydGlmaWNhdGUnLFxuICAgICAgJ2lhbTpMaXN0U2VydmVyQ2VydGlmaWNhdGVzJyxcbiAgICAgICdpYW06R2V0U2VydmVyQ2VydGlmaWNhdGUnLFxuICAgICAgJ3dhZi1yZWdpb25hbDpHZXRXZWJBQ0wnLFxuICAgICAgJ3dhZi1yZWdpb25hbDpHZXRXZWJBQ0xGb3JSZXNvdXJjZScsXG4gICAgICAnd2FmLXJlZ2lvbmFsOkFzc29jaWF0ZVdlYkFDTCcsXG4gICAgICAnd2FmLXJlZ2lvbmFsOkRpc2Fzc29jaWF0ZVdlYkFDTCcsXG4gICAgICAnd2FmdjI6R2V0V2ViQUNMJyxcbiAgICAgICd3YWZ2MjpHZXRXZWJBQ0xGb3JSZXNvdXJjZScsXG4gICAgICAnd2FmdjI6QXNzb2NpYXRlV2ViQUNMJyxcbiAgICAgICd3YWZ2MjpEaXNhc3NvY2lhdGVXZWJBQ0wnLFxuICAgICAgJ3NoaWVsZDpHZXRTdWJzY3JpcHRpb25TdGF0ZScsXG4gICAgICAnc2hpZWxkOkRlc2NyaWJlUHJvdGVjdGlvbicsXG4gICAgICAnc2hpZWxkOkNyZWF0ZVByb3RlY3Rpb24nLFxuICAgICAgJ3NoaWVsZDpEZWxldGVQcm90ZWN0aW9uJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnKicsXG4gIH0sXG4gIHtcbiAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgQWN0aW9uOiBbXG4gICAgICAnZWMyOkF1dGhvcml6ZVNlY3VyaXR5R3JvdXBJbmdyZXNzJyxcbiAgICAgICdlYzI6UmV2b2tlU2VjdXJpdHlHcm91cEluZ3Jlc3MnLFxuICAgIF0sXG4gICAgUmVzb3VyY2U6ICcqJyxcbiAgfSxcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdlYzI6Q3JlYXRlU2VjdXJpdHlHcm91cCcsXG4gICAgXSxcbiAgICBSZXNvdXJjZTogJyonLFxuICB9LFxuICB7XG4gICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgIEFjdGlvbjogW1xuICAgICAgJ2VjMjpDcmVhdGVUYWdzJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnYXJuOmF3czplYzI6KjoqOnNlY3VyaXR5LWdyb3VwLyonLFxuICAgIENvbmRpdGlvbjoge1xuICAgICAgU3RyaW5nRXF1YWxzOiB7XG4gICAgICAgICdlYzI6Q3JlYXRlQWN0aW9uJzogJ0NyZWF0ZVNlY3VyaXR5R3JvdXAnLFxuICAgICAgfSxcbiAgICAgIE51bGw6IHtcbiAgICAgICAgJ2F3czpSZXF1ZXN0VGFnL2VsYnYyLms4cy5hd3MvY2x1c3Rlcic6ICdmYWxzZScsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG4gIHtcbiAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgQWN0aW9uOiBbXG4gICAgICAnZWMyOkNyZWF0ZVRhZ3MnLFxuICAgICAgJ2VjMjpEZWxldGVUYWdzJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnYXJuOmF3czplYzI6KjoqOnNlY3VyaXR5LWdyb3VwLyonLFxuICAgIENvbmRpdGlvbjoge1xuICAgICAgTnVsbDoge1xuICAgICAgICAnYXdzOlJlcXVlc3RUYWcvZWxidjIuazhzLmF3cy9jbHVzdGVyJzogJ3RydWUnLFxuICAgICAgICAnYXdzOlJlc291cmNlVGFnL2VsYnYyLms4cy5hd3MvY2x1c3Rlcic6ICdmYWxzZScsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG4gIHtcbiAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgQWN0aW9uOiBbXG4gICAgICAnZWMyOkF1dGhvcml6ZVNlY3VyaXR5R3JvdXBJbmdyZXNzJyxcbiAgICAgICdlYzI6UmV2b2tlU2VjdXJpdHlHcm91cEluZ3Jlc3MnLFxuICAgICAgJ2VjMjpEZWxldGVTZWN1cml0eUdyb3VwJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnKicsXG4gICAgQ29uZGl0aW9uOiB7XG4gICAgICBOdWxsOiB7XG4gICAgICAgICdhd3M6UmVzb3VyY2VUYWcvZWxidjIuazhzLmF3cy9jbHVzdGVyJzogJ2ZhbHNlJyxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpDcmVhdGVMb2FkQmFsYW5jZXInLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkNyZWF0ZVRhcmdldEdyb3VwJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnKicsXG4gICAgQ29uZGl0aW9uOiB7XG4gICAgICBOdWxsOiB7XG4gICAgICAgICdhd3M6UmVxdWVzdFRhZy9lbGJ2Mi5rOHMuYXdzL2NsdXN0ZXInOiAnZmFsc2UnLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxuICB7XG4gICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgIEFjdGlvbjogW1xuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkNyZWF0ZUxpc3RlbmVyJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZWxldGVMaXN0ZW5lcicsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6Q3JlYXRlUnVsZScsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVsZXRlUnVsZScsXG4gICAgXSxcbiAgICBSZXNvdXJjZTogJyonLFxuICB9LFxuICB7XG4gICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgIEFjdGlvbjogW1xuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkFkZFRhZ3MnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlJlbW92ZVRhZ3MnLFxuICAgIF0sXG4gICAgUmVzb3VyY2U6IFtcbiAgICAgICdhcm46YXdzOmVsYXN0aWNsb2FkYmFsYW5jaW5nOio6Kjp0YXJnZXRncm91cC8qLyonLFxuICAgICAgJ2Fybjphd3M6ZWxhc3RpY2xvYWRiYWxhbmNpbmc6KjoqOmxvYWRiYWxhbmNlci9uZXQvKi8qJyxcbiAgICAgICdhcm46YXdzOmVsYXN0aWNsb2FkYmFsYW5jaW5nOio6Kjpsb2FkYmFsYW5jZXIvYXBwLyovKicsXG4gICAgXSxcbiAgICBDb25kaXRpb246IHtcbiAgICAgIE51bGw6IHtcbiAgICAgICAgJ2F3czpSZXF1ZXN0VGFnL2VsYnYyLms4cy5hd3MvY2x1c3Rlcic6ICd0cnVlJyxcbiAgICAgICAgJ2F3czpSZXNvdXJjZVRhZy9lbGJ2Mi5rOHMuYXdzL2NsdXN0ZXInOiAnZmFsc2UnLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxuICB7XG4gICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgIEFjdGlvbjogW1xuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkFkZFRhZ3MnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlJlbW92ZVRhZ3MnLFxuICAgIF0sXG4gICAgUmVzb3VyY2U6IFtcbiAgICAgICdhcm46YXdzOmVsYXN0aWNsb2FkYmFsYW5jaW5nOio6KjpsaXN0ZW5lci9uZXQvKi8qLyonLFxuICAgICAgJ2Fybjphd3M6ZWxhc3RpY2xvYWRiYWxhbmNpbmc6KjoqOmxpc3RlbmVyL2FwcC8qLyovKicsXG4gICAgICAnYXJuOmF3czplbGFzdGljbG9hZGJhbGFuY2luZzoqOio6bGlzdGVuZXItcnVsZS9uZXQvKi8qLyonLFxuICAgICAgJ2Fybjphd3M6ZWxhc3RpY2xvYWRiYWxhbmNpbmc6KjoqOmxpc3RlbmVyLXJ1bGUvYXBwLyovKi8qJyxcbiAgICBdLFxuICB9LFxuICB7XG4gICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgIEFjdGlvbjogW1xuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOk1vZGlmeUxvYWRCYWxhbmNlckF0dHJpYnV0ZXMnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlNldElwQWRkcmVzc1R5cGUnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlNldFNlY3VyaXR5R3JvdXBzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpTZXRTdWJuZXRzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZWxldGVMb2FkQmFsYW5jZXInLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOk1vZGlmeVRhcmdldEdyb3VwJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpNb2RpZnlUYXJnZXRHcm91cEF0dHJpYnV0ZXMnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlbGV0ZVRhcmdldEdyb3VwJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnKicsXG4gICAgQ29uZGl0aW9uOiB7XG4gICAgICBOdWxsOiB7XG4gICAgICAgICdhd3M6UmVzb3VyY2VUYWcvZWxidjIuazhzLmF3cy9jbHVzdGVyJzogJ2ZhbHNlJyxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpSZWdpc3RlclRhcmdldHMnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlcmVnaXN0ZXJUYXJnZXRzJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnYXJuOmF3czplbGFzdGljbG9hZGJhbGFuY2luZzoqOio6dGFyZ2V0Z3JvdXAvKi8qJyxcbiAgfSxcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpTZXRXZWJBY2wnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOk1vZGlmeUxpc3RlbmVyJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpBZGRMaXN0ZW5lckNlcnRpZmljYXRlcycsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6UmVtb3ZlTGlzdGVuZXJDZXJ0aWZpY2F0ZXMnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOk1vZGlmeVJ1bGUnLFxuICAgIF0sXG4gICAgUmVzb3VyY2U6ICcqJyxcbiAgfSxcbl07XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEF3c0xvYWRCYWxhbmNlUG9saWN5IHtcbiAgcHVibGljIHN0YXRpYyBhZGRQb2xpY3kodmVyc2lvbjogc3RyaW5nLCByb2xlOiBhbnkpIDp2b2lkIHtcbiAgICBpZiAodmVyc2lvbiA9PSAndjEnKSB7XG4gICAgICByb2xlLmFkZFRvUHJpbmNpcGFsUG9saWN5KG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KCBhd3NMb2FkQmFsYW5jZXJDb250cm9sbGVyUG9saWN5VjEgKSk7XG4gICAgfSBlbHNlIGlmICh2ZXJzaW9uID09ICd2MicpIHtcbiAgICAgIGF3c0xvYWRCYWxhbmNlckNvbnRyb2xsZXJQb2xpY3lWMi5mb3JFYWNoKGVsZW1lbnQgPT4ge1xuICAgICAgICByb2xlLmFkZFRvUHJpbmNpcGFsUG9saWN5KGlhbS5Qb2xpY3lTdGF0ZW1lbnQuZnJvbUpzb24oZWxlbWVudCkpO1xuICAgICAgfSk7XG4gICAgfVxuICB9XG59OyJdfQ==