/*
 * Decompiled with CFR 0.152.
 */
package preprocessing;

import bridge.ContractInstanceInSDC;
import bridge.Method;
import bridge.SingleDeployedContract;
import bridge.SourceLanguage;
import bridge.SourceTypeDescription;
import bridge.StorageLayout;
import bridge.VerificationQuery;
import cli.ConverterKt;
import config.Config;
import disassembler.DisassembledEVMBytecode;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ConsoleKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.modules.SerializersModule;
import log.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import preprocessing.ProverInputPreprocessor;
import scene.ContractClassIdentifiers;
import scene.ContractUniverse;
import scene.ContractWithStateLinkInfo;
import scene.IContractClass;
import scene.IContractLoader;
import scene.IContractSource;
import scene.IContractWithSource;
import scene.IPerContractClassCache;
import scene.IScene;
import scene.ITACMethod;
import scene.MethodAttribute;
import scene.TrivialSceneFactory;
import spec.CVL;
import spec.CVLAstBuilder;
import spec.CVLInput;
import spec.StandardCVLErrorLogger;
import spec.cvlast.CVLAst;
import spec.cvlast.CVLInvariant;
import spec.cvlast.CVLRuleChoiceKt;
import spec.cvlast.ContractFunction;
import spec.cvlast.IRule;
import spec.cvlast.SolidityContract;
import tac.DummyStorageInfo;
import tac.ICoreTACProgram;
import tac.IStorageInfo;
import tac.ITACSymbol;
import tac.TACStorageLayout;
import utils.CVLSerializerModules;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\nH\u0007J\u001b\u0010\u0012\u001a\u00020\u00132\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u0019\u001a\u00020\u0007J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\r2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007\u00a8\u0006\u001f"}, d2={"Lpreprocessing/ProverInputPreprocessor;", "", "()V", "_main", "", "args", "", "", "astCb", "Lkotlin/Function1;", "Lspec/cvlast/CVLAst;", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getCertoraVerifyFile", "", "Lbridge/VerificationQuery;", "filepath", "outForLSPServer", "ast", "parseInputFileNames", "Lpreprocessing/ProverInputPreprocessor$InputFileNames;", "([Ljava/lang/String;)Lpreprocessing/ProverInputPreprocessor$InputFileNames;", "setConfigFromMetadata", "metadataElem", "Lkotlinx/serialization/json/JsonObject;", "withSpec", "verifyFile", "withSpecAndContractBuildInformation", "Lspec/CVL;", "buildFile", "BasicContractSource", "InputFileNames", "Shared"})
public final class ProverInputPreprocessor {
    @NotNull
    public static final ProverInputPreprocessor INSTANCE = new ProverInputPreprocessor();

    private ProverInputPreprocessor() {
    }

    private final List<VerificationQuery> getCertoraVerifyFile(String filepath) {
        String it = FilesKt.readText$default(new File(filepath), null, 1, null);
        boolean bl = false;
        return (List)JsonKt.Json$default(null, getCertoraVerifyFile.1.1.INSTANCE, 1, null).decodeFromString(BuiltinSerializersKt.ListSerializer(VerificationQuery.Companion.serializer()), it);
    }

    private final void setConfigFromMetadata(JsonObject metadataElem) {
        String string2 = ProverInputPreprocessor.setConfigFromMetadata$getRulesFromMetadata(metadataElem);
        if (string2 == null) {
            return;
        }
        String rules2 = string2;
        Config.INSTANCE.getRuleChoice().set((Serializable)ConverterKt.getStringSetConverter().getConvert().invoke(rules2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CVL> withSpecAndContractBuildInformation(@NotNull String buildFile, @NotNull String verifyFile) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(buildFile, "buildFile");
        Intrinsics.checkNotNullParameter(verifyFile, "verifyFile");
        List<VerificationQuery> verify2 = this.getCertoraVerifyFile(verifyFile);
        BasicContractSource contractSource = new BasicContractSource(buildFile);
        IScene scene = TrivialSceneFactory.INSTANCE.getScene(contractSource);
        Iterable $this$map$iv = verify2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void v;
            VerificationQuery verificationQuery = (VerificationQuery)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            System.out.println((Object)("Type checking " + v.getPrimary_contract()));
            List<ContractInstanceInSDC> list = contractSource.instances();
            CVLInput cVLInput = v.toCVLInput();
            ContractInstanceInSDC contractInstanceInSDC = ((IContractWithSource)((Object)scene.getContract(new SolidityContract.Named(v.getPrimary_contract())))).getSrc();
            Iterable $this$map$iv2 = contractSource.instances();
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void sdc;
                ContractInstanceInSDC contractInstanceInSDC2 = (ContractInstanceInSDC)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                Iterable iterable3 = sdc.getMethodsAndConstructor();
                void var29_29 = sdc;
                boolean $i$f$mapNotNull = false;
                void var31_31 = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    ContractFunction it$iv$iv;
                    ContractFunction contractFunction;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    Method it = (Method)element$iv$iv;
                    boolean bl4 = false;
                    try {
                        contractFunction = it.toCVLImportedFunction(new SolidityContract.Named(sdc.getName()));
                    }
                    catch (Exception e) {
                        Logger.Companion.alwaysError("Failed to import function " + it + " in contract " + sdc.getName() + ": " + e.getMessage());
                        contractFunction = null;
                    }
                    if (contractFunction == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                collection2.add(TuplesKt.to(var29_29, (List)destination$iv$iv3));
            }
            Map map2 = MapsKt.toMap((List)destination$iv$iv2);
            collection.add(new CVLAstBuilder(cVLInput, map2, list, contractInstanceInSDC, scene, null, null, 64, null).build());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CVLAst> withSpec(@NotNull String verifyFile) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(verifyFile, "verifyFile");
        List<VerificationQuery> verify2 = this.getCertoraVerifyFile(verifyFile);
        Iterable $this$map$iv = verify2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void v;
            VerificationQuery verificationQuery = (VerificationQuery)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(v.toCVLInput().getRawCVLAst());
        }
        List cvlAstList = (List)destination$iv$iv;
        Iterable $this$forEach$iv = cvlAstList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CVLInvariant it;
            Set set;
            Iterable $this$mapTo$iv$iv2;
            CVLAst cvlAst = (CVLAst)element$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = cvlAst.getRules();
            boolean $i$f$map2 = false;
            Iterable bl2 = $this$map$iv2;
            Collection<Object> destination$iv$iv2 = (Set)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10)));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                IRule iRule = (IRule)item$iv$iv;
                set = destination$iv$iv2;
                boolean bl3 = false;
                set.add(((IRule)((Object)it)).getDeclarationId());
            }
            $this$map$iv2 = cvlAst.getInvs();
            set = CollectionsKt.toSet((List)destination$iv$iv2);
            $i$f$map2 = false;
            $this$mapTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (CVLInvariant)item$iv$iv;
                Collection<Object> collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(it.getId());
            }
            CVLRuleChoiceKt.validateRuleChoices(SetsKt.plus(set, CollectionsKt.toSet((List)destination$iv$iv2)));
        }
        return cvlAstList;
    }

    @ExperimentalSerializationApi
    public final void outForLSPServer(@NotNull CVLAst ast) {
        Intrinsics.checkNotNullParameter(ast, "ast");
        StringFormat $this$encodeToString$iv = CVLSerializerModules.INSTANCE.getLspServerFormat();
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer<Object> $this$cast$iv$iv$iv = SerializersKt.serializer($this$serializer$iv$iv, Reflection.typeOf(CVLAst.class));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull($this$cast$iv$iv$iv, "null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        System.out.println((Object)$this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, ast));
    }

    private final InputFileNames parseInputFileNames(String[] args2) {
        String internalDirectory;
        String string2;
        String string3;
        String buildFileName;
        Options options = new Options();
        String metadataFileOpt = "m";
        String verifyFileOpt = "v";
        String buildFileOpt = "b";
        String internalDirOpt = "d";
        options.addOption(metadataFileOpt, true, "metadata json file");
        options.addOption(verifyFileOpt, true, "verify json file");
        options.addOption(buildFileOpt, true, "build json file");
        options.addOption(internalDirOpt, true, "internal directory");
        CommandLine cmdLineArgs = new DefaultParser().parse(options, args2);
        String metadataFileName = cmdLineArgs.getOptionValue(metadataFileOpt);
        String string4 = cmdLineArgs.getOptionValue(buildFileOpt);
        if (string4 == null) {
            string4 = buildFileName = args2.length == 2 ? args2[0] : null;
        }
        if ((string3 = cmdLineArgs.getOptionValue(verifyFileOpt)) == null) {
            switch (args2.length) {
                case 2: {
                    string2 = args2[1];
                    break;
                }
                case 1: {
                    string2 = args2[0];
                    break;
                }
                default: {
                    string2 = null;
                    break;
                }
            }
        } else {
            string2 = string3;
        }
        String verifyFileName = string2;
        String string5 = internalDirectory = cmdLineArgs.getOptionValue(internalDirOpt);
        if (string5 != null) {
            String it = string5;
            boolean bl = false;
            Config.INSTANCE.getCertoraBuildDirectory().set((Serializable)((Object)it));
        }
        return new InputFileNames(metadataFileName, buildFileName, verifyFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void _main(@NotNull String[] args2, @NotNull Function1<? super CVLAst, Unit> astCb) {
        Intrinsics.checkNotNullParameter(args2, "args");
        Intrinsics.checkNotNullParameter(astCb, "astCb");
        try {
            try {
                Object stdin;
                InputFileNames inputFileNames = this.parseInputFileNames(args2);
                String metadataFileName = inputFileNames.getMetadataFileName();
                String buildFileName = inputFileNames.getBuildFileName();
                String verifyFileName = inputFileNames.getVerifyFileName();
                if (metadataFileName != null) {
                    try {
                        JsonObject metadataElem = JsonElementKt.getJsonObject(Json.Default.parseToJsonElement(FilesKt.readText$default(new File(metadataFileName), null, 1, null)));
                        this.setConfigFromMetadata(metadataElem);
                    }
                    catch (Exception e) {
                        Logger.Companion.alwaysWarn("Error in parsing input file " + metadataFileName);
                        throw e;
                    }
                }
                if (buildFileName != null && verifyFileName != null) {
                    this.withSpecAndContractBuildInformation(buildFileName, verifyFileName);
                } else if (verifyFileName != null) {
                    List<CVLAst> asts = this.withSpec(verifyFileName);
                    Iterable $this$forEach$iv = asts;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        CVLAst ast = (CVLAst)element$iv;
                        boolean bl = false;
                        astCb.invoke(ast);
                    }
                } else if (buildFileName == null) {
                    void $this$mapTo$iv$iv;
                    String string2 = ConsoleKt.readLine();
                    Intrinsics.checkNotNull(string2);
                    stdin = string2;
                    List verify2 = (List)JsonKt.Json$default(null, _main.verify.1.INSTANCE, 1, null).decodeFromString(BuiltinSerializersKt.ListSerializer(VerificationQuery.Companion.serializer()), (String)stdin);
                    Iterable $this$map$iv = verify2;
                    boolean $i$f$map = false;
                    Iterable ast = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void v;
                        VerificationQuery verificationQuery = (VerificationQuery)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(v.toCVLInput().getRawCVLAst());
                    }
                    List asts = (List)destination$iv$iv;
                    Iterable $this$forEach$iv = asts;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        CVLAst ast2 = (CVLAst)element$iv;
                        boolean bl = false;
                        astCb.invoke(ast2);
                    }
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    stdin = args2;
                    PrintStream printStream = System.err;
                    boolean $i$f$map = false;
                    void asts = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void bl = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(it.toString());
                    }
                    printStream.println("Bad input to CVL typechecker: " + (List)destination$iv$iv);
                }
                if (StandardCVLErrorLogger.INSTANCE.foundTypeError()) {
                    System.err.println("Found type errors");
                }
                System.exit(StandardCVLErrorLogger.INSTANCE.foundTypeError() ? 1 : 0);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            catch (CVLAstBuilder.CVLParsingException e) {
                System.err.println(e);
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            catch (Throwable e) {
                System.err.println(e);
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
        catch (Throwable throwable) {
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final String setConfigFromMetadata$getRulesFromMetadata(JsonObject metadataElem) {
        try {
            void $this$associateTo$iv$iv;
            void $this$filterTo$iv$iv;
            JsonElement settings;
            JsonElement jsonElement;
            JsonElement jsonElement2 = (JsonElement)JsonElementKt.getJsonObject(metadataElem).get((Object)"args");
            if (jsonElement2 == null) {
                jsonElement = null;
            } else {
                JsonObject jsonObject = JsonElementKt.getJsonObject(jsonElement2);
                jsonElement = settings = jsonObject == null ? null : (JsonElement)jsonObject.get((Object)"settings");
            }
            if (settings == null || settings instanceof JsonNull) {
                return null;
            }
            if (!(settings instanceof JsonArray)) {
                Logger.Companion.alwaysWarn("Cannot process metadata settings as they are not in array format");
                return null;
            }
            Iterable $this$filter$iv = (Iterable)JsonKt.Json$default(null, setConfigFromMetadata.getRulesFromMetadata.ruleMap.1.INSTANCE, 1, null).decodeFromString(BuiltinSerializersKt.ListSerializer(BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE)), JsonElementKt.getJsonArray(settings).toString());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)it, "=", false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                String it = (String)element$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{"="};
                List setting = StringsKt.split$default((CharSequence)it.toString(), stringArray, false, 0, 6, null);
                Pair pair = TuplesKt.to(setting.get(0), setting.get(1));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map ruleMap2 = destination$iv$iv2;
            String string2 = (String)ruleMap2.get("-rule");
            if (string2 == null) {
                string2 = (String)ruleMap2.get("-rules");
            }
            return string2;
        }
        catch (Exception e) {
            Logger.Companion.alwaysWarn("Could not parse settings from metadata", e);
            return null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0010H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R'\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\f\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lpreprocessing/ProverInputPreprocessor$BasicContractSource;", "Lscene/IContractSource;", "Lscene/IContractLoader;", "file", "", "(Ljava/lang/String;)V", "buildResources", "", "Lbridge/SingleDeployedContract;", "getBuildResources", "()Ljava/util/Map;", "buildResources$delegate", "Lkotlin/Lazy;", "getFile", "()Ljava/lang/String;", "instances", "", "Lbridge/ContractInstanceInSDC;", "getInstances", "()Ljava/util/List;", "instances$delegate", "aliases", "", "Ljava/math/BigInteger;", "load", "Lscene/IContractClass;", "sdc", "cache", "Lscene/IPerContractClassCache;", "Shared"})
    public static final class BasicContractSource
    implements IContractSource,
    IContractLoader {
        @NotNull
        private final String file;
        @NotNull
        private final Lazy buildResources$delegate;
        @NotNull
        private final Lazy instances$delegate;

        public BasicContractSource(@NotNull String file) {
            Intrinsics.checkNotNullParameter(file, "file");
            this.file = file;
            this.buildResources$delegate = LazyKt.lazy((Function0)new Function0<Map<String, ? extends SingleDeployedContract>>(this){
                final /* synthetic */ BasicContractSource this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Map<String, SingleDeployedContract> invoke() {
                    String it = FilesKt.readText$default(new File(this.this$0.getFile()), null, 1, null);
                    boolean bl = false;
                    return (Map)JsonKt.Json$default(null, buildResources.1.1.INSTANCE, 1, null).decodeFromString(BuiltinSerializersKt.MapSerializer(BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE), SingleDeployedContract.Companion.serializer()), it);
                }
            });
            this.instances$delegate = LazyKt.lazy((Function0)new Function0<List<? extends ContractInstanceInSDC>>(this){
                final /* synthetic */ BasicContractSource this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<ContractInstanceInSDC> invoke() {
                    void $this$mapTo$iv$iv;
                    Iterable $this$mapNotNullTo$iv$iv;
                    Map $this$mapNotNull$iv = BasicContractSource.access$getBuildResources(this.this$0);
                    boolean $i$f$mapNotNull = false;
                    Map map2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Object object = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (object.hasNext()) {
                        ContractInstanceInSDC it$iv$iv;
                        Object v0;
                        block3: {
                            Map.Entry<K, V> element$iv$iv$iv;
                            Map.Entry<K, V> element$iv$iv = element$iv$iv$iv = object.next();
                            boolean bl = false;
                            Map.Entry<K, V> $dstr$_u24__u24$v = element$iv$iv;
                            boolean bl2 = false;
                            SingleDeployedContract v = (SingleDeployedContract)$dstr$_u24__u24$v.getValue();
                            Iterable $this$firstOrNull$iv = v.getContracts();
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                ContractInstanceInSDC it = (ContractInstanceInSDC)element$iv;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual(it.getAddress(), v.getPrimary_contract_address())) continue;
                                v0 = element$iv;
                                break block3;
                            }
                            v0 = null;
                        }
                        if ((ContractInstanceInSDC)v0 == null) continue;
                        boolean bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void contractInstanceInSDC;
                        object = (ContractInstanceInSDC)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        BigInteger bigInteger = contractInstanceInSDC.getAddress();
                        Map<K, V> map3 = MapsKt.emptyMap();
                        String string2 = contractInstanceInSDC.getName();
                        StorageLayout storageLayout = contractInstanceInSDC.getStorageLayout();
                        Set<SourceTypeDescription> set = contractInstanceInSDC.getTypes();
                        List<Method> list = contractInstanceInSDC.getMethods();
                        List<Method> list2 = contractInstanceInSDC.getAllMethods();
                        String string3 = contractInstanceInSDC.getOriginal_file();
                        SourceLanguage sourceLanguage = contractInstanceInSDC.getLang();
                        collection.add(new ContractInstanceInSDC(string2, string3, sourceLanguage, "", bigInteger, list, "", "", "", null, null, storageLayout, set, map3, null, null, null, null, null, list2, null, null, 3655168, null));
                    }
                    return (List)destination$iv$iv;
                }
            });
        }

        @NotNull
        public final String getFile() {
            return this.file;
        }

        private final Map<String, SingleDeployedContract> getBuildResources() {
            Lazy lazy = this.buildResources$delegate;
            return (Map)lazy.getValue();
        }

        private final List<ContractInstanceInSDC> getInstances() {
            Lazy lazy = this.instances$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @NotNull
        public IContractClass load(@NotNull ContractInstanceInSDC sdc, @NotNull IPerContractClassCache cache2) {
            Intrinsics.checkNotNullParameter(sdc, "sdc");
            Intrinsics.checkNotNullParameter(cache2, "cache");
            return new IContractClass(sdc){
                final /* synthetic */ ContractInstanceInSDC $sdc;
                {
                    this.$sdc = $sdc;
                }

                @Nullable
                public ITACMethod getConstructor() {
                    return null;
                }

                @Nullable
                public ITACMethod getMethodBySigHash(@NotNull BigInteger sig) {
                    Intrinsics.checkNotNullParameter(sig, "sig");
                    return null;
                }

                @Nullable
                public ITACMethod getMethodByUniqueAttribute(@NotNull MethodAttribute.Unique attr) {
                    Intrinsics.checkNotNullParameter(attr, "attr");
                    return null;
                }

                @NotNull
                public IStorageInfo getStorage() {
                    return DummyStorageInfo.INSTANCE;
                }

                @Nullable
                public TACStorageLayout getStorageLayout() {
                    StorageLayout storageLayout = this.$sdc.getStorageLayout();
                    return storageLayout == null ? null : storageLayout.toTACStorageLayout();
                }

                @NotNull
                public Collection<ITACMethod> getDeclaredMethods() {
                    return CollectionsKt.emptyList();
                }

                public void mapMethods(@NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, ? extends ICoreTACProgram> p) {
                    Intrinsics.checkNotNullParameter(scene, "scene");
                    Intrinsics.checkNotNullParameter(p, "p");
                }

                @NotNull
                public IContractClass fork() {
                    return this;
                }

                @NotNull
                public BigInteger getInstanceId() {
                    return this.$sdc.getAddress();
                }

                @NotNull
                public String getName() {
                    return this.$sdc.getName();
                }

                @NotNull
                public Map<BigInteger, ITACMethod> getMethods() {
                    return MapsKt.emptyMap();
                }

                @Nullable
                public ITACMethod getWholeContractMethod() {
                    return null;
                }

                @Nullable
                public ITACMethod getConstructorMethod() {
                    return null;
                }

                @Nullable
                public DisassembledEVMBytecode getBytecode() {
                    return null;
                }

                @Nullable
                public DisassembledEVMBytecode getConstructorBytecode() {
                    return null;
                }

                @NotNull
                public ContractInstanceInSDC getSrc() {
                    return this.$sdc;
                }

                @NotNull
                public ITACSymbol getAddressSym() {
                    throw new UnsupportedOperationException();
                }

                @NotNull
                public ContractClassIdentifiers toIdentifiers() {
                    return IContractClass.DefaultImpls.toIdentifiers(this);
                }

                @NotNull
                public ITACMethod getWholeContract() {
                    return IContractClass.DefaultImpls.getWholeContract(this);
                }

                @NotNull
                public List<ITACMethod> getMethods() {
                    return IContractClass.DefaultImpls.getMethods(this);
                }

                public void mapMethodsInPlace(@NotNull IScene scene, @NotNull Function2<? super IScene, ? super ITACMethod, Unit> p) {
                    IContractClass.DefaultImpls.mapMethodsInPlace(this, scene, p);
                }

                @NotNull
                public String getConstructorCodeName() {
                    return IContractClass.DefaultImpls.getConstructorCodeName(this);
                }

                @NotNull
                public IContractClass.ContractMemento saveState() {
                    return IContractClass.DefaultImpls.saveState(this);
                }

                public void restore(@NotNull IContractClass.ContractMemento m) {
                    IContractClass.DefaultImpls.restore(this, m);
                }

                @Nullable
                public ContractWithStateLinkInfo getContractStateLinks() {
                    return IContractClass.DefaultImpls.getContractStateLinks(this);
                }
            };
        }

        @Override
        @NotNull
        public List<ContractInstanceInSDC> instances() {
            return this.getInstances();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Set<BigInteger>> aliases() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getInstances();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ContractInstanceInSDC contractInstanceInSDC = (ContractInstanceInSDC)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(SetsKt.setOf(it.getAddress()));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public IContractClass load(@NotNull ContractInstanceInSDC sdc) {
            return IContractLoader.DefaultImpls.load(this, sdc);
        }

        @Override
        @NotNull
        public ContractUniverse contractUniverse() {
            return IContractSource.DefaultImpls.contractUniverse(this);
        }

        @Override
        @NotNull
        public IContractClass invoke(@NotNull ContractInstanceInSDC sdc) {
            return IContractLoader.DefaultImpls.invoke(this, sdc);
        }

        public static final /* synthetic */ Map access$getBuildResources(BasicContractSource $this) {
            return $this.getBuildResources();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J-\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lpreprocessing/ProverInputPreprocessor$InputFileNames;", "", "metadataFileName", "", "buildFileName", "verifyFileName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBuildFileName", "()Ljava/lang/String;", "getMetadataFileName", "getVerifyFileName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Shared"})
    public static final class InputFileNames {
        @Nullable
        private final String metadataFileName;
        @Nullable
        private final String buildFileName;
        @Nullable
        private final String verifyFileName;

        public InputFileNames(@Nullable String metadataFileName, @Nullable String buildFileName, @Nullable String verifyFileName) {
            this.metadataFileName = metadataFileName;
            this.buildFileName = buildFileName;
            this.verifyFileName = verifyFileName;
        }

        @Nullable
        public final String getMetadataFileName() {
            return this.metadataFileName;
        }

        @Nullable
        public final String getBuildFileName() {
            return this.buildFileName;
        }

        @Nullable
        public final String getVerifyFileName() {
            return this.verifyFileName;
        }

        @Nullable
        public final String component1() {
            return this.metadataFileName;
        }

        @Nullable
        public final String component2() {
            return this.buildFileName;
        }

        @Nullable
        public final String component3() {
            return this.verifyFileName;
        }

        @NotNull
        public final InputFileNames copy(@Nullable String metadataFileName, @Nullable String buildFileName, @Nullable String verifyFileName) {
            return new InputFileNames(metadataFileName, buildFileName, verifyFileName);
        }

        public static /* synthetic */ InputFileNames copy$default(InputFileNames inputFileNames, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = inputFileNames.metadataFileName;
            }
            if ((n & 2) != 0) {
                string3 = inputFileNames.buildFileName;
            }
            if ((n & 4) != 0) {
                string4 = inputFileNames.verifyFileName;
            }
            return inputFileNames.copy(string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "InputFileNames(metadataFileName=" + this.metadataFileName + ", buildFileName=" + this.buildFileName + ", verifyFileName=" + this.verifyFileName + ")";
        }

        public int hashCode() {
            int result2 = this.metadataFileName == null ? 0 : this.metadataFileName.hashCode();
            result2 = result2 * 31 + (this.buildFileName == null ? 0 : this.buildFileName.hashCode());
            result2 = result2 * 31 + (this.verifyFileName == null ? 0 : this.verifyFileName.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InputFileNames)) {
                return false;
            }
            InputFileNames inputFileNames = (InputFileNames)other;
            if (!Intrinsics.areEqual(this.metadataFileName, inputFileNames.metadataFileName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.buildFileName, inputFileNames.buildFileName)) {
                return false;
            }
            return Intrinsics.areEqual(this.verifyFileName, inputFileNames.verifyFileName);
        }
    }
}

