/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.io.Serializable;

public class FileEntry
implements Serializable {
    private static final long serialVersionUID = -2505664948818681153L;
    static final FileEntry[] EMPTY_ENTRIES = new FileEntry[0];
    private final FileEntry parent;
    private FileEntry[] children;
    private final File file;
    private String name;
    private boolean exists;
    private boolean directory;
    private long lastModified;
    private long length;

    public FileEntry(File file2) {
        this(null, file2);
    }

    public FileEntry(FileEntry parent, File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException("File is missing");
        }
        this.file = file2;
        this.parent = parent;
        this.name = file2.getName();
    }

    public boolean refresh(File file2) {
        boolean origExists = this.exists;
        long origLastModified = this.lastModified;
        boolean origDirectory = this.directory;
        long origLength = this.length;
        this.name = file2.getName();
        this.exists = file2.exists();
        this.directory = this.exists && file2.isDirectory();
        this.lastModified = this.exists ? file2.lastModified() : 0L;
        this.length = this.exists && !this.directory ? file2.length() : 0L;
        return this.exists != origExists || this.lastModified != origLastModified || this.directory != origDirectory || this.length != origLength;
    }

    public FileEntry newChildInstance(File file2) {
        return new FileEntry(this, file2);
    }

    public FileEntry getParent() {
        return this.parent;
    }

    public int getLevel() {
        return this.parent == null ? 0 : this.parent.getLevel() + 1;
    }

    public FileEntry[] getChildren() {
        return this.children != null ? this.children : EMPTY_ENTRIES;
    }

    public void setChildren(FileEntry ... children2) {
        this.children = children2;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length2) {
        this.length = length2;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }
}

