"""Collect code tags and output for review in a single location."""

from beartype import beartype

from ..code_tag_collector import write_code_tag_file
from ..file_helpers import get_relative
from .base import debug_task
from .doit_globals import DoitTask, get_dg


@beartype
def task_collect_code_tags() -> DoitTask:
    """Create a summary file with all of the found code tags.

    Returns:
        DoitTask: doit task

    """
    dg = get_dg()
    # Filter out any files that are auto-generated and would have duplicate code tags, such as the documentation
    user_files = [pth for pth in dg.meta.paths if not get_relative(pth, dg.doc.auto_doc_path)]
    kwargs = {
        'path_tag_summary': dg.tags.path_code_tag_summary,
        'paths_source': user_files,
        'base_dir': dg.meta.path_project,
        'regex_compiled': dg.tags.compile_issue_regex(),
        'header': '# Task Summary\n\nAuto-Generated by `calcipy`',
        'tag_order': dg.tags.tags,
    }
    return debug_task([(write_code_tag_file, (), kwargs)])
