"""
Django settings for data_middle project.

Generated by 'django-admin startproject' using Django 3.0.3.

For more information on this file, see
https://docs.djangoproject.com/en/3.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/3.0/ref/settings/
"""

import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
import sys

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, BASE_DIR)
sys.path.insert(0, os.path.join(BASE_DIR, 'data_apps'))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/3.0/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '-6on6-fll5dadvjwrfgiz7$nh#yuju27p!ey1!v!x+c0fbf+lh'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ['*']

APP_NAME = "data_middle"

# 部署服务器静态文件配置
kibana_not_used = True  # 是否kibana管理(实验室后台： False)
if kibana_not_used:
    STATIC_URL = '/static/'
    # STATIC_ROOT = BASE_DIR
else:
    STATIC_URL = '/%s/static/' % APP_NAME  # static文件网络路径
    USE_X_FORWARDED_HOST = True
    FORCE_SCRIPT_NAME = '/%s' % APP_NAME
STATIC_ROOT = '/%s/static/' % APP_NAME
MEDIA_URL = "/media/"  # 不设置的话默认值是''，配置图片存储根目录相对路径
MEDIA_ROOT = os.path.join(BASE_DIR, "media")  #  配置图片存储根目录绝对路径，被urls.py调用，可以用来加载展示和下载图片


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'corsheaders',
    # 'rest_framework_swagger',
    'rest_framework',
    'django_filters',
    'data_apps.tlms_wms_public_table',
    'data_apps.direct',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'corsheaders.middleware.CorsMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]
# 允许携带cookie
CORS_ALLOW_CREDENTIALS = True
CORS_ORIGIN_ALLOW_ALL = True
# 指定域名（客户端）的允许跨域，与CORS_ORIGIN_ALLOW_ALL = True不共存：
CORS_ORIGIN_WHITELIST = (
    # 'localhost',
    # '127.0.0.1'
)
CORS_ALLOW_METHODS = (
    'DELETE',
    'GET',
    'OPTIONS',
    'PATCH',
    'POST',
    'PUT',
    'VIEW',
)

CORS_ALLOW_HEADERS = (
    'accept',
    'accept-encoding',
    'authorization',
    'content-type',
    'dnt',
    'origin',
    'user-agent',
    'x-csrftoken',
    'Access-Control-Allow-Origin',
    'x-requested-with',
)
ROOT_URLCONF = 'data_apps.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [os.path.join(BASE_DIR, 'templates')]
        ,
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'data_middle_platform_serve.wsgi.application'


# Database
# https://docs.djangoproject.com/en/3.0/ref/settings/#databases

DATABASES = {
    # 同盛
    # 'default': {
    #         'ENGINE': 'django.db.backends.postgresql_psycopg2',
    #         'NAME': "wms",
    #         'USER': 'wms',
    #         'PASSWORD': 'wms',
    #         'HOST': '172.31.41.102',
    #         'PORT': '5432',
    #         'OPTIONS': {
    #             'options': '-c search_path=public'
    #         }
    # },
    # 黑河
    # 'default': {
    #         'ENGINE': 'django.db.backends.postgresql_psycopg2',
    #         'NAME': "ilp",
    #         'USER': 'wms',
    #         'PASSWORD': 'taijiD@t@b@se',
    #         'HOST': '192.168.100.110',
    #         'PORT': '5432',
    #         'OPTIONS': {
    #             'options': '-c search_path=public'
    #         }
    # },
    # 即墨
    # 'default': {
    #         'ENGINE': 'django.db.backends.postgresql_psycopg2',
    #         'NAME': "ilp",
    #         'USER': 'wms',
    #         'PASSWORD': 'taijiD@t@b@se',
    #         'HOST': '10.2.0.152',
    #         'PORT': '5432',
    #         'OPTIONS': {
    #             'options': '-c search_path=public'
    #         }
    # },
    # 牡丹江
    # 'default': {
    #         'ENGINE': 'django.db.backends.postgresql_psycopg2',
    #         'NAME': "ilp",
    #         'USER': 'wms',
    #         'PASSWORD': 'taijiD@t@b@se',
    #         'HOST': '1.56.207.136',
    #         'PORT': '5432',
    #         'OPTIONS': {
    #             'options': '-c search_path=public'
    #         }
    # },
    # 'jiping': {
    #             'ENGINE': 'django.db.backends.postgresql_psycopg2',
    #             'NAME': "ilp",
    #             'USER': 'wms',
    #             'PASSWORD': 'SMU@0322',
    #             'HOST': '192.168.66.93',
    #             'PORT': '5432',
    #             'OPTIONS': {
    #                 'options': '-c search_path=public'
    #             }
    # },
    'default': {
                'ENGINE': 'django.db.backends.postgresql_psycopg2',
                'NAME': "ilp",
                'USER': 'wms',
                'PASSWORD': 'taijiD@t@b@se',
                'HOST': '192.168.40.62',
                'PORT': '5432',
                'OPTIONS': {
                    'options': '-c search_path=public'
                }
    },



}


# Password validation
# https://docs.djangoproject.com/en/3.0/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/3.0/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/3.0/howto/static-files/

STATIC_URL = '/static/'

REST_FRAMEWORK = {
    'DEFAULT_SCHEMA_CLASS': 'rest_framework.schemas.coreapi.AutoSchema',
}
# swagger 配置项
SWAGGER_SETTINGS = {
    # 基础样式
    'SECURITY_DEFINITIONS': {
        "basic": {
            'type': 'basic'
        }
    },
    # 如果需要登录才能够查看接口文档, 登录的链接使用restframework自带的.
    'LOGIN_URL': 'rest_framework:login',
    'LOGOUT_URL': 'rest_framework:logout',
    # 'DOC_EXPANSION': None,
    # 'SHOW_REQUEST_HEADERS':True,
    # 'USE_SESSION_AUTH': True,
    # 'DOC_EXPANSION': 'list',
    # 接口文档中方法列表以首字母升序排列
    'APIS_SORTER': 'alpha',
    # 如果支持json提交, 则接口文档中包含json输入框
    'JSON_EDITOR': True,
    # 方法列表字母排序
    'OPERATIONS_SORTER': 'alpha',
    'VALIDATOR_URL': None,
}