# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from .insight import Insight, InsightStateInfo
from .insight_type_config import InsightTypeConfig, InsightTypeGenerationConfig
from .recommendation import (
    CostProjection,
    Impact,
    Operation,
    OperationGroup,
    Recommendation,
    RecommendationContent,
    RecommendationStateInfo,
    SecurityProjection,
    SustainabilityProjection,
    ValueMatcher,
)
from .recommender_config import RecommenderConfig, RecommenderGenerationConfig
from .recommender_service import (
    GetInsightRequest,
    GetInsightTypeConfigRequest,
    GetRecommendationRequest,
    GetRecommenderConfigRequest,
    ListInsightsRequest,
    ListInsightsResponse,
    ListRecommendationsRequest,
    ListRecommendationsResponse,
    MarkInsightAcceptedRequest,
    MarkRecommendationClaimedRequest,
    MarkRecommendationFailedRequest,
    MarkRecommendationSucceededRequest,
    UpdateInsightTypeConfigRequest,
    UpdateRecommenderConfigRequest,
)

__all__ = (
    "Insight",
    "InsightStateInfo",
    "InsightTypeConfig",
    "InsightTypeGenerationConfig",
    "CostProjection",
    "Impact",
    "Operation",
    "OperationGroup",
    "Recommendation",
    "RecommendationContent",
    "RecommendationStateInfo",
    "SecurityProjection",
    "SustainabilityProjection",
    "ValueMatcher",
    "RecommenderConfig",
    "RecommenderGenerationConfig",
    "GetInsightRequest",
    "GetInsightTypeConfigRequest",
    "GetRecommendationRequest",
    "GetRecommenderConfigRequest",
    "ListInsightsRequest",
    "ListInsightsResponse",
    "ListRecommendationsRequest",
    "ListRecommendationsResponse",
    "MarkInsightAcceptedRequest",
    "MarkRecommendationClaimedRequest",
    "MarkRecommendationFailedRequest",
    "MarkRecommendationSucceededRequest",
    "UpdateInsightTypeConfigRequest",
    "UpdateRecommenderConfigRequest",
)
