# Copyright 2021 IRT Saint Exupéry, https://www.irt-saintexupery.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License version 3 as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
# Contributors:
#    INITIAL AUTHORS - initial API and implementation and/or
#                      initial documentation
#        :author:  Matthias De Lozzo
#    OTHER AUTHORS   - MACROSCOPIC CHANGES
from __future__ import annotations

from gemseo.algos.parameter_space import ParameterSpace
from gemseo.disciplines.analytic import AnalyticDiscipline
from gemseo.uncertainty.sensitivity.factory import SensitivityAnalysisFactory
from numpy import pi


def test_constructor():
    SensitivityAnalysisFactory()


def test_available():
    factory = SensitivityAnalysisFactory()
    sensitivity_indices = factory.available_sensitivity_analyses
    assert "MorrisAnalysis" in sensitivity_indices


def test_is_available():
    factory = SensitivityAnalysisFactory()
    assert factory.is_available("MorrisAnalysis")
    assert not factory.is_available("FooAnalysis")


def test_create():
    discipline = AnalyticDiscipline(
        {"y": "sin(x1)+7*sin(x2)**2+0.1*x3**4*sin(x1)"}, name="Ishigami"
    )

    space = ParameterSpace()
    for variable in ["x1", "x2", "x3"]:
        space.add_random_variable(
            variable, "OTUniformDistribution", minimum=-pi, maximum=pi
        )
    factory = SensitivityAnalysisFactory()
    assert factory.create(
        "MorrisAnalysis", (discipline,), space, n_samples=None, n_replicates=5
    )
