# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.  # noqa: E501

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from docusign_esign.client.configuration import Configuration


class LockInformation(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'error_details': 'ErrorDetails',
        'lock_duration_in_seconds': 'str',
        'locked_by_app': 'str',
        'locked_by_user': 'UserInfo',
        'locked_until_date_time': 'str',
        'lock_token': 'str',
        'lock_type': 'str',
        'use_scratch_pad': 'str'
    }

    attribute_map = {
        'error_details': 'errorDetails',
        'lock_duration_in_seconds': 'lockDurationInSeconds',
        'locked_by_app': 'lockedByApp',
        'locked_by_user': 'lockedByUser',
        'locked_until_date_time': 'lockedUntilDateTime',
        'lock_token': 'lockToken',
        'lock_type': 'lockType',
        'use_scratch_pad': 'useScratchPad'
    }

    def __init__(self, _configuration=None, **kwargs):  # noqa: E501
        """LockInformation - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._error_details = None
        self._lock_duration_in_seconds = None
        self._locked_by_app = None
        self._locked_by_user = None
        self._locked_until_date_time = None
        self._lock_token = None
        self._lock_type = None
        self._use_scratch_pad = None
        self.discriminator = None

        setattr(self, "_{}".format('error_details'), kwargs.get('error_details', None))
        setattr(self, "_{}".format('lock_duration_in_seconds'), kwargs.get('lock_duration_in_seconds', None))
        setattr(self, "_{}".format('locked_by_app'), kwargs.get('locked_by_app', None))
        setattr(self, "_{}".format('locked_by_user'), kwargs.get('locked_by_user', None))
        setattr(self, "_{}".format('locked_until_date_time'), kwargs.get('locked_until_date_time', None))
        setattr(self, "_{}".format('lock_token'), kwargs.get('lock_token', None))
        setattr(self, "_{}".format('lock_type'), kwargs.get('lock_type', None))
        setattr(self, "_{}".format('use_scratch_pad'), kwargs.get('use_scratch_pad', None))

    @property
    def error_details(self):
        """Gets the error_details of this LockInformation.  # noqa: E501

        This object describes errors that occur. It is only valid for responses and ignored in requests.  # noqa: E501

        :return: The error_details of this LockInformation.  # noqa: E501
        :rtype: ErrorDetails
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """Sets the error_details of this LockInformation.

        This object describes errors that occur. It is only valid for responses and ignored in requests.  # noqa: E501

        :param error_details: The error_details of this LockInformation.  # noqa: E501
        :type: ErrorDetails
        """

        self._error_details = error_details

    @property
    def lock_duration_in_seconds(self):
        """Gets the lock_duration_in_seconds of this LockInformation.  # noqa: E501

        Sets the time, in seconds, until the lock expires when there is no activity on the envelope.  If no value is entered, then the default value of 300 seconds is used. The maximum value is 1,800 seconds.  The lock duration can be extended.   # noqa: E501

        :return: The lock_duration_in_seconds of this LockInformation.  # noqa: E501
        :rtype: str
        """
        return self._lock_duration_in_seconds

    @lock_duration_in_seconds.setter
    def lock_duration_in_seconds(self, lock_duration_in_seconds):
        """Sets the lock_duration_in_seconds of this LockInformation.

        Sets the time, in seconds, until the lock expires when there is no activity on the envelope.  If no value is entered, then the default value of 300 seconds is used. The maximum value is 1,800 seconds.  The lock duration can be extended.   # noqa: E501

        :param lock_duration_in_seconds: The lock_duration_in_seconds of this LockInformation.  # noqa: E501
        :type: str
        """

        self._lock_duration_in_seconds = lock_duration_in_seconds

    @property
    def locked_by_app(self):
        """Gets the locked_by_app of this LockInformation.  # noqa: E501

        Specifies the friendly name of  the application that is locking the envelope.  # noqa: E501

        :return: The locked_by_app of this LockInformation.  # noqa: E501
        :rtype: str
        """
        return self._locked_by_app

    @locked_by_app.setter
    def locked_by_app(self, locked_by_app):
        """Sets the locked_by_app of this LockInformation.

        Specifies the friendly name of  the application that is locking the envelope.  # noqa: E501

        :param locked_by_app: The locked_by_app of this LockInformation.  # noqa: E501
        :type: str
        """

        self._locked_by_app = locked_by_app

    @property
    def locked_by_user(self):
        """Gets the locked_by_user of this LockInformation.  # noqa: E501

        A complex type containing information about the user that has the envelope or template locked.  # noqa: E501

        :return: The locked_by_user of this LockInformation.  # noqa: E501
        :rtype: UserInfo
        """
        return self._locked_by_user

    @locked_by_user.setter
    def locked_by_user(self, locked_by_user):
        """Sets the locked_by_user of this LockInformation.

        A complex type containing information about the user that has the envelope or template locked.  # noqa: E501

        :param locked_by_user: The locked_by_user of this LockInformation.  # noqa: E501
        :type: UserInfo
        """

        self._locked_by_user = locked_by_user

    @property
    def locked_until_date_time(self):
        """Gets the locked_until_date_time of this LockInformation.  # noqa: E501

        The datetime until the envelope lock expires.  # noqa: E501

        :return: The locked_until_date_time of this LockInformation.  # noqa: E501
        :rtype: str
        """
        return self._locked_until_date_time

    @locked_until_date_time.setter
    def locked_until_date_time(self, locked_until_date_time):
        """Sets the locked_until_date_time of this LockInformation.

        The datetime until the envelope lock expires.  # noqa: E501

        :param locked_until_date_time: The locked_until_date_time of this LockInformation.  # noqa: E501
        :type: str
        """

        self._locked_until_date_time = locked_until_date_time

    @property
    def lock_token(self):
        """Gets the lock_token of this LockInformation.  # noqa: E501

        A unique identifier provided to the owner of the envelope lock.   Used to prove ownership of the lock.  # noqa: E501

        :return: The lock_token of this LockInformation.  # noqa: E501
        :rtype: str
        """
        return self._lock_token

    @lock_token.setter
    def lock_token(self, lock_token):
        """Sets the lock_token of this LockInformation.

        A unique identifier provided to the owner of the envelope lock.   Used to prove ownership of the lock.  # noqa: E501

        :param lock_token: The lock_token of this LockInformation.  # noqa: E501
        :type: str
        """

        self._lock_token = lock_token

    @property
    def lock_type(self):
        """Gets the lock_type of this LockInformation.  # noqa: E501

        The type of envelope lock.  Currently \"edit\" is the only supported type.  # noqa: E501

        :return: The lock_type of this LockInformation.  # noqa: E501
        :rtype: str
        """
        return self._lock_type

    @lock_type.setter
    def lock_type(self, lock_type):
        """Sets the lock_type of this LockInformation.

        The type of envelope lock.  Currently \"edit\" is the only supported type.  # noqa: E501

        :param lock_type: The lock_type of this LockInformation.  # noqa: E501
        :type: str
        """

        self._lock_type = lock_type

    @property
    def use_scratch_pad(self):
        """Gets the use_scratch_pad of this LockInformation.  # noqa: E501

        Reserved for future use.  Indicates whether a scratchpad is used for editing information.    # noqa: E501

        :return: The use_scratch_pad of this LockInformation.  # noqa: E501
        :rtype: str
        """
        return self._use_scratch_pad

    @use_scratch_pad.setter
    def use_scratch_pad(self, use_scratch_pad):
        """Sets the use_scratch_pad of this LockInformation.

        Reserved for future use.  Indicates whether a scratchpad is used for editing information.    # noqa: E501

        :param use_scratch_pad: The use_scratch_pad of this LockInformation.  # noqa: E501
        :type: str
        """

        self._use_scratch_pad = use_scratch_pad

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LockInformation, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LockInformation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LockInformation):
            return True

        return self.to_dict() != other.to_dict()
