# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.  # noqa: E501

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from docusign_esign.client.configuration import Configuration


class AccountBillingPlanResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'billing_address': 'AccountAddress',
        'billing_address_is_credit_card_address': 'str',
        'billing_plan': 'AccountBillingPlan',
        'credit_card_information': 'CreditCardInformation',
        'direct_debit_processor_information': 'DirectDebitProcessorInformation',
        'downgrade_plan_information': 'DowngradePlanUpdateResponse',
        'downgrade_request_information': 'DowngradeRequestInformation',
        'entity_information': 'BillingEntityInformationResponse',
        'payment_method': 'str',
        'payment_processor_information': 'PaymentProcessorInformation',
        'referral_information': 'ReferralInformation',
        'successor_plans': 'list[BillingPlan]',
        'tax_exempt_id': 'str'
    }

    attribute_map = {
        'billing_address': 'billingAddress',
        'billing_address_is_credit_card_address': 'billingAddressIsCreditCardAddress',
        'billing_plan': 'billingPlan',
        'credit_card_information': 'creditCardInformation',
        'direct_debit_processor_information': 'directDebitProcessorInformation',
        'downgrade_plan_information': 'downgradePlanInformation',
        'downgrade_request_information': 'downgradeRequestInformation',
        'entity_information': 'entityInformation',
        'payment_method': 'paymentMethod',
        'payment_processor_information': 'paymentProcessorInformation',
        'referral_information': 'referralInformation',
        'successor_plans': 'successorPlans',
        'tax_exempt_id': 'taxExemptId'
    }

    def __init__(self, _configuration=None, **kwargs):  # noqa: E501
        """AccountBillingPlanResponse - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._billing_address = None
        self._billing_address_is_credit_card_address = None
        self._billing_plan = None
        self._credit_card_information = None
        self._direct_debit_processor_information = None
        self._downgrade_plan_information = None
        self._downgrade_request_information = None
        self._entity_information = None
        self._payment_method = None
        self._payment_processor_information = None
        self._referral_information = None
        self._successor_plans = None
        self._tax_exempt_id = None
        self.discriminator = None

        setattr(self, "_{}".format('billing_address'), kwargs.get('billing_address', None))
        setattr(self, "_{}".format('billing_address_is_credit_card_address'), kwargs.get('billing_address_is_credit_card_address', None))
        setattr(self, "_{}".format('billing_plan'), kwargs.get('billing_plan', None))
        setattr(self, "_{}".format('credit_card_information'), kwargs.get('credit_card_information', None))
        setattr(self, "_{}".format('direct_debit_processor_information'), kwargs.get('direct_debit_processor_information', None))
        setattr(self, "_{}".format('downgrade_plan_information'), kwargs.get('downgrade_plan_information', None))
        setattr(self, "_{}".format('downgrade_request_information'), kwargs.get('downgrade_request_information', None))
        setattr(self, "_{}".format('entity_information'), kwargs.get('entity_information', None))
        setattr(self, "_{}".format('payment_method'), kwargs.get('payment_method', None))
        setattr(self, "_{}".format('payment_processor_information'), kwargs.get('payment_processor_information', None))
        setattr(self, "_{}".format('referral_information'), kwargs.get('referral_information', None))
        setattr(self, "_{}".format('successor_plans'), kwargs.get('successor_plans', None))
        setattr(self, "_{}".format('tax_exempt_id'), kwargs.get('tax_exempt_id', None))

    @property
    def billing_address(self):
        """Gets the billing_address of this AccountBillingPlanResponse.  # noqa: E501

        The billing address for the account.  # noqa: E501

        :return: The billing_address of this AccountBillingPlanResponse.  # noqa: E501
        :rtype: AccountAddress
        """
        return self._billing_address

    @billing_address.setter
    def billing_address(self, billing_address):
        """Sets the billing_address of this AccountBillingPlanResponse.

        The billing address for the account.  # noqa: E501

        :param billing_address: The billing_address of this AccountBillingPlanResponse.  # noqa: E501
        :type: AccountAddress
        """

        self._billing_address = billing_address

    @property
    def billing_address_is_credit_card_address(self):
        """Gets the billing_address_is_credit_card_address of this AccountBillingPlanResponse.  # noqa: E501

        When set to **true**, the credit card address information is the same as that returned as the billing address. If false, then the billing address is considered a billing contact address, and the credit card address can be different.  # noqa: E501

        :return: The billing_address_is_credit_card_address of this AccountBillingPlanResponse.  # noqa: E501
        :rtype: str
        """
        return self._billing_address_is_credit_card_address

    @billing_address_is_credit_card_address.setter
    def billing_address_is_credit_card_address(self, billing_address_is_credit_card_address):
        """Sets the billing_address_is_credit_card_address of this AccountBillingPlanResponse.

        When set to **true**, the credit card address information is the same as that returned as the billing address. If false, then the billing address is considered a billing contact address, and the credit card address can be different.  # noqa: E501

        :param billing_address_is_credit_card_address: The billing_address_is_credit_card_address of this AccountBillingPlanResponse.  # noqa: E501
        :type: str
        """

        self._billing_address_is_credit_card_address = billing_address_is_credit_card_address

    @property
    def billing_plan(self):
        """Gets the billing_plan of this AccountBillingPlanResponse.  # noqa: E501

        An object that contains details about the billing plan.  # noqa: E501

        :return: The billing_plan of this AccountBillingPlanResponse.  # noqa: E501
        :rtype: AccountBillingPlan
        """
        return self._billing_plan

    @billing_plan.setter
    def billing_plan(self, billing_plan):
        """Sets the billing_plan of this AccountBillingPlanResponse.

        An object that contains details about the billing plan.  # noqa: E501

        :param billing_plan: The billing_plan of this AccountBillingPlanResponse.  # noqa: E501
        :type: AccountBillingPlan
        """

        self._billing_plan = billing_plan

    @property
    def credit_card_information(self):
        """Gets the credit_card_information of this AccountBillingPlanResponse.  # noqa: E501

        A complex type that has information about the credit card used to pay for this account.  # noqa: E501

        :return: The credit_card_information of this AccountBillingPlanResponse.  # noqa: E501
        :rtype: CreditCardInformation
        """
        return self._credit_card_information

    @credit_card_information.setter
    def credit_card_information(self, credit_card_information):
        """Sets the credit_card_information of this AccountBillingPlanResponse.

        A complex type that has information about the credit card used to pay for this account.  # noqa: E501

        :param credit_card_information: The credit_card_information of this AccountBillingPlanResponse.  # noqa: E501
        :type: CreditCardInformation
        """

        self._credit_card_information = credit_card_information

    @property
    def direct_debit_processor_information(self):
        """Gets the direct_debit_processor_information of this AccountBillingPlanResponse.  # noqa: E501

        Information about the bank that processes direct debits for the payment plan.  # noqa: E501

        :return: The direct_debit_processor_information of this AccountBillingPlanResponse.  # noqa: E501
        :rtype: DirectDebitProcessorInformation
        """
        return self._direct_debit_processor_information

    @direct_debit_processor_information.setter
    def direct_debit_processor_information(self, direct_debit_processor_information):
        """Sets the direct_debit_processor_information of this AccountBillingPlanResponse.

        Information about the bank that processes direct debits for the payment plan.  # noqa: E501

        :param direct_debit_processor_information: The direct_debit_processor_information of this AccountBillingPlanResponse.  # noqa: E501
        :type: DirectDebitProcessorInformation
        """

        self._direct_debit_processor_information = direct_debit_processor_information

    @property
    def downgrade_plan_information(self):
        """Gets the downgrade_plan_information of this AccountBillingPlanResponse.  # noqa: E501

          # noqa: E501

        :return: The downgrade_plan_information of this AccountBillingPlanResponse.  # noqa: E501
        :rtype: DowngradePlanUpdateResponse
        """
        return self._downgrade_plan_information

    @downgrade_plan_information.setter
    def downgrade_plan_information(self, downgrade_plan_information):
        """Sets the downgrade_plan_information of this AccountBillingPlanResponse.

          # noqa: E501

        :param downgrade_plan_information: The downgrade_plan_information of this AccountBillingPlanResponse.  # noqa: E501
        :type: DowngradePlanUpdateResponse
        """

        self._downgrade_plan_information = downgrade_plan_information

    @property
    def downgrade_request_information(self):
        """Gets the downgrade_request_information of this AccountBillingPlanResponse.  # noqa: E501

          # noqa: E501

        :return: The downgrade_request_information of this AccountBillingPlanResponse.  # noqa: E501
        :rtype: DowngradeRequestInformation
        """
        return self._downgrade_request_information

    @downgrade_request_information.setter
    def downgrade_request_information(self, downgrade_request_information):
        """Sets the downgrade_request_information of this AccountBillingPlanResponse.

          # noqa: E501

        :param downgrade_request_information: The downgrade_request_information of this AccountBillingPlanResponse.  # noqa: E501
        :type: DowngradeRequestInformation
        """

        self._downgrade_request_information = downgrade_request_information

    @property
    def entity_information(self):
        """Gets the entity_information of this AccountBillingPlanResponse.  # noqa: E501

          # noqa: E501

        :return: The entity_information of this AccountBillingPlanResponse.  # noqa: E501
        :rtype: BillingEntityInformationResponse
        """
        return self._entity_information

    @entity_information.setter
    def entity_information(self, entity_information):
        """Sets the entity_information of this AccountBillingPlanResponse.

          # noqa: E501

        :param entity_information: The entity_information of this AccountBillingPlanResponse.  # noqa: E501
        :type: BillingEntityInformationResponse
        """

        self._entity_information = entity_information

    @property
    def payment_method(self):
        """Gets the payment_method of this AccountBillingPlanResponse.  # noqa: E501

          # noqa: E501

        :return: The payment_method of this AccountBillingPlanResponse.  # noqa: E501
        :rtype: str
        """
        return self._payment_method

    @payment_method.setter
    def payment_method(self, payment_method):
        """Sets the payment_method of this AccountBillingPlanResponse.

          # noqa: E501

        :param payment_method: The payment_method of this AccountBillingPlanResponse.  # noqa: E501
        :type: str
        """

        self._payment_method = payment_method

    @property
    def payment_processor_information(self):
        """Gets the payment_processor_information of this AccountBillingPlanResponse.  # noqa: E501

        Information about the entity that processes payments for the billing plan.  # noqa: E501

        :return: The payment_processor_information of this AccountBillingPlanResponse.  # noqa: E501
        :rtype: PaymentProcessorInformation
        """
        return self._payment_processor_information

    @payment_processor_information.setter
    def payment_processor_information(self, payment_processor_information):
        """Sets the payment_processor_information of this AccountBillingPlanResponse.

        Information about the entity that processes payments for the billing plan.  # noqa: E501

        :param payment_processor_information: The payment_processor_information of this AccountBillingPlanResponse.  # noqa: E501
        :type: PaymentProcessorInformation
        """

        self._payment_processor_information = payment_processor_information

    @property
    def referral_information(self):
        """Gets the referral_information of this AccountBillingPlanResponse.  # noqa: E501

        A complex type that contains properties for entering referral and discount information.  # noqa: E501

        :return: The referral_information of this AccountBillingPlanResponse.  # noqa: E501
        :rtype: ReferralInformation
        """
        return self._referral_information

    @referral_information.setter
    def referral_information(self, referral_information):
        """Sets the referral_information of this AccountBillingPlanResponse.

        A complex type that contains properties for entering referral and discount information.  # noqa: E501

        :param referral_information: The referral_information of this AccountBillingPlanResponse.  # noqa: E501
        :type: ReferralInformation
        """

        self._referral_information = referral_information

    @property
    def successor_plans(self):
        """Gets the successor_plans of this AccountBillingPlanResponse.  # noqa: E501

          # noqa: E501

        :return: The successor_plans of this AccountBillingPlanResponse.  # noqa: E501
        :rtype: list[BillingPlan]
        """
        return self._successor_plans

    @successor_plans.setter
    def successor_plans(self, successor_plans):
        """Sets the successor_plans of this AccountBillingPlanResponse.

          # noqa: E501

        :param successor_plans: The successor_plans of this AccountBillingPlanResponse.  # noqa: E501
        :type: list[BillingPlan]
        """

        self._successor_plans = successor_plans

    @property
    def tax_exempt_id(self):
        """Gets the tax_exempt_id of this AccountBillingPlanResponse.  # noqa: E501

          # noqa: E501

        :return: The tax_exempt_id of this AccountBillingPlanResponse.  # noqa: E501
        :rtype: str
        """
        return self._tax_exempt_id

    @tax_exempt_id.setter
    def tax_exempt_id(self, tax_exempt_id):
        """Sets the tax_exempt_id of this AccountBillingPlanResponse.

          # noqa: E501

        :param tax_exempt_id: The tax_exempt_id of this AccountBillingPlanResponse.  # noqa: E501
        :type: str
        """

        self._tax_exempt_id = tax_exempt_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AccountBillingPlanResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccountBillingPlanResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AccountBillingPlanResponse):
            return True

        return self.to_dict() != other.to_dict()
