# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['energyzero']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.0.0', 'yarl>=1.6.0']

setup_kwargs = {
    'name': 'energyzero',
    'version': '0.3.1',
    'description': 'Asynchronous Python client providing energy/gas prices from EnergyZero',
    'long_description': '<!-- Header -->\n![alt Header of the EnergyZero package](https://raw.githubusercontent.com/klaasnicolaas/python-energyzero/main/assets/header_energyzero-min.png)\n\n<!-- PROJECT SHIELDS -->\n[![GitHub Release][releases-shield]][releases]\n[![Python Versions][python-versions-shield]][pypi]\n![Project Stage][project-stage-shield]\n![Project Maintenance][maintenance-shield]\n[![License][license-shield]](LICENSE)\n\n[![GitHub Activity][commits-shield]][commits-url]\n[![PyPi Downloads][downloads-shield]][downloads-url]\n[![GitHub Last Commit][last-commit-shield]][commits-url]\n[![Stargazers][stars-shield]][stars-url]\n[![Issues][issues-shield]][issues-url]\n\n[![Code Quality][code-quality-shield]][code-quality]\n[![Build Status][build-shield]][build-url]\n[![Typing Status][typing-shield]][typing-url]\n\n[![Maintainability][maintainability-shield]][maintainability-url]\n[![Code Coverage][codecov-shield]][codecov-url]\n\nAsynchronous Python client for the EnergyZero API.\n\n## About\n\nA python package with which you can retrieve the dynamic energy/gas prices from [EnergyZero][energyzero] and can therefore also be used for third parties who purchase their energy via EnergyZero, such as:\n\n- [ANWB Energie](https://www.anwb.nl/huis/energie/anwb-energie)\n- [Mijndomein Energie](https://www.mijndomein.nl/energie)\n- [Energie van Ons](https://www.energie.vanons.org)\n- [GroeneStroomLokaal](https://www.groenestroomlokaal.nl)\n\n## Installation\n\n```bash\npip install energyzero\n```\n\n## Data\n\n**note**: Currently only tested for day/tomorrow prices\n\nYou can read the following datasets with this package:\n\n### Electricity prices\n\nThe energy prices are different every hour, after 15:00 (more usually already at 14:00) the prices for the next day are published and it is therefore possible to retrieve these data.\n\n- Current/Next[x] hour electricity market price (float)\n- Average electricity price (float)\n- Lowest energy price (float)\n- Highest energy price (float)\n- Time of highest price (datetime)\n- Time of lowest price (datetime)\n- Percentage of the current price compared to the maximum price\n\n### Gas prices\n\nThe gas prices do not change per hour, but are fixed for 24 hours. Which means that from 06:00 in the morning the new rate for that day will be used.\n\n- Current/Next[x] hour gas market price (float)\n- Average gas price (float)\n- Lowest gas price (float)\n- Highest gas price (float)\n\n## Example\n\n```python\nimport asyncio\n\nfrom datetime import date\nfrom energyzero import EnergyZero\n\n\nasync def main() -> None:\n    """Show example on fetching the energy prices from EnergyZero."""\n    async with EnergyZero(incl_btw="true") as client:\n        start_date = date(2022, 12, 7)\n        end_date = date(2022, 12, 7)\n\n        energy = await client.energy_prices(start_date, end_date)\n        gas = await client.gas_prices(start_date, end_date)\n\n\nif __name__ == "__main__":\n    asyncio.run(main())\n```\n\n### Class Parameters\n\n| Parameter | value Type | Description |\n| :-------- | :--------- | :---------- |\n| `incl_btw` | str (default: **true**) | Include or exclude BTW |\n\n### Function Parameters\n\n| Parameter | value Type | Description |\n| :-------- | :--------- | :---------- |\n| `start_date` | datetime | The start date of the selected period |\n| `end_date` | datetime | The end date of the selected period |\n| `interval` | integer (default: **4**) | The interval of data return (**day**, **week**, **month**, **year**) |\n\n**Interval**\n4: Dag\n5: Maand\n6: Jaar\n9: Week\n\n## Contributing\n\nThis is an active open-source project. We are always open to people who want to\nuse the code or contribute to it.\n\nWe\'ve set up a separate document for our\n[contribution guidelines](CONTRIBUTING.md).\n\nThank you for being involved! :heart_eyes:\n\n## Setting up development environment\n\nThis Python project is fully managed using the [Poetry][poetry] dependency\nmanager.\n\nYou need at least:\n\n- Python 3.9+\n- [Poetry][poetry-install]\n\nInstall all packages, including all development requirements:\n\n```bash\npoetry install\n```\n\nPoetry creates by default an virtual environment where it installs all\nnecessary pip packages, to enter or exit the venv run the following commands:\n\n```bash\npoetry shell\nexit\n```\n\nSetup the pre-commit check, you must run this inside the virtual environment:\n\n```bash\npre-commit install\n```\n\n*Now you\'re all set to get started!*\n\nAs this repository uses the [pre-commit][pre-commit] framework, all changes\nare linted and tested with each commit. You can run all checks and tests\nmanually, using the following command:\n\n```bash\npoetry run pre-commit run --all-files\n```\n\nTo run just the Python tests:\n\n```bash\npoetry run pytest\n```\n\n## License\n\nMIT License\n\nCopyright (c) 2022 Klaas Schoute\n\nPermission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the "Software"), to deal\nin the Software without restriction, including without limitation the rights\nto use, copy, modify, merge, publish, distribute, sublicense, and/or sell\ncopies of the Software, and to permit persons to whom the Software is\nfurnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all\ncopies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\nIMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\nFITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\nAUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\nLIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\nOUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\nSOFTWARE.\n\n[energyzero]: https://www.energyzero.nl\n\n<!-- MARKDOWN LINKS & IMAGES -->\n[build-shield]: https://github.com/klaasnicolaas/python-energyzero/actions/workflows/tests.yaml/badge.svg\n[build-url]: https://github.com/klaasnicolaas/python-energyzero/actions/workflows/tests.yaml\n[code-quality-shield]: https://github.com/klaasnicolaas/python-energyzero/actions/workflows/codeql.yaml/badge.svg\n[code-quality]: https://github.com/klaasnicolaas/python-energyzero/actions/workflows/codeql.yaml\n[commits-shield]: https://img.shields.io/github/commit-activity/y/klaasnicolaas/python-energyzero.svg\n[commits-url]: https://github.com/klaasnicolaas/python-energyzero/commits/main\n[codecov-shield]: https://codecov.io/gh/klaasnicolaas/python-energyzero/branch/main/graph/badge.svg?token=29Y5JL4356\n[codecov-url]: https://codecov.io/gh/klaasnicolaas/python-energyzero\n[downloads-shield]: https://img.shields.io/pypi/dm/energyzero\n[downloads-url]: https://pypistats.org/packages/energyzero\n[issues-shield]: https://img.shields.io/github/issues/klaasnicolaas/python-energyzero.svg\n[issues-url]: https://github.com/klaasnicolaas/python-energyzero/issues\n[license-shield]: https://img.shields.io/github/license/klaasnicolaas/python-energyzero.svg\n[last-commit-shield]: https://img.shields.io/github/last-commit/klaasnicolaas/python-energyzero.svg\n[maintenance-shield]: https://img.shields.io/maintenance/yes/2022.svg\n[maintainability-shield]: https://api.codeclimate.com/v1/badges/615e7a78f1a6191d4731/maintainability\n[maintainability-url]: https://codeclimate.com/github/klaasnicolaas/python-energyzero/maintainability\n[project-stage-shield]: https://img.shields.io/badge/project%20stage-experimental-yellow.svg\n[pypi]: https://pypi.org/project/energyzero/\n[python-versions-shield]: https://img.shields.io/pypi/pyversions/energyzero\n[typing-shield]: https://github.com/klaasnicolaas/python-energyzero/actions/workflows/typing.yaml/badge.svg\n[typing-url]: https://github.com/klaasnicolaas/python-energyzero/actions/workflows/typing.yaml\n[releases-shield]: https://img.shields.io/github/release/klaasnicolaas/python-energyzero.svg\n[releases]: https://github.com/klaasnicolaas/python-energyzero/releases\n[stars-shield]: https://img.shields.io/github/stars/klaasnicolaas/python-energyzero.svg\n[stars-url]: https://github.com/klaasnicolaas/python-energyzero/stargazers\n\n[poetry-install]: https://python-poetry.org/docs/#installation\n[poetry]: https://python-poetry.org\n[pre-commit]: https://pre-commit.com\n',
    'author': 'Klaas Schoute',
    'author_email': 'hello@student-techlife.com',
    'maintainer': 'Klaas Schoute',
    'maintainer_email': 'hello@student-techlife.com',
    'url': 'https://github.com/klaasnicolaas/python-energyzero',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
