import numpy as np

UnitList_Base = [
    # order
    (1.0, [1,0,0,0,0,0,0,0,0], '1e',  'power of ten'),
    # physical units
    (1.0, [0,1,0,0,0,0,0,0,0], 'm',   'meter'),
    (1.0, [0,0,1,0,0,0,0,0,0], 'g',   'gram'),
    (1.0, [0,0,0,1,0,0,0,0,0], 's',   'second'),
    (1.0, [0,0,0,0,1,0,0,0,0], 'K',   'kelvin'),
    (1.0, [0,0,0,0,0,1,0,0,0], 'C',   'coulomb'),
    (1.0, [0,0,0,0,0,0,1,0,0], 'cd',  'candela'),
    # numerical units                             
    (1.0, [0,0,0,0,0,0,0,1,0], 'mol', 'mole'),
    (1.0, [0,0,0,0,0,0,0,0,1], 'rad', 'radian'),
]

UnitList_Prefixes = [
    (1.0,        [ 24, 0, 0, 0, 0, 0, 0, 0, 0], 'Y',       '1e24',  'yotta'), 
    (1.0,        [ 21, 0, 0, 0, 0, 0, 0, 0, 0], 'Z',       '1e21',  'zetta'), 
    (1.0,        [ 18, 0, 0, 0, 0, 0, 0, 0, 0], 'E',       '1e18',  'exa'  ), 
    (1.0,        [ 15, 0, 0, 0, 0, 0, 0, 0, 0], 'P',       '1e15',  'peta' ), 
    (1.0,        [ 12, 0, 0, 0, 0, 0, 0, 0, 0], 'T',       '1e12',  'tera' ), 
    (1.0,        [  9, 0, 0, 0, 0, 0, 0, 0, 0], 'G',       '1e9',   'giga' ), 
    (1.0,        [  6, 0, 0, 0, 0, 0, 0, 0, 0], 'M',       '1e6',   'mega' ), 
    (1.0,        [  3, 0, 0, 0, 0, 0, 0, 0, 0], 'k',       '1e3',   'kilo' ), 
    (1.0,        [  2, 0, 0, 0, 0, 0, 0, 0, 0], 'h',       '1e2',   'hecto'), 
    (1.0,        [  1, 0, 0, 0, 0, 0, 0, 0, 0], 'da',      '1e1',   'deka' ), 
    (1.0,        [ -1, 0, 0, 0, 0, 0, 0, 0, 0], 'd',       '1e-1',  'deci' ), 
    (1.0,        [ -2, 0, 0, 0, 0, 0, 0, 0, 0], 'c',       '1e-2',  'centi'), 
    (1.0,        [ -3, 0, 0, 0, 0, 0, 0, 0, 0], 'm',       '1e-3',  'milli'), 
    (1.0,        [ -6, 0, 0, 0, 0, 0, 0, 0, 0], 'u',       '1e-6',  'micro'), 
    (1.0,        [ -9, 0, 0, 0, 0, 0, 0, 0, 0], 'n',       '1e-9',  'nano' ), 
    (1.0,        [-12, 0, 0, 0, 0, 0, 0, 0, 0], 'p',       '1e-12', 'pico' ), 
    (1.0,        [-15, 0, 0, 0, 0, 0, 0, 0, 0], 'f',       '1e-15', 'femto'), 
    (1.0,        [-18, 0, 0, 0, 0, 0, 0, 0, 0], 'a',       '1e-18', 'atto' ), 
    (1.0,        [-21, 0, 0, 0, 0, 0, 0, 0, 0], 'z',       '1e-21', 'zepto'), 
    (1.0,        [-24, 0, 0, 0, 0, 0, 0, 0, 0], 'y',       '1e-24', 'yocto'), 
]

UnitList_Derivates = [ # m,g,s,K,C,cd,mol,rad,10
    # SI units
    (1.0,        [  0, 0, 0, 0, 0, 0, 0, 0, 2], 'sr',      'rad2',             'steradian'),
    (1.0,        [  0, 0, 0,-1, 0, 0, 0, 0, 0], 'Hz',      's-1',              'hertz'    ),
    (1.0,        [  3, 1, 1,-2, 0, 0, 0, 0, 0], 'N',       'kg*m/s2',          'newton'   ),
    (1.0,        [  3,-1, 1,-2, 0, 0, 0, 0, 0], 'Pa',      'N/m2',             'pascal'   ),
    (1.0,        [  3, 2, 1,-2, 0, 0, 0, 0, 0], 'J',       'N*m',              'joule'    ),
    (1.0,        [  3, 2, 1,-3, 0, 0, 0, 0, 0], 'W',       'J/s',              'watt'     ),
    (1.0,        [  0, 0, 0,-1, 0, 1, 0, 0, 0], 'A',       'C/s',              'ampere'   ),
    (1.0,        [  3, 2, 1,-2, 0,-1, 0, 0, 0], 'V',       'J/C',              'volt'     ),
    (1.0,        [ -3,-2,-1, 2, 0, 2, 0, 0, 0], 'F',       'C/V',              'farad'    ),
    (1.0,        [  3, 2, 1,-1, 0,-2, 0, 0, 0], 'Ohm',     'V/A',              'ohm'      ),
    (1.0,        [ -3,-2,-1, 1, 0, 2, 0, 0, 0], 'S',       'Ohm-1',            'siemens'  ),
    (1.0,        [  3, 2, 1,-1, 0,-1, 0, 0, 0], 'Wb',      'V*s',              'weber'    ),
    (1.0,        [  3, 0, 1,-1, 0,-1, 0, 0, 0], 'T',       'Wb/m2',            'tesla'    ),
    (1.0,        [  3, 2, 1, 0, 0,-2, 0, 0, 0], 'H',       'Wb/A',             'henry'    ),
    (1.0,        [  0, 0, 0, 0, 0, 0, 1, 0, 2], 'lm',      'cd*sr',            'lumen'    ),
    (1.0,        [  0,-2, 0, 0, 0, 0, 1, 0, 2], 'lx',      'lm/m2',            'lux'      ),
    (1.0,        [  0, 0, 0,-1, 0, 0, 0, 0, 0], 'Bq',      's-1',              'becquerel'),
    (1.0,        [  0, 2, 0,-2, 0, 0, 0, 0, 0], 'Gy',      'J/kg',             'gray'     ),
    (1.0,        [  0, 2, 0,-2, 0, 0, 0, 0, 0], 'Sv',      'J/kg',             'sivert'   ),
    # CGS units                                                                         
    (1.0,        [ -2, 1, 1,-2, 0, 0, 0, 0, 0], 'dyn',     'g*cm/s2',          'dyne'     ),
    (1.0,        [ -4, 2, 1,-2, 0, 0, 0, 0, 0], 'erg',     'dyn*cm',           'erg'      ),
    (1.0,        [ -1, 0, 1,-1, 0,-1, 0, 0, 0], 'G',       '1e-4*T',           'Gauss'    ),
    # other derived units                              
    (1.745329,   [ -2, 0, 0, 0, 0, 0, 0, 0, 1], 'deg',     '2*[pi]*rad/360',   'angle degree'  ),
    (2.908882,   [ -4, 0, 0, 0, 0, 0, 0, 0, 1], "'",       'deg/60',           'angle minute'  ),
    (4.848137,   [ -6, 0, 0, 0, 0, 0, 0, 0, 1], "''",      "'/60",             'angle second'  ),
    (1,          [ -3, 3, 0, 0, 0, 0, 0, 0, 0], 'l',       'dm3',              'liter'         ),
    (1,          [ -3, 3, 0, 0, 0, 0, 0, 0, 0], 'L',       'l',                'liter'         ),
    (1,          [  2, 2, 0, 0, 0, 0, 0, 0, 0], 'ar',      '100*m2',           'are'           ),
    (6.0,        [  1, 0, 0, 1, 0, 0, 0, 0, 0], 'min',     '60*s',             'minute'        ),
    (3.6,        [  3, 0, 0, 1, 0, 0, 0, 0, 0], 'h',       '60*min',           'hour'          ),
    (8.64,       [  4, 0, 0, 1, 0, 0, 0, 0, 0], 'd',       '24*h',             'day'           ),
    (3.155693,   [  7, 0, 0, 1, 0, 0, 0, 0, 0], 'a_t',     '365.24219*d',      'tropical year' ),
    (3.155760,   [  7, 0, 0, 1, 0, 0, 0, 0, 0], 'a_j',     '365.25*d',         'Julian year'   ),
    (3.155695,   [  7, 0, 0, 1, 0, 0, 0, 0, 0], 'a_g',     '365.2425*d',       'Gregorian year'),
    (3.155760,   [  7, 0, 0, 1, 0, 0, 0, 0, 0], 'a',       'a_j',              'year'          ),
    (1.60217733, [-16, 2, 1,-2, 0, 0, 0, 0, 0], 'eV',      '[e]*V',            'electronvolt'  ),
    (1.49597870, [ 11, 1, 0, 0, 0, 0, 0, 0, 0], 'au',      '149597.870691*Mm', 'astr. unit'    ),
    (1.49597870, [ 11, 1, 0, 0, 0, 0, 0, 0, 0], 'AU',      'au',               'astr. unit'    ),
    # natural units
    (2.99792458, [  8, 1, 0,-1, 0, 0, 0, 0, 0], '[c]',     '299792458*m/s',          'velocity of light'),
    (6.626076,   [-31, 2, 1,-1, 0, 0, 0, 0, 0], '[h]',     '6.6260755e-34*J*s',      'Planck const.'),
    (1.380658,   [-20, 2, 1,-2,-1, 0, 0, 0, 0], '[k]',     '1.380658e-23*J/K',       'Boltzmann const.'),
    (8.854188,   [-15,-3,-1, 2, 0, 2, 0, 0, 0], '[eps_0]', '8.854187817e-12*F/m',    'permit. of vac.'),
    (1.256637,   [ -3, 1, 1, 0, 0,-2, 0, 0, 0], '[mu_0]',  '4*[pi]*1e-7*N/A2',       'permeab. of vac.'),
    (1.60217733, [-19, 0, 0, 0, 0, 1, 0, 0, 0], '[e]',     '1.60217733e-19*C',       'elem. charge'),
    (9.109390,   [-28, 0, 1, 0, 0, 0, 0, 0, 0], '[m_e]',   '9.1093897e-28*g',        'electron mass'),
    (1.672623,   [-24, 0, 1, 0, 0, 0, 0, 0, 0], '[m_p]',   '1.6726231e-24*g',        'proton mass'),       
    (6.672590,   [-14, 3,-1,-2, 0, 0, 0, 0, 0], '[G]',     '6.67259e-11*m3/(kg*s2)', 'grav. const.'),
    (9.806650,   [  0, 1, 0,-2, 0, 0, 0, 0, 0], '[g]',     '9.80665*m/s2',           'grav. accel.'),
    (1.013250,   [  8,-1, 1,-2, 0, 0, 0, 0, 0], 'atm',     '101325*Pa',              'atm. pressure'),
    (9.460730,   [ 15, 1, 0, 0, 0, 0, 0, 0, 0], 'ly',      '[c]*a_j',                'light-year'),   
    # dimensionless units
    (np.pi,      [  0, 0, 0, 0, 0, 0, 0, 0, 0], '[pi]',    '3.141593',    'pi'),
    (np.e,       [  0, 0, 0, 0, 0, 0, 0, 0, 0], '[euler]', '2.718282',    "Euler's num."),
    (6.0221367,  [ 23, 0, 0, 0, 0, 0, 0, 0, 0], '[N_A]',   '6.022137e23', "Avogadro's num."),
    (1,          [ -2, 0, 0, 0, 0, 0, 0, 0, 0], '%',       '1e-2',        'percent'),
    (1,          [ -3, 0, 0, 0, 0, 0, 0, 0, 0], '[ppth]',  '1e-3',        'promile'),               
]

def Convert_Arbitrary(unit1, unit2):
    conv = "_".join([unit1.symbol_base, unit2.symbol_base])
    if conv=="Cel_K":
        value1 = unit1.number()
        value2 = (value1 + 273.15) / unit2.number()
    elif conv=="K_Cel":
        value1 = unit1.number()
        value2 = (value1 - 273.15) / unit2.number()
    if value2:
        unit2.num = value2
        unit2.base[0] = 0
        unit2._rebase()
        return unit2
    else:
        raise Exception(f"No conversion of arbitrary unit '{unit1.symbol}' to '{unit2.symbol}' was found.")
        
UnitList_Arbitrary = [
    ([0,0,0,0,1,0,0,0,0], 'Cel', 'Degree Celsius'),
]
