# Generated by Django 3.2.7 on 2021-09-24 08:05

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.crypto
import textrank.validators


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('textrank', '0004_alter_group_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Topic',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='создан')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='обновлён')),
                ('name', models.CharField(error_messages={'unique': 'Такое название уже существует.'}, help_text='Обязательно. 150 символов и менее.', max_length=150, unique=True, verbose_name='название')),
                ('description', models.TextField(blank=True, db_index=True, verbose_name='описание')),
                ('code', models.CharField(default=django.utils.crypto.get_random_string, error_messages={'unique': 'Такой код уже существует.'}, help_text='Обязательно. 32 символа и менее, уникальное значение.', max_length=32, unique=True, verbose_name='код раздела')),
                ('is_active', models.BooleanField(db_index=True, default=True, help_text='Отключите, если раздел не используется для анализа.', verbose_name='активный')),
            ],
            options={
                'verbose_name': 'раздел ранжирования',
                'verbose_name_plural': 'разделы ранжирования',
                'ordering': ('name',),
            },
        ),
        migrations.AddField(
            model_name='group',
            name='topic',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='textrank.topic', verbose_name='раздел'),
        ),
        migrations.AddField(
            model_name='keyword',
            name='topic',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='textrank.topic', verbose_name='раздел'),
        ),
        migrations.AlterField(
            model_name='group',
            name='code',
            field=models.CharField(default=django.utils.crypto.get_random_string, error_messages={'unique': 'Такой код уже существует.'}, help_text='Обязательно. 32 символа и менее, уникальное значение.', max_length=32, verbose_name='код группы'),
        ),
        migrations.AlterField(
            model_name='group',
            name='name',
            field=models.CharField(error_messages={'unique': 'Такое название уже существует.'}, help_text='Обязательно. 150 символов и менее.', max_length=150, verbose_name='название'),
        ),
        migrations.AlterField(
            model_name='keyword',
            name='word',
            field=models.CharField(error_messages={'unique': 'Такое слово (сочетание) уже существует.'}, help_text='Обязательно. 100 символов и менее. Значение может содержать только буквы в нижнем регистре, цифры, символы дефиса, подчёркивания или знак +, а также начинаться и заканчиваться словом. Варианты: Ключевое слово (word1), цепочка слов (word1_word2_word3) или покрытие словами (word1+word2+word3).', max_length=100, validators=[textrank.validators.UnicodeKeywordValidator()], verbose_name='слово'),
        ),
        migrations.AddConstraint(
            model_name='group',
            constraint=models.UniqueConstraint(condition=models.Q(('topic__isnull', True)), fields=('name',), name='group_name_default_unique'),
        ),
        migrations.AddConstraint(
            model_name='group',
            constraint=models.UniqueConstraint(condition=models.Q(('topic__isnull', False)), fields=('name', 'topic'), name='group_name_topic_unique'),
        ),
        migrations.AddConstraint(
            model_name='group',
            constraint=models.UniqueConstraint(condition=models.Q(('topic__isnull', True)), fields=('code',), name='group_code_default_unique'),
        ),
        migrations.AddConstraint(
            model_name='group',
            constraint=models.UniqueConstraint(condition=models.Q(('topic__isnull', False)), fields=('code', 'topic'), name='group_code_topic_unique'),
        ),
        migrations.AddConstraint(
            model_name='keyword',
            constraint=models.UniqueConstraint(condition=models.Q(('topic__isnull', True)), fields=('word',), name='keyword_default_unique'),
        ),
        migrations.AddConstraint(
            model_name='keyword',
            constraint=models.UniqueConstraint(condition=models.Q(('topic__isnull', False)), fields=('word', 'topic'), name='keyword_topic_unique'),
        ),
        migrations.AddField(
            model_name='topic',
            name='last_editor',
            field=models.ForeignKey(blank=True, editable=False, null=True, on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL, verbose_name='последний редактор'),
        ),
    ]
