# Do not edit this file, please run `Rscript scripts/update_bootswatch.R`

"""
Targeted theme methods for all Bootswatch themes.
"""


from ._get_theme import get_theme as _get_theme


def cerulean():
    """
    To see a live demo of the cerulean Bootswatch theme, visit [https://bootswatch.com/cerulean/](https://bootswatch.com/cerulean/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (cerulean) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.cerulean(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("cerulean")


def cosmo():
    """
    To see a live demo of the cosmo Bootswatch theme, visit [https://bootswatch.com/cosmo/](https://bootswatch.com/cosmo/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (cosmo) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.cosmo(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("cosmo")


def cyborg():
    """
    To see a live demo of the cyborg Bootswatch theme, visit [https://bootswatch.com/cyborg/](https://bootswatch.com/cyborg/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (cyborg) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.cyborg(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("cyborg")


def darkly():
    """
    To see a live demo of the darkly Bootswatch theme, visit [https://bootswatch.com/darkly/](https://bootswatch.com/darkly/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (darkly) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.darkly(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("darkly")


def flatly():
    """
    To see a live demo of the flatly Bootswatch theme, visit [https://bootswatch.com/flatly/](https://bootswatch.com/flatly/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (flatly) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.flatly(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("flatly")


def journal():
    """
    To see a live demo of the journal Bootswatch theme, visit [https://bootswatch.com/journal/](https://bootswatch.com/journal/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (journal) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.journal(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("journal")


def litera():
    """
    To see a live demo of the litera Bootswatch theme, visit [https://bootswatch.com/litera/](https://bootswatch.com/litera/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (litera) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.litera(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("litera")


def lumen():
    """
    To see a live demo of the lumen Bootswatch theme, visit [https://bootswatch.com/lumen/](https://bootswatch.com/lumen/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (lumen) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.lumen(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("lumen")


def lux():
    """
    To see a live demo of the lux Bootswatch theme, visit [https://bootswatch.com/lux/](https://bootswatch.com/lux/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (lux) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.lux(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("lux")


def materia():
    """
    To see a live demo of the materia Bootswatch theme, visit [https://bootswatch.com/materia/](https://bootswatch.com/materia/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (materia) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.materia(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("materia")


def minty():
    """
    To see a live demo of the minty Bootswatch theme, visit [https://bootswatch.com/minty/](https://bootswatch.com/minty/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (minty) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.minty(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("minty")


def morph():
    """
    To see a live demo of the morph Bootswatch theme, visit [https://bootswatch.com/morph/](https://bootswatch.com/morph/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (morph) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.morph(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("morph")


def pulse():
    """
    To see a live demo of the pulse Bootswatch theme, visit [https://bootswatch.com/pulse/](https://bootswatch.com/pulse/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (pulse) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.pulse(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("pulse")


def quartz():
    """
    To see a live demo of the quartz Bootswatch theme, visit [https://bootswatch.com/quartz/](https://bootswatch.com/quartz/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (quartz) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.quartz(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("quartz")


def sandstone():
    """
    To see a live demo of the sandstone Bootswatch theme, visit [https://bootswatch.com/sandstone/](https://bootswatch.com/sandstone/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (sandstone) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.sandstone(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("sandstone")


def simplex():
    """
    To see a live demo of the simplex Bootswatch theme, visit [https://bootswatch.com/simplex/](https://bootswatch.com/simplex/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (simplex) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.simplex(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("simplex")


def sketchy():
    """
    To see a live demo of the sketchy Bootswatch theme, visit [https://bootswatch.com/sketchy/](https://bootswatch.com/sketchy/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (sketchy) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.sketchy(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("sketchy")


def slate():
    """
    To see a live demo of the slate Bootswatch theme, visit [https://bootswatch.com/slate/](https://bootswatch.com/slate/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (slate) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.slate(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("slate")


def solar():
    """
    To see a live demo of the solar Bootswatch theme, visit [https://bootswatch.com/solar/](https://bootswatch.com/solar/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (solar) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.solar(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("solar")


def spacelab():
    """
    To see a live demo of the spacelab Bootswatch theme, visit [https://bootswatch.com/spacelab/](https://bootswatch.com/spacelab/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (spacelab) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.spacelab(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("spacelab")


def superhero():
    """
    To see a live demo of the superhero Bootswatch theme, visit [https://bootswatch.com/superhero/](https://bootswatch.com/superhero/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (superhero) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.superhero(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("superhero")


def united():
    """
    To see a live demo of the united Bootswatch theme, visit [https://bootswatch.com/united/](https://bootswatch.com/united/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (united) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.united(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("united")


def vapor():
    """
    To see a live demo of the vapor Bootswatch theme, visit [https://bootswatch.com/vapor/](https://bootswatch.com/vapor/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (vapor) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.vapor(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("vapor")


def yeti():
    """
    To see a live demo of the yeti Bootswatch theme, visit [https://bootswatch.com/yeti/](https://bootswatch.com/yeti/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (yeti) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.yeti(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("yeti")


def zephyr():
    """
    To see a live demo of the zephyr Bootswatch theme, visit [https://bootswatch.com/zephyr/](https://bootswatch.com/zephyr/).

    Returns
    -------
    list[htmltools.HTMLDependency]
        List of HTMLDependency objects that create a Bootswatch (zephyr) and Bootstrap 5 theme.

    Examples
    --------
    ```{shinylive-python}
    #| standalone: true
    #| components: [editor, viewer]
    #| layout: vertical
    ## file: app.py
    # File: app.py
    from shiny import App, Inputs, Outputs, Session, render, ui

    import shinyswatch

    app_ui = ui.page_fluid(
        # Theme code - start
        shinyswatch.theme.zephyr(),
        # Theme code - end
        ui.input_slider("num", "Number:", min=10, max=100, value=30),
        ui.output_text_verbatim("slider_val"),
    )


    def server(input: Inputs, output: Outputs, session: Session):
        @output
        @render.text
        def slider_val():
            return f"{input.num()}"


    app = App(app_ui, server)

    ## file: requirements.txt
    shiny
    shinyswatch

    ```
    """

    return _get_theme("zephyr")
