import pyeccodes.accessors as _


def load(h):

    h.add(_.Constant('GRIBEXSection1Problem', (80 - _.Get('section1Length'))))
    h.add(_.Transient('localFlag', 1))
    _.Template('grib1/mars_labeling.def').load(h)
    h.add(_.Unsigned('perturbationNumber', 2))
    h.add(_.Unsigned('systemNumber', 2))
    h.add(_.Unsigned('methodNumber', 2))
    h.add(_.Unsigned('verifyingMonth', 4))
    h.add(_.G1end_of_interval_monthly('endOfInterval', _.Get('verifyingMonth')))
    h.add(_.Vector('yearOfEndOfOverallTimeInterval', _.Get('endOfInterval'), 0))
    h.add(_.Vector('monthOfEndOfOverallTimeInterval', _.Get('endOfInterval'), 1))
    h.add(_.Vector('dayOfEndOfOverallTimeInterval', _.Get('endOfInterval'), 2))
    h.add(_.Vector('hourOfEndOfOverallTimeInterval', _.Get('endOfInterval'), 3))
    h.add(_.Vector('minuteOfEndOfOverallTimeInterval', _.Get('endOfInterval'), 4))
    h.add(_.Vector('secondOfEndOfOverallTimeInterval', _.Get('endOfInterval'), 5))
    h.add(_.Transient('hourOfEndOfOverallTimeInterval', 23))
    h.add(_.Transient('minuteOfEndOfOverallTimeInterval', 59))
    h.add(_.Transient('secondOfEndOfOverallTimeInterval', 59))
    h.add(_.Transient('indicatorOfUnitForTimeRange', 3))
    h.add(_.Transient('lengthOfTimeRange', 1))
    h.add(_.Unsigned('averagingPeriod', 1))
    h.add(_.Transient('typeOfStatisticalProcessing', 0))
    h.add(_.Transient('indicatorOfUnitForTimeIncrement', 1))
    h.add(_.Transient('timeIncrement', _.Get('averagingPeriod')))
    h.add(_.Unsigned('forecastMonth', 2))
    h.add(_.Transient('forecastTime', (_.Get('forecastMonth') - 1)))
    h.add(_.Transient('typeOfTimeIncrement', 3))
    h.add(_.G1forecastmonth('marsForecastMonth', _.Get('verifyingMonth'), _.Get('dataDate'), _.Get('day'), _.Get('hour'), _.Get('forecastMonth'), _.Get('one')))
    h.alias('origin', 'centre')
    h.alias('number', 'perturbationNumber')
    h.alias('system', 'systemNumber')
    h.alias('method', 'methodNumber')
    h.add(_.Unsigned('numberOfForecastsInEnsemble', 2))
    h.alias('totalNumber', 'numberOfForecastsInEnsemble')
    h.add(_.Pad('padding_loc16_1', 16))
