import pyeccodes.accessors as _


def load(h):

    h.add(_.Constant('gridDefinitionTemplateNumber', 20))
    h.add(_.Unsigned('Nx', 2))
    h.alias('Ni', 'Nx')
    h.alias('numberOfPointsAlongXAxis', 'Nx')
    h.alias('geography.Nx', 'Nx')
    h.add(_.Unsigned('Ny', 2))
    h.alias('Nj', 'Ny')
    h.alias('numberOfPointsAlongYAxis', 'Ny')
    h.alias('geography.Ny', 'Ny')
    h.add(_.Signed('latitudeOfFirstGridPoint', 3))
    h.add(_.Scale('latitudeOfFirstGridPointInDegrees', _.Get('latitudeOfFirstGridPoint'), _.Get('oneConstant'), _.Get('grib1divider'), _.Get('truncateDegrees')))
    h.alias('geography.latitudeOfFirstGridPointInDegrees', 'latitudeOfFirstGridPointInDegrees')
    h.alias('La1', 'latitudeOfFirstGridPoint')
    h.add(_.Signed('longitudeOfFirstGridPoint', 3))
    h.add(_.Scale('longitudeOfFirstGridPointInDegrees', _.Get('longitudeOfFirstGridPoint'), _.Get('oneConstant'), _.Get('grib1divider'), _.Get('truncateDegrees')))
    h.alias('geography.longitudeOfFirstGridPointInDegrees', 'longitudeOfFirstGridPointInDegrees')
    h.alias('Lo1', 'longitudeOfFirstGridPoint')
    h.add(_.Codeflag('resolutionAndComponentFlags', 1, "grib1/7.table"))
    h.add(_.Bit('ijDirectionIncrementGiven', _.Get('resolutionAndComponentFlags'), 7))
    h.alias('iDirectionIncrementGiven', 'ijDirectionIncrementGiven')
    h.alias('jDirectionIncrementGiven', 'ijDirectionIncrementGiven')
    h.alias('DiGiven', 'ijDirectionIncrementGiven')
    h.alias('DjGiven', 'ijDirectionIncrementGiven')
    h.add(_.Bit('earthIsOblate', _.Get('resolutionAndComponentFlags'), 6))

    if h.get_l('earthIsOblate'):
        h.add(_.Transient('earthMajorAxis', 6.37816e+06))
        h.add(_.Transient('earthMinorAxis', 6.35678e+06))
        h.alias('earthMajorAxisInMetres', 'earthMajorAxis')
        h.alias('earthMinorAxisInMetres', 'earthMinorAxis')

    h.add(_.Bit('resolutionAndComponentFlags3', _.Get('resolutionAndComponentFlags'), 5))
    h.add(_.Bit('resolutionAndComponentFlags4', _.Get('resolutionAndComponentFlags'), 4))
    h.add(_.Bit('uvRelativeToGrid', _.Get('resolutionAndComponentFlags'), 3))
    h.add(_.Bit('resolutionAndComponentFlags6', _.Get('resolutionAndComponentFlags'), 2))
    h.add(_.Bit('resolutionAndComponentFlags7', _.Get('resolutionAndComponentFlags'), 1))
    h.add(_.Bit('resolutionAndComponentFlags8', _.Get('resolutionAndComponentFlags'), 0))
    h.add(_.Signed('orientationOfTheGrid', 3))
    h.add(_.Scale('orientationOfTheGridInDegrees', _.Get('orientationOfTheGrid'), _.Get('oneConstant'), _.Get('grib1divider'), _.Get('truncateDegrees')))
    h.alias('geography.orientationOfTheGridInDegrees', 'orientationOfTheGridInDegrees')
    h.alias('LoV', 'orientationOfTheGrid')
    h.add(_.Unsigned('DxInMetres', 3))
    h.alias('xDirectionGridLengthInMetres', 'DxInMetres')
    h.alias('Dx', 'DxInMetres')
    h.alias('geography.DxInMetres', 'DxInMetres')
    h.alias('Di', 'DxInMetres')
    h.add(_.Unsigned('DyInMetres', 3))
    h.alias('yDirectionGridLengthInMetres', 'DyInMetres')
    h.alias('Dy', 'DyInMetres')
    h.alias('Dj', 'DyInMetres')
    h.alias('geography.DyInMetres', 'DyInMetres')
    h.add(_.Constant('latitudeWhereDxAndDyAreSpecifiedInDegrees', 60))
    h.add(_.Constant('LaDInDegrees', 60))
    h.alias('geography.LaDInDegrees', 'LaDInDegrees')
    h.add(_.Unsigned('projectionCentreFlag', 1))
    h.alias('projectionCenterFlag', 'projectionCentreFlag')
    h.add(_.Bit('southPoleOnProjectionPlane', _.Get('projectionCentreFlag'), 7))
    h.alias('yFirst', 'latitudeOfFirstGridPointInDegrees')
    h.alias('xFirst', 'longitudeOfFirstGridPointInDegrees')
    h.add(_.Codeflag('scanningMode', 1, "grib1/8.table"))
    h.add(_.Bit('iScansNegatively', _.Get('scanningMode'), 7))
    h.add(_.Bit('jScansPositively', _.Get('scanningMode'), 6))
    h.add(_.Bit('jPointsAreConsecutive', _.Get('scanningMode'), 5))
    h.add(_.Constant('alternativeRowScanning', 0))
    h.add(_.Transient('iScansPositively', not (_.Get('iScansNegatively'))))
    h.alias('geography.iScansNegatively', 'iScansNegatively')
    h.alias('geography.jScansPositively', 'jScansPositively')
    h.alias('geography.jPointsAreConsecutive', 'jPointsAreConsecutive')
    h.add(_.Bit('scanningMode4', _.Get('scanningMode'), 4))
    h.add(_.Bit('scanningMode5', _.Get('scanningMode'), 3))
    h.add(_.Bit('scanningMode6', _.Get('scanningMode'), 2))
    h.add(_.Bit('scanningMode7', _.Get('scanningMode'), 1))
    h.add(_.Bit('scanningMode8', _.Get('scanningMode'), 0))
    h.add(_.Change_scanning_direction('swapScanningX', _.Get('values'), _.Get('Ni'), _.Get('Nj'), _.Get('iScansNegatively'), _.Get('jScansPositively'), _.Get('xFirst'), _.Get('xLast'), _.Get('x')))
    h.alias('swapScanningLon', 'swapScanningX')
    h.add(_.Change_scanning_direction('swapScanningY', _.Get('values'), _.Get('Ni'), _.Get('Nj'), _.Get('iScansNegatively'), _.Get('jScansPositively'), _.Get('yFirst'), _.Get('yLast'), _.Get('y')))
    h.alias('swapScanningLat', 'swapScanningY')

    if h.get_l('jPointsAreConsecutive'):
        h.alias('numberOfRows', 'Ni')
        h.alias('numberOfColumns', 'Nj')
    else:
        h.alias('numberOfRows', 'Nj')
        h.alias('numberOfColumns', 'Ni')

    h.add(_.Pad('padding_grid5_1', 4))
    h.add(_.Number_of_points('numberOfDataPoints', _.Get('Nx'), _.Get('Ny'), _.Get('PLPresent'), _.Get('pl')))
    h.alias('numberOfPoints', 'numberOfDataPoints')
    h.add(_.Number_of_values('numberOfValues', _.Get('values'), _.Get('bitsPerValue'), _.Get('numberOfDataPoints'), _.Get('bitmapPresent'), _.Get('bitmap'), _.Get('numberOfCodedValues')))
    h.add(_.Iterator('ITERATOR', _.Get('polar_stereographic'), _.Get('numberOfPoints'), _.Get('missingValue'), _.Get('values'), _.Get('radius'), _.Get('Nx'), _.Get('Ny'), _.Get('latitudeOfFirstGridPointInDegrees'), _.Get('longitudeOfFirstGridPointInDegrees'), _.Get('southPoleOnProjectionPlane'), _.Get('orientationOfTheGridInDegrees'), _.Get('LaDInDegrees'), _.Get('Dx'), _.Get('Dy'), _.Get('iScansNegatively'), _.Get('jScansPositively'), _.Get('jPointsAreConsecutive'), _.Get('alternativeRowScanning')))
    h.add(_.Nearest('NEAREST', _.Get('polar_stereographic'), _.Get('values'), _.Get('radius'), _.Get('Nx'), _.Get('Ny')))
    h.add(_.Latlonvalues('latLonValues', _.Get('values')))
    h.alias('latitudeLongitudeValues', 'latLonValues')
    h.add(_.Latitudes('latitudes', _.Get('values'), 0))
    h.add(_.Longitudes('longitudes', _.Get('values'), 0))
    h.add(_.Latitudes('distinctLatitudes', _.Get('values'), 1))
    h.add(_.Longitudes('distinctLongitudes', _.Get('values'), 1))
