"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafwebaclToApiGateway = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
// Imports
const constructs_1 = require("constructs");
const waf = require("aws-cdk-lib/aws-wafv2");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * @summary The WafwebaclToApiGateway class.
 */
class WafwebaclToApiGateway extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the WafwebaclToApiGateway class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {WafwebaclToApiGatewayProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Build the Web ACL
        this.webacl = defaults.buildWebacl(this, 'REGIONAL', {
            existingWebaclObj: props.existingWebaclObj,
            webaclProps: props.webaclProps,
        });
        const resourceArn = `arn:aws:apigateway:${aws_cdk_lib_1.Stack.of(scope).region}::/restapis/${props.existingApiGatewayInterface.restApiId}/stages/${props.existingApiGatewayInterface.deploymentStage.stageName}`;
        // Setup the Web ACL Association
        new waf.CfnWebACLAssociation(scope, `${id}-WebACLAssociation`, {
            webAclArn: this.webacl.attrArn,
            resourceArn
        });
        this.apiGateway = props.existingApiGatewayInterface;
    }
}
exports.WafwebaclToApiGateway = WafwebaclToApiGateway;
_a = JSII_RTTI_SYMBOL_1;
WafwebaclToApiGateway[_a] = { fqn: "@aws-solutions-constructs/aws-wafwebacl-apigateway.WafwebaclToApiGateway", version: "2.27.0" };
//# sourceMappingURL=data:application/json;base64,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