"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceType = exports.InstanceSize = exports.InstanceArchitecture = exports.InstanceClass = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * What class and generation of instance to use
 *
 * We have both symbolic and concrete enums for every type.
 *
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 */
var InstanceClass;
(function (InstanceClass) {
    /**
     * Standard instances, 3rd generation
     */
    InstanceClass["STANDARD3"] = "standard3";
    /**
     * Standard instances, 3rd generation
     */
    InstanceClass["M3"] = "m3";
    /**
     * Standard instances, 4th generation
     */
    InstanceClass["STANDARD4"] = "standard4";
    /**
     * Standard instances, 4th generation
     */
    InstanceClass["M4"] = "m4";
    /**
     * Standard instances, 5th generation
     */
    InstanceClass["STANDARD5"] = "standard5";
    /**
     * Standard instances, 5th generation
     */
    InstanceClass["M5"] = "m5";
    /**
     * Standard instances with local NVME drive, 5th generation
     */
    InstanceClass["STANDARD5_NVME_DRIVE"] = "standard5-nvme-drive";
    /**
     * Standard instances with local NVME drive, 5th generation
     */
    InstanceClass["M5D"] = "m5d";
    /**
     * Standard instances based on AMD EPYC, 5th generation
     */
    InstanceClass["STANDARD5_AMD"] = "standard5-amd";
    /**
     * Standard instances based on AMD EPYC, 5th generation
     */
    InstanceClass["M5A"] = "m5a";
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["STANDARD5_AMD_NVME_DRIVE"] = "standard5-amd-nvme-drive";
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["M5AD"] = "m5ad";
    /**
     * Standard instances for high performance computing, 5th generation
     */
    InstanceClass["STANDARD5_HIGH_PERFORMANCE"] = "standard5-high-performance";
    /**
     * Standard instances for high performance computing, 5th generation
     */
    InstanceClass["M5N"] = "m5n";
    /**
     * Standard instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["STANDARD5_NVME_DRIVE_HIGH_PERFORMANCE"] = "standard5-nvme-drive-high-performance";
    /**
     * Standard instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["M5DN"] = "m5dn";
    /**
     * Standard instances with high memory and compute capacity based on Intel Xeon Scalable (Cascade Lake) processors, 5nd generation
     */
    InstanceClass["STANDARD5_HIGH_COMPUTE"] = "standard5-high-compute";
    /**
     * Standard instances with high memory and compute capacity based on Intel Xeon Scalable (Cascade Lake) processors, 5nd generation
     */
    InstanceClass["M5ZN"] = "m5zn";
    /**
     * Memory optimized instances, 3rd generation
     */
    InstanceClass["MEMORY3"] = "memory3";
    /**
     * Memory optimized instances, 3rd generation
     */
    InstanceClass["R3"] = "r3";
    /**
     * Memory optimized instances, 4th generation
     */
    InstanceClass["MEMORY4"] = "memory4";
    /**
     * Memory optimized instances, 4th generation
     */
    InstanceClass["R4"] = "r4";
    /**
     * Memory optimized instances, 5th generation
     */
    InstanceClass["MEMORY5"] = "memory5";
    /**
     * Memory optimized instances, 5th generation
     */
    InstanceClass["R5"] = "r5";
    /**
     * Memory optimized instances, 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake)
     */
    InstanceClass["MEMORY6_INTEL"] = "memory6-intel";
    /**
     * Memory optimized instances, 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake)
     */
    InstanceClass["R6I"] = "r6i";
    /**
     * Memory optimized instances for high performance computing, 5th generation
     */
    InstanceClass["MEMORY5_HIGH_PERFORMANCE"] = "memory5-high-performance";
    /**
     * Memory optimized instances for high performance computing, 5th generation
     */
    InstanceClass["R5N"] = "r5n";
    /**
     * Memory optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["MEMORY5_NVME_DRIVE"] = "memory5-nvme-drive";
    /**
     * Memory optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["R5D"] = "r5d";
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE"] = "memory5-nvme-drive-high-performance";
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["R5DN"] = "r5dn";
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["MEMORY5_AMD"] = "memory5-amd";
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["R5A"] = "r5a";
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["MEMORY5_AMD_NVME_DRIVE"] = "memory5-amd-nvme-drive";
    /**
     * High memory instances (6TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation
     */
    InstanceClass["HIGH_MEMORY_6TB_1"] = "high-memory-6tb-1";
    /**
     * High memory instances (6TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation
     */
    InstanceClass["U_6TB1"] = "u-6tb1";
    /**
     * High memory instances (9TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation
     */
    InstanceClass["HIGH_MEMORY_9TB_1"] = "high-memory-9tb-1";
    /**
     * High memory instances (9TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation
     */
    InstanceClass["U_9TB1"] = "u-9tb1";
    /**
     * High memory instances (12TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation
     */
    InstanceClass["HIGH_MEMORY_12TB_1"] = "high-memory-12tb-1";
    /**
     * High memory instances (12TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation
     */
    InstanceClass["U_12TB1"] = "u-12tb1";
    /**
     * High memory instances (18TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation
     */
    InstanceClass["HIGH_MEMORY_18TB_1"] = "high-memory-18tb-1";
    /**
     * High memory instances (18TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation
     */
    InstanceClass["U_18TB1"] = "u-18tb1";
    /**
     * High memory instances (24TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation
     */
    InstanceClass["HIGH_MEMORY_24TB_1"] = "high-memory-24tb-1";
    /**
     * High memory instances (24TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation
     */
    InstanceClass["U_24TB1"] = "u-24tb1";
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["R5AD"] = "r5ad";
    /**
     * Memory optimized instances that are also EBS-optimized, 5th generation
     */
    InstanceClass["MEMORY5_EBS_OPTIMIZED"] = "memory5-ebs-optimized";
    /**
     * Memory optimized instances that are also EBS-optimized, 5th generation
     */
    InstanceClass["R5B"] = "r5b";
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors
     */
    InstanceClass["MEMORY6_GRAVITON"] = "memory6-graviton";
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors
     */
    InstanceClass["R6G"] = "r6g";
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["MEMORY6_GRAVITON2_NVME_DRIVE"] = "memory6-graviton2-nvme-drive";
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["R6GD"] = "r6gd";
    /**
     * Compute optimized instances, 3rd generation
     */
    InstanceClass["COMPUTE3"] = "compute3";
    /**
     * Compute optimized instances, 3rd generation
     */
    InstanceClass["C3"] = "c3";
    /**
     * Compute optimized instances, 4th generation
     */
    InstanceClass["COMPUTE4"] = "compute4";
    /**
     * Compute optimized instances, 4th generation
     */
    InstanceClass["C4"] = "c4";
    /**
     * Compute optimized instances, 5th generation
     */
    InstanceClass["COMPUTE5"] = "compute5";
    /**
     * Compute optimized instances, 5th generation
     */
    InstanceClass["C5"] = "c5";
    /**
     * Compute optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["COMPUTE5_NVME_DRIVE"] = "compute5-nvme-drive";
    /**
     * Compute optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["C5D"] = "c5d";
    /**
     * Compute optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["COMPUTE5_AMD"] = "compute5-amd";
    /**
     * Compute optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["C5A"] = "c5a";
    /**
     * Compute optimized instances with local NVME drive based on AMD EPYC, 5th generation
     */
    InstanceClass["COMPUTE5_AMD_NVME_DRIVE"] = "compute5-amd-nvme-drive";
    /**
     * Compute optimized instances with local NVME drive based on AMD EPYC, 5th generation
     */
    InstanceClass["C5AD"] = "c5ad";
    /**
     * Compute optimized instances for high performance computing, 5th generation
     */
    InstanceClass["COMPUTE5_HIGH_PERFORMANCE"] = "compute5-high-performance";
    /**
     * Compute optimized instances for high performance computing, 5th generation
     */
    InstanceClass["C5N"] = "c5n";
    /**
     * Compute optimized instances, 6th generation
     */
    InstanceClass["COMPUTE6_INTEL"] = "compute6-intel";
    /**
    * Compute optimized instances, 6th generation
    */
    InstanceClass["C6I"] = "c6i";
    /**
    * Compute optimized instances based on AMD EPYC (codename Milan), 6th generation
    */
    InstanceClass["COMPUTE6_AMD"] = "compute6-amd";
    /**
    * Compute optimized instances based on AMD EPYC (codename Milan), 6th generation
    */
    InstanceClass["C6A"] = "c6a";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     */
    InstanceClass["COMPUTE6_GRAVITON2"] = "compute6-graviton2";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     */
    InstanceClass["C6G"] = "c6g";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     * and local NVME drive
     */
    InstanceClass["COMPUTE6_GRAVITON2_NVME_DRIVE"] = "compute6-graviton2-nvme-drive";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     * and local NVME drive
     */
    InstanceClass["C6GD"] = "c6gd";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     * and high network bandwidth capabilities
     */
    InstanceClass["COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWITH"] = "compute6-graviton2-high-network-banwidth";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     * and high network bandwidth capabilities
     */
    InstanceClass["COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWIDTH"] = "compute6-graviton2-high-network-bandwidth";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     * and high network bandwidth capabilities
     */
    InstanceClass["C6GN"] = "c6gn";
    /**
     * Storage-optimized instances, 2nd generation
     */
    InstanceClass["STORAGE2"] = "storage2";
    /**
     * Storage-optimized instances, 2nd generation
     */
    InstanceClass["D2"] = "d2";
    /**
     * Storage-optimized instances, 3rd generation
     */
    InstanceClass["STORAGE3"] = "storage3";
    /**
     * Storage-optimized instances, 3rd generation
     */
    InstanceClass["D3"] = "d3";
    /**
    * Storage-optimized instances, 3rd generation
    */
    InstanceClass["STORAGE3_ENHANCED_NETWORK"] = "storage3-enhanced-network";
    /**
    * Storage-optimized instances, 3rd generation
    */
    InstanceClass["D3EN"] = "d3en";
    /**
     * Storage/compute balanced instances, 1st generation
     */
    InstanceClass["STORAGE_COMPUTE_1"] = "storage-compute-1";
    /**
     * Storage/compute balanced instances, 1st generation
     */
    InstanceClass["H1"] = "h1";
    /**
     * I/O-optimized instances, 3rd generation
     */
    InstanceClass["IO3"] = "io3";
    /**
     * I/O-optimized instances, 3rd generation
     */
    InstanceClass["I3"] = "i3";
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation
     */
    InstanceClass["IO3_DENSE_NVME_DRIVE"] = "io3-dense-nvme-drive";
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation
     */
    InstanceClass["I3EN"] = "i3en";
    /**
     * I/O-optimized instances with local NVME drive powered by Intel Xeon Scalable processors (code named Ice Lake), 4th generation
     */
    InstanceClass["IO4_INTEL"] = "io4_intel";
    /**
     * I/O-optimized instances with local NVME drive powered by Intel Xeon Scalable processors (code named Ice Lake), 4th generation
     */
    InstanceClass["I4I"] = "i4i";
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation
     */
    InstanceClass["STORAGE4_GRAVITON_NETWORK_OPTIMIZED"] = "storage4-graviton-network-optimized";
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation
     */
    InstanceClass["IM4GN"] = "im4gn";
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation
     */
    InstanceClass["STORAGE4_GRAVITON_NETWORK_STORAGE_OPTIMIZED"] = "storage4-graviton-network-storage-optimized";
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation
     */
    InstanceClass["IS4GEN"] = "is4gen";
    /**
     * Burstable instances, 2nd generation
     */
    InstanceClass["BURSTABLE2"] = "burstable2";
    /**
     * Burstable instances, 2nd generation
     */
    InstanceClass["T2"] = "t2";
    /**
     * Burstable instances, 3rd generation
     */
    InstanceClass["BURSTABLE3"] = "burstable3";
    /**
     * Burstable instances, 3rd generation
     */
    InstanceClass["T3"] = "t3";
    /**
     * Burstable instances based on AMD EPYC, 3rd generation
     */
    InstanceClass["BURSTABLE3_AMD"] = "burstable3-amd";
    /**
     * Burstable instances based on AMD EPYC, 3rd generation
     */
    InstanceClass["T3A"] = "t3a";
    /**
     * Burstable instances, 4th generation with Graviton2 processors
     */
    InstanceClass["BURSTABLE4_GRAVITON"] = "burstable4-graviton";
    /**
     * Burstable instances, 4th generation with Graviton2 processors
     */
    InstanceClass["T4G"] = "t4g";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["MEMORY_INTENSIVE_1"] = "memory-intensive-1";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1"] = "x1";
    /**
     * Memory-intensive instances, extended, 1st generation
     */
    InstanceClass["MEMORY_INTENSIVE_1_EXTENDED"] = "memory-intensive-1-extended";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1E"] = "x1e";
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors
     *
     * This instance type can be used only in RDS. It is not supported in EC2.
     */
    InstanceClass["MEMORY_INTENSIVE_2_GRAVITON2"] = "memory-intensive-2-graviton2";
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors
     *
     * This instance type can be used only in RDS. It is not supported in EC2.
     */
    InstanceClass["X2G"] = "x2g";
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["MEMORY_INTENSIVE_2_GRAVITON2_NVME_DRIVE"] = "memory-intensive-2-graviton2-nvme-drive";
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["X2GD"] = "x2gd";
    /**
     * Memory-intensive instances with higher network bandwith, local NVME drive, and extended memory. Intel Xeon Scalable (Ice Lake) processors
     */
    InstanceClass["MEMORY_INTENSIVE_2_XT_INTEL"] = "memory_intensive_2_xt_intel";
    /**
     *  Memory-intensive instances with higher network bandwith, local NVME drive, and extended memory. Intel Xeon Scalable (Ice Lake) processors
     */
    InstanceClass["X2IEDN"] = "x2iedn";
    /**
     * Memory-intensive instances with higher network bandwith and local NVME drive, Intel Xeon Scalable (Ice Lake) processors
     */
    InstanceClass["MEMORY_INTENSIVE_2_INTEL"] = "memory_intensive_2_intel";
    /**
     * Memory-intensive instances with higher network bandwith and local NVME drive, Intel Xeon Scalable (Ice Lake) processors
     */
    InstanceClass["X2IDN"] = "x2idn";
    /**
     * Memory-intensive instances with higher network bandwith and single-threaded performance, Intel Xeon Scalable (Cascade Lake) processors
     */
    InstanceClass["MEMORY_INTENSIVE_2_XTZ_INTEL"] = "memory_intensive_2_xtz_intel";
    /**
     * Memory-intensive instances with higher network bandwith and single-threaded performance, Intel Xeon Scalable (Cascade Lake) processors
     */
    InstanceClass["X2IEZN"] = "x2iezn";
    /**
     * Instances with customizable hardware acceleration, 1st generation
     */
    InstanceClass["FPGA1"] = "fpga1";
    /**
     * Instances with customizable hardware acceleration, 1st generation
     */
    InstanceClass["F1"] = "f1";
    /**
     * Graphics-optimized instances, 3rd generation
     */
    InstanceClass["GRAPHICS3"] = "graphics3";
    /**
     * Graphics-optimized instances, 3rd generation
     */
    InstanceClass["G3"] = "g3";
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation
     */
    InstanceClass["GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE"] = "graphics4-nvme-drive-high-performance";
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation
     */
    InstanceClass["G4DN"] = "g4dn";
    /**
     * Graphics-optimized instances based on AMD EPYC And Radeon Pro GPU (NAVI) with local NVME drive, 4th generation
     */
    InstanceClass["GRAPHICS4_AMD_NVME_DRIVE"] = "graphics4-amd-nvme-drive";
    /**
     * Graphics-optimized instances based on AMD EPYC And Radeon Pro GPU (NAVI) with local NVME drive, 4th generation
     */
    InstanceClass["G4AD"] = "g4ad";
    /**
     * Graphics-optimized instances, 5th generation
     */
    InstanceClass["GRAPHICS5"] = "graphics5";
    /**
     * Graphics-optimized instances, 5th generation
     */
    InstanceClass["G5"] = "g5";
    /**
     * Graphics-optimized instances powered by AWS Graviton2 Processors and NVIDIA T4G Tensor Core GPUs, 5th generation
     */
    InstanceClass["GRAPHICS5_GRAVITON2"] = "graphics5-graviton2";
    /**
    * Graphics-optimized instances powered by AWS Graviton2 Processors and NVIDIA T4G Tensor Core GPUs, 5th generation
    */
    InstanceClass["G5G"] = "g5g";
    /**
     * Parallel-processing optimized instances, 2nd generation
     */
    InstanceClass["PARALLEL2"] = "parallel2";
    /**
     * Parallel-processing optimized instances, 2nd generation
     */
    InstanceClass["P2"] = "p2";
    /**
     * Parallel-processing optimized instances, 3nd generation
     */
    InstanceClass["PARALLEL3"] = "parallel3";
    /**
     * Parallel-processing optimized instances, 3rd generation
     */
    InstanceClass["P3"] = "p3";
    /**
     * Parallel-processing optimized instances, 4th generation
     */
    InstanceClass["PARALLEL4"] = "parallel4";
    /**
     * Parallel-processing optimized instances, 4th generation
     */
    InstanceClass["P4D"] = "p4d";
    /**
     * Arm processor based instances, 1st generation
     */
    InstanceClass["ARM1"] = "arm1";
    /**
     * Arm processor based instances, 1st generation
     */
    InstanceClass["A1"] = "a1";
    /**
     * Arm processor based instances, 2nd generation
     */
    InstanceClass["STANDARD6_GRAVITON"] = "standard6-graviton";
    /**
     * Arm processor based instances, 2nd generation
     */
    InstanceClass["M6G"] = "m6g";
    /**
     * Standard instances based on Intel (Ice Lake), 6th generation.
     */
    InstanceClass["STANDARD6_INTEL"] = "standard6-intel";
    /**
     * Standard instances based on Intel (Ice Lake), 6th generation.
     */
    InstanceClass["M6I"] = "m6i";
    /**
     * Standard instances based on 3rd Gen AMD EPYC processors, 6th generation.
     */
    InstanceClass["STANDARD6_AMD"] = "standard6-amd";
    /**
    * Standard instances based on 3rd Gen AMD EPYC processors, 6th generation.
    */
    InstanceClass["M6A"] = "m6a";
    /**
     * Standard instances, 6th generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["STANDARD6_GRAVITON2_NVME_DRIVE"] = "standard6-graviton2-nvme-drive";
    /**
     * Standard instances, 6th generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["M6GD"] = "m6gd";
    /**
     * High memory and compute capacity instances, 1st generation
     */
    InstanceClass["HIGH_COMPUTE_MEMORY1"] = "high-compute-memory1";
    /**
     * High memory and compute capacity instances, 1st generation
     */
    InstanceClass["Z1D"] = "z1d";
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation
     */
    InstanceClass["INFERENCE1"] = "inference1";
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation
     */
    InstanceClass["INF1"] = "inf1";
    /**
     * Macintosh instances built on Apple Mac mini computers, 1st generation with Intel procesors
     */
    InstanceClass["MACINTOSH1_INTEL"] = "macintosh1-intel";
    /**
     * Macintosh instances built on Apple Mac mini computers, 1st generation with Intel procesors
     */
    InstanceClass["MAC1"] = "mac1";
    /**
     * Multi-stream video transcoding instances for resolutions up to 4K UHD, 1st generation
     */
    InstanceClass["VIDEO_TRANSCODING1"] = "video-transcoding1";
    /**
     * Multi-stream video transcoding instances for resolutions up to 4K UHD, 1st generation
     */
    InstanceClass["VT1"] = "vt1";
    /**
     * High performance computing based on AMD EPYC, 6th generation
     */
    InstanceClass["HIGH_PERFORMANCE_COMPUTING6_AMD"] = "high-performance-computing6-amd";
    /**
     * High performance computing based on AMD EPYC, 6th generation
     */
    InstanceClass["HPC6A"] = "hpc6a";
})(InstanceClass = exports.InstanceClass || (exports.InstanceClass = {}));
/**
 * Identifies an instance's CPU architecture
 */
var InstanceArchitecture;
(function (InstanceArchitecture) {
    /**
     * ARM64 architecture
     */
    InstanceArchitecture["ARM_64"] = "arm64";
    /**
     * x86-64 architecture
     */
    InstanceArchitecture["X86_64"] = "x86_64";
})(InstanceArchitecture = exports.InstanceArchitecture || (exports.InstanceArchitecture = {}));
/**
 * What size of instance to use
 */
var InstanceSize;
(function (InstanceSize) {
    /**
     * Instance size NANO (nano)
     */
    InstanceSize["NANO"] = "nano";
    /**
     * Instance size MICRO (micro)
     */
    InstanceSize["MICRO"] = "micro";
    /**
     * Instance size SMALL (small)
     */
    InstanceSize["SMALL"] = "small";
    /**
     * Instance size MEDIUM (medium)
     */
    InstanceSize["MEDIUM"] = "medium";
    /**
     * Instance size LARGE (large)
     */
    InstanceSize["LARGE"] = "large";
    /**
     * Instance size XLARGE (xlarge)
     */
    InstanceSize["XLARGE"] = "xlarge";
    /**
     * Instance size XLARGE2 (2xlarge)
     */
    InstanceSize["XLARGE2"] = "2xlarge";
    /**
     * Instance size XLARGE3 (3xlarge)
     */
    InstanceSize["XLARGE3"] = "3xlarge";
    /**
     * Instance size XLARGE4 (4xlarge)
     */
    InstanceSize["XLARGE4"] = "4xlarge";
    /**
     * Instance size XLARGE6 (6xlarge)
     */
    InstanceSize["XLARGE6"] = "6xlarge";
    /**
     * Instance size XLARGE8 (8xlarge)
     */
    InstanceSize["XLARGE8"] = "8xlarge";
    /**
     * Instance size XLARGE9 (9xlarge)
     */
    InstanceSize["XLARGE9"] = "9xlarge";
    /**
     * Instance size XLARGE10 (10xlarge)
     */
    InstanceSize["XLARGE10"] = "10xlarge";
    /**
     * Instance size XLARGE12 (12xlarge)
     */
    InstanceSize["XLARGE12"] = "12xlarge";
    /**
     * Instance size XLARGE16 (16xlarge)
     */
    InstanceSize["XLARGE16"] = "16xlarge";
    /**
     * Instance size XLARGE18 (18xlarge)
     */
    InstanceSize["XLARGE18"] = "18xlarge";
    /**
     * Instance size XLARGE24 (24xlarge)
     */
    InstanceSize["XLARGE24"] = "24xlarge";
    /**
     * Instance size XLARGE32 (32xlarge)
     */
    InstanceSize["XLARGE32"] = "32xlarge";
    /**
     * Instance size XLARGE48 (48xlarge)
     */
    InstanceSize["XLARGE48"] = "48xlarge";
    /**
     * Instance size XLARGE56 (56xlarge)
     */
    InstanceSize["XLARGE56"] = "56xlarge";
    /**
     * Instance size XLARGE56 (112xlarge)
     */
    InstanceSize["XLARGE112"] = "112xlarge";
    /**
     * Instance size METAL (metal)
     */
    InstanceSize["METAL"] = "metal";
})(InstanceSize = exports.InstanceSize || (exports.InstanceSize = {}));
/**
 * Instance type for EC2 instances
 *
 * This class takes a literal string, good if you already
 * know the identifier of the type you want.
 */
class InstanceType {
    constructor(instanceTypeIdentifier) {
        this.instanceTypeIdentifier = instanceTypeIdentifier;
    }
    /**
     * Instance type for EC2 instances
     *
     * This class takes a combination of a class and size.
     *
     * Be aware that not all combinations of class and size are available, and not all
     * classes are available in all regions.
     */
    static of(instanceClass, instanceSize) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ec2_InstanceClass(instanceClass);
            jsiiDeprecationWarnings._aws_cdk_aws_ec2_InstanceSize(instanceSize);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.of);
            }
            throw error;
        }
        // JSII does not allow enum types to have same value. So to support the enum, the enum with same value has to be mapped later.
        const instanceClassMap = {
            [InstanceClass.STANDARD3]: 'm3',
            [InstanceClass.M3]: 'm3',
            [InstanceClass.STANDARD4]: 'm4',
            [InstanceClass.M4]: 'm4',
            [InstanceClass.STANDARD5]: 'm5',
            [InstanceClass.M5]: 'm5',
            [InstanceClass.STANDARD5_NVME_DRIVE]: 'm5d',
            [InstanceClass.M5D]: 'm5d',
            [InstanceClass.STANDARD5_AMD]: 'm5a',
            [InstanceClass.M5A]: 'm5a',
            [InstanceClass.STANDARD5_AMD_NVME_DRIVE]: 'm5ad',
            [InstanceClass.M5AD]: 'm5ad',
            [InstanceClass.STANDARD5_HIGH_PERFORMANCE]: 'm5n',
            [InstanceClass.M5N]: 'm5n',
            [InstanceClass.STANDARD5_NVME_DRIVE_HIGH_PERFORMANCE]: 'm5dn',
            [InstanceClass.M5DN]: 'm5dn',
            [InstanceClass.STANDARD5_HIGH_COMPUTE]: 'm5zn',
            [InstanceClass.M5ZN]: 'm5zn',
            [InstanceClass.MEMORY3]: 'r3',
            [InstanceClass.R3]: 'r3',
            [InstanceClass.MEMORY4]: 'r4',
            [InstanceClass.R4]: 'r4',
            [InstanceClass.MEMORY5]: 'r5',
            [InstanceClass.R5]: 'r5',
            [InstanceClass.MEMORY6_INTEL]: 'r6i',
            [InstanceClass.R6I]: 'r6i',
            [InstanceClass.MEMORY5_HIGH_PERFORMANCE]: 'r5n',
            [InstanceClass.R5N]: 'r5n',
            [InstanceClass.MEMORY5_NVME_DRIVE]: 'r5d',
            [InstanceClass.R5D]: 'r5d',
            [InstanceClass.MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE]: 'r5dn',
            [InstanceClass.R5DN]: 'r5dn',
            [InstanceClass.MEMORY5_AMD]: 'r5a',
            [InstanceClass.R5A]: 'r5a',
            [InstanceClass.MEMORY5_AMD_NVME_DRIVE]: 'r5ad',
            [InstanceClass.R5AD]: 'r5ad',
            [InstanceClass.HIGH_MEMORY_6TB_1]: 'u-6tb1',
            [InstanceClass.U_6TB1]: 'u-6tb1',
            [InstanceClass.HIGH_MEMORY_9TB_1]: 'u-9tb1',
            [InstanceClass.U_9TB1]: 'u-9tb1',
            [InstanceClass.HIGH_MEMORY_12TB_1]: 'u-12tb1',
            [InstanceClass.U_12TB1]: 'u-12tb1',
            [InstanceClass.HIGH_MEMORY_18TB_1]: 'u-18tb1',
            [InstanceClass.U_18TB1]: 'u-18tb1',
            [InstanceClass.HIGH_MEMORY_24TB_1]: 'u-24tb1',
            [InstanceClass.U_24TB1]: 'u-24tb1',
            [InstanceClass.MEMORY5_EBS_OPTIMIZED]: 'r5b',
            [InstanceClass.R5B]: 'r5b',
            [InstanceClass.MEMORY6_GRAVITON]: 'r6g',
            [InstanceClass.R6G]: 'r6g',
            [InstanceClass.MEMORY6_GRAVITON2_NVME_DRIVE]: 'r6gd',
            [InstanceClass.R6GD]: 'r6gd',
            [InstanceClass.COMPUTE3]: 'c3',
            [InstanceClass.C3]: 'c3',
            [InstanceClass.COMPUTE4]: 'c4',
            [InstanceClass.C4]: 'c4',
            [InstanceClass.COMPUTE5]: 'c5',
            [InstanceClass.C5]: 'c5',
            [InstanceClass.COMPUTE5_NVME_DRIVE]: 'c5d',
            [InstanceClass.C5D]: 'c5d',
            [InstanceClass.COMPUTE5_AMD]: 'c5a',
            [InstanceClass.C5A]: 'c5a',
            [InstanceClass.COMPUTE5_AMD_NVME_DRIVE]: 'c5ad',
            [InstanceClass.C5AD]: 'c5ad',
            [InstanceClass.COMPUTE5_HIGH_PERFORMANCE]: 'c5n',
            [InstanceClass.C5N]: 'c5n',
            [InstanceClass.COMPUTE6_INTEL]: 'c6i',
            [InstanceClass.C6I]: 'c6i',
            [InstanceClass.COMPUTE6_AMD]: 'c6a',
            [InstanceClass.C6A]: 'c6a',
            [InstanceClass.COMPUTE6_GRAVITON2]: 'c6g',
            [InstanceClass.C6G]: 'c6g',
            [InstanceClass.COMPUTE6_GRAVITON2_NVME_DRIVE]: 'c6gd',
            [InstanceClass.C6GD]: 'c6gd',
            [InstanceClass.COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWIDTH]: 'c6gdb',
            [InstanceClass.COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWITH]: 'c6gdb',
            [InstanceClass.C6GN]: 'c6gn',
            [InstanceClass.STORAGE2]: 'd2',
            [InstanceClass.D2]: 'd2',
            [InstanceClass.STORAGE3]: 'd3',
            [InstanceClass.D3]: 'd3',
            [InstanceClass.STORAGE3_ENHANCED_NETWORK]: 'd3en',
            [InstanceClass.D3EN]: 'd3en',
            [InstanceClass.STORAGE_COMPUTE_1]: 'h1',
            [InstanceClass.H1]: 'h1',
            [InstanceClass.IO3]: 'i3',
            [InstanceClass.I3]: 'i3',
            [InstanceClass.IO3_DENSE_NVME_DRIVE]: 'i3en',
            [InstanceClass.I3EN]: 'i3en',
            [InstanceClass.STORAGE4_GRAVITON_NETWORK_OPTIMIZED]: 'im4gn',
            [InstanceClass.IM4GN]: 'im4gn',
            [InstanceClass.STORAGE4_GRAVITON_NETWORK_STORAGE_OPTIMIZED]: 'is4gen',
            [InstanceClass.IS4GEN]: 'is4gen',
            [InstanceClass.BURSTABLE2]: 't2',
            [InstanceClass.T2]: 't2',
            [InstanceClass.BURSTABLE3]: 't3',
            [InstanceClass.T3]: 't3',
            [InstanceClass.BURSTABLE3_AMD]: 't3a',
            [InstanceClass.T3A]: 't3a',
            [InstanceClass.BURSTABLE4_GRAVITON]: 't4g',
            [InstanceClass.T4G]: 't4g',
            [InstanceClass.MEMORY_INTENSIVE_1]: 'x1',
            [InstanceClass.X1]: 'x1',
            [InstanceClass.MEMORY_INTENSIVE_1_EXTENDED]: 'x1e',
            [InstanceClass.X1E]: 'x1e',
            [InstanceClass.MEMORY_INTENSIVE_2_GRAVITON2]: 'x2g',
            [InstanceClass.X2G]: 'x2g',
            [InstanceClass.MEMORY_INTENSIVE_2_GRAVITON2_NVME_DRIVE]: 'x2gd',
            [InstanceClass.X2GD]: 'x2gd',
            [InstanceClass.FPGA1]: 'f1',
            [InstanceClass.F1]: 'f1',
            [InstanceClass.GRAPHICS3]: 'g3',
            [InstanceClass.G3]: 'g3',
            [InstanceClass.GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE]: 'g4dn',
            [InstanceClass.G4DN]: 'g4dn',
            [InstanceClass.GRAPHICS4_AMD_NVME_DRIVE]: 'g4ad',
            [InstanceClass.G4AD]: 'g4ad',
            [InstanceClass.GRAPHICS5]: 'g5',
            [InstanceClass.G5]: 'g5',
            [InstanceClass.GRAPHICS5_GRAVITON2]: 'g5g',
            [InstanceClass.G5G]: 'g5g',
            [InstanceClass.PARALLEL2]: 'p2',
            [InstanceClass.P2]: 'p2',
            [InstanceClass.PARALLEL3]: 'p3',
            [InstanceClass.P3]: 'p3',
            [InstanceClass.PARALLEL4]: 'p4d',
            [InstanceClass.P4D]: 'p4d',
            [InstanceClass.ARM1]: 'a1',
            [InstanceClass.A1]: 'a1',
            [InstanceClass.STANDARD6_GRAVITON]: 'm6g',
            [InstanceClass.M6G]: 'm6g',
            [InstanceClass.STANDARD6_INTEL]: 'm6i',
            [InstanceClass.M6I]: 'm6i',
            [InstanceClass.STANDARD6_AMD]: 'm6a',
            [InstanceClass.M6A]: 'm6a',
            [InstanceClass.STANDARD6_GRAVITON2_NVME_DRIVE]: 'm6gd',
            [InstanceClass.M6GD]: 'm6gd',
            [InstanceClass.HIGH_COMPUTE_MEMORY1]: 'z1d',
            [InstanceClass.Z1D]: 'z1d',
            [InstanceClass.INFERENCE1]: 'inf1',
            [InstanceClass.INF1]: 'inf1',
            [InstanceClass.MACINTOSH1_INTEL]: 'mac1',
            [InstanceClass.MAC1]: 'mac1',
            [InstanceClass.VIDEO_TRANSCODING1]: 'vt1',
            [InstanceClass.VT1]: 'vt1',
            [InstanceClass.HIGH_PERFORMANCE_COMPUTING6_AMD]: 'hpc6a',
            [InstanceClass.HPC6A]: 'hpc6a',
            [InstanceClass.I4I]: 'i4i',
            [InstanceClass.IO4_INTEL]: 'i4i',
            [InstanceClass.X2IEDN]: 'x2iedn',
            [InstanceClass.MEMORY_INTENSIVE_2_XT_INTEL]: 'x2iedn',
            [InstanceClass.X2IDN]: 'x2idn',
            [InstanceClass.MEMORY_INTENSIVE_2_INTEL]: 'x2idn',
            [InstanceClass.X2IEZN]: 'x2iezn',
            [InstanceClass.MEMORY_INTENSIVE_2_XTZ_INTEL]: 'x2iezn',
        };
        return new InstanceType(`${instanceClassMap[instanceClass] ?? instanceClass}.${instanceSize}`);
    }
    /**
     * Return the instance type as a dotted string
     */
    toString() {
        return this.instanceTypeIdentifier;
    }
    /**
     * The instance's CPU architecture
     */
    get architecture() {
        // capture the family, generation, capabilities, and size portions of the instance type id
        const instanceTypeComponents = this.instanceTypeIdentifier.match(/^([a-z]+)(\d{1,2})([a-z]*)\.([a-z0-9]+)$/);
        if (instanceTypeComponents == null) {
            throw new Error('Malformed instance type identifier');
        }
        const family = instanceTypeComponents[1];
        const capabilities = instanceTypeComponents[3];
        // Instance family `a` are first-gen Graviton instances
        // Capability `g` indicates the instance is Graviton2 powered
        if (family === 'a' || capabilities.includes('g')) {
            return InstanceArchitecture.ARM_64;
        }
        return InstanceArchitecture.X86_64;
    }
}
exports.InstanceType = InstanceType;
_a = JSII_RTTI_SYMBOL_1;
InstanceType[_a] = { fqn: "@aws-cdk/aws-ec2.InstanceType", version: "1.190.0" };
//# sourceMappingURL=data:application/json;base64,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