# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['msanalyzer', 'msanalyzer.models']

package_data = \
{'': ['*']}

install_requires = \
['PyMuPDF==1.18.13',
 'aiofiles==0.6.0',
 'fastapi==0.64.0',
 'matplotlib==3.4.1',
 'numpy==1.20.2',
 'openpyxl==3.0.7',
 'pandas==1.2.4',
 'pydantic>=1.8.2,<2.0.0',
 'python-multipart==0.0.5',
 'rich>=10.2.1,<11.0.0',
 'scipy==1.6.3',
 'uvicorn==0.13.4']

extras_require = \
{':sys_platform == "linux"': ['gunicorn', 'httptools', 'uvloop']}

entry_points = \
{'console_scripts': ['msanalyzer-cli = msanalyzer.cli:main']}

setup_kwargs = {
    'name': 'msanalyzer',
    'version': '3.7.1',
    'description': 'Analyze XPS report files generated by Mastersizer 2000',
    'long_description': '# msanalyzer\n\nAnalyze XPS report files generated by Mastersizer 2000.\n\n## Aplicativo web (PT-BR)\n\nO _msanalyzer_ possui uma versão mais simples em formato de _aplicativo web_. Deste modo, é extremamente fácil usar o programa.\n\nBasta acessar o site [msanalyzer.netlify.app](https://msanalyzer.netlify.app/) e utilizar! Não é necessário nenhum tipo de instalação.\n\nQualquer dúvida sobre a utilização do site, por favor, entre em contato.\n\n## Interface gráfica (PT-BR)\n\nPara usar a interface gráfica, baixe o arquivo _msanalyzer_gui_win64.zip_ disponível na [página de releases](https://github.com/marcusbfs/msanalyzer/releases) e descompacte-o.\n\nDentro da pasta descompactada, haverá um arquivo chamado _msanalyzer_gui.exe_. Execute-o para iniciar o programa.\n\n_Obs: Ao abrir o executável pela primeira vez, pode ser que o programa demore para iniciar. Isto é normal: o interpretador do Python precisa ser descompactado; este procedimento não deve demorar mais que 20 segundos. Apenas espere e não se preocupe :)_\n\nQualquer dúvida sobre a utilização do programa, sugestões de melhoria ou desejo de colaborar com o código, sinta-se a vontade para entrar em contato!\n\n### Seleção e visualização de modelos\n\n[![Models](https://raw.githubusercontent.com/marcusbfs/msanalyzer/master/images/models_tab.png)](https://raw.githubusercontent.com/marcusbfs/msanalyzer/master/images/models_tab.png)\n\n### Gráfico de um único arquivo\n\n[![Models](https://raw.githubusercontent.com/marcusbfs/msanalyzer/master/images/plot_tab.png)](https://raw.githubusercontent.com/marcusbfs/msanalyzer/master/images/plot_tab.png)\n\n### Gráfico de vários arquivos\n\n[![Models](https://raw.githubusercontent.com/marcusbfs/msanalyzer/master/images/multiplots_tab.png)](https://raw.githubusercontent.com/marcusbfs/msanalyzer/master/images/multiplots_tab.png)\n\n### Janela principal\n\n[![Options](https://raw.githubusercontent.com/marcusbfs/msanalyzer/master/images/options_gui.png)](https://raw.githubusercontent.com/marcusbfs/msanalyzer/master/images/options_gui.png)\n\n## Command line interface\n\nThe easiest way to use **msanalyzer** is to download the .exe file on [release pages](https://github.com/marcusbfs/msanalyzer/releases).\nAfter downloading it, put the XPS report in the same folder as the EXE. Rename the XPS to "ms_input.xps" and double-click "msanalyzer.exe".\n\nThis will create a directory called "mastersizer_output" with the following files:\n\n- output_curve_data.xlsx: diameter, volume fraction and cumulative volume fraction data in a Excel file;\n- output_curves.svg: Plot of volume fraction and cumulative volume fraction data (example below);\n  [![RRB fitted model](https://raw.githubusercontent.com/marcusbfs/msanalyzer/master/output_example/output_curves.png)](https://raw.githubusercontent.com/marcusbfs/msanalyzer/master/output_example/output_curves.png)\n- output_curve_data.txt: diameter, volume fraction and cumulative volume fraction data in a TXT file;\n- output_RRB_model_parameters.txt: RRB model parameters fitted to input data;\n- output_RRB_model.svg: Cumulative volume fraction plot of data and RRB fitted model (example below).\n  [![RRB fitted model](https://raw.githubusercontent.com/marcusbfs/msanalyzer/master/output_example/output_RRB_model.png)](https://raw.githubusercontent.com/marcusbfs/msanalyzer/master/output_example/output_RRB_model.png)\n\nThis program can also be used from command line with several options. Inside CMD or PowerShell, enter\n\n```\n./msanalyzer.exe --help\n```\n\nto see the available options.\n\n### dev install\n\nTo get a development enviroment running, do the following:\n\n1 - Clone the repo\n\n```\ngit clone https://github.com/marcusbfs/msanalyzer.git\n```\n\n2 - Create a virtual environment and activate it\n\n```\npython -m venv msanalyzer_venv\n.\\msanalyzer_venv\\Script\\activate.bat\n```\n\n3 - Download requirements files\n\n```\npip install -r requirements.txt\n```\n\n4 - Run a test\n\n```\npython msanalyzer.py ms_input.xps\n```\n\n## Contributing\n\nFeel free to contribute anyway you want to :)\n\n## Authors\n\n- **Marcus Bruno Fernandes Silva** - *marcusbfs@gmail.com*\n\n## License\n\nThis project is licensed under the MIT License - see the [LICENSE.md](LICENSE.md) file for details\n',
    'author': 'Marcus Bruno Fernandes Silva',
    'author_email': 'marcusbfs@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '==3.9.5',
}


setup(**setup_kwargs)
