TESTDATA_PRECOMPUTED_DEM = set({'CPGIII', 'ACARm', 'MENIN', 'S', 'DAPRP', 'PAD', 'CALH', 'DUMPm', 'ACOA', 'Ca', 'MYOCYPI', 'LLTRNA', 'cIMP', 'AMYLSe', 'ISOBUCOA', 'TRNAm', 'ISOVACOAm', 'DANNAm', 'HPRO', 'LPAA', 'SAMOBm', 'ACET', 'Km', 'SARCm', 'C182COA', 'NPP', 'AONAm', 'Hm', 'C60COA', 'LILEUTRNA', 'GABA', 'LMETTRNA', 'HHTRNA', 'ADPRIB', 'URAe', 'RX', 'VESTINE', 'GGPP', 'GLNm', 'cdAMP', 'TTGGP', 'TRPM', 'NAORN', 'CPGIIIm', 'CYTSe', 'LTHETRNA', 'GNe', 'Cam', 'APOCARB', 'OBUT', 'AMIEVULm', 'PYTE', 'FOFMETm', 'LMETTRNAm', 'LCysTRNA', 'C161COA', 'LValTRNA', 'GLYTRNA', 'SIHM', 'C100COA', '6CARHEX', 'THME', 'AMYLPe', 'ITCe', 'GABALm', 'ASNm', 'SUCCSAL', 'PHCm', '5THR1P', 'SAMOB', 'DIDIPC', 'LGLNTRNAm', 'ASPTRNAm', 'PHC', 'TRPTRNA', 'KEMYOI', 'APEBU', 'AMPp', 'GLTCOAm', 'HEME_Am', 'SUCe', 'ADPRIBm', 'PHEm', 'CYNE', 'SPRM', 'H2Sm', 'RAFe', 'NO', 'NICNATEm', 'PTRSCm', 'LPDME', 'C80COA', 'SNPI', 'GABAe', 'AMIACE', 'DIMEGLY', 'RTHIOm', 'MIP2C', 'ACPm', 'DPTH', 'SUFT', 'MTHFm', 'PGPm', 'ISOVACOA', 'C181COA', 'ASNTRNA', 'OSLHSER', 'C162COA', 'ACYBUT', 'LAlaTRNA', 'FALDm', 'HCO3m', 'PPIp', 'IAC', 'PENN', 'HX', 'C40COA', 'PDXL5PI', 'GLYCEROCHO', 'TYRm', 'HPROm', 'MYOIe', 'Ee', 'PANTm', 'LRLe', 'PROPCOAm', 'cGMP', 'NICD', 'LGLNTRNA', 'LGLUTRNAm', 'LLeuTRNA', 'ALTRNA', 'LSECTRNA', 'ECYSm', 'LTyrTRNA', 'FERRIN', 'Cu', 'DPRO', 'ERIDICOL', 'LTyrTRNAm', 'CARBO', 'LPROTRNA', 'PCACE', 'ADe', 'PENACID', 'ISOBUCOAm', 'C16A', 'LPS', 'cCMP', 'CHOREOLESTR', 'LPG', 'EOLe', 'PHACALe', 'THZ', 'Cum', 'MTHGXLm', 'NADPp', 'CELLOTe', 'APOCEm', 'LPheTRNA', 'ASPTRNA', 'OTHIOm', 'NITE', 'GACER', 'MHIS', 'SPMYLIN', 'GLTCOA', 'PADm', 'ESULFCYSm', 'PROm', 'DGLYCODEX', 'NITROPRO', 'IAD', 'APROP', '2NPMP', 'FMNm', 'ATPp', 'APROA', 'DASP', 'C183COA', 'PAPm', 'LPMME', 'AMACm', 'CLm', 'R5Pm', 'ARABLAC', 'ASNTRNAm', 'Nam', 'LPE', 'SLFe', 'DIMEGLYm', 'DGPP', 'LTHETRNAm', 'SUCCSALm', 'CHOe', 'GLCNe', 'LILEUTRNAm', 'GCYLCR', 'ACEp', 'DTMPm', 'G', 'SARC', 'ACAR', 'THPTGLU', 'CYST', 'NADPHp', 'TGEe', 'CYMECm', '2NPMPm', 'MTHPTGLU', 'ASERm'})


TESTDATA_PRECOMPUTED_CHOKEPOINTS = set({'r1029', 'r2354', 'r2356', 'r984', 'r977', 'r1776', 'r751', 'r766', 'r2108', 'r1158', 'r2098', 'r204', 'r804', 'r1178', 'r119', 'r601', 'r2161', 'r724', 'r2273', 'r1138', 'r2338', 'r1674', 'r591', 'r1680', 'r549', 'r175', 'r959', 'r1959', 'r1210', 'r377', 'r1951', 'r1949', 'r1695', 'r570', 'r1969', 'r1955', 'r514', 'r1944', 'r1740', 'r765', 'r762', 'r887', 'r1766', 'r756', 'r2130', 'r1183', 'r1000', 'r763', 'r1454', 'r2111', 'r1557', 'r1509', 'r130', 'r1490', 'r817', 'r273', 'r1795', 'r316', 'r814', 'r1760', 'r785', 'r770', 'r2271', 'r877', 'r906', 'r1889', 'r2275', 'r2183', 'r733', 'r1386', 'r1828', 'r2104', 'r560', 'r773', 'r573', 'r971', 'r1396', 'r2220', 'r1376', 'r1891', 'r2196', 'r1723', 'r1777', 'r1119', 'r1727', 'r2194', 'r1699', 'r120', 'r831', 'r1958', 'r2193', 'r1859', 'r1797', 'r713', 'r2212', 'r1677', 'r1968', 'r1091', 'r1696', 'r579', 'r1569', 'r1769', 'r902', 'r1555', 'r1471', 'r1729', 'r1741', 'r1575', 'r611', 'r576', 'r886', 'r1761', 'r1362', 'r380', 'r1721', 'r1957', 'r1954', 'r1716', 'r1203', 'r1535', 'r784', 'r1970', 'r1159', 'r889', 'r816', 'r1827', 'r1663', 'r2180', 'r833', 'r1971', 'r593', 'r1834', 'r2200', 'r2112', 'r183', 'r774', 'r391', 'r2131', 'r1391', 'r1374', 'r1568', 'r1758', 'r315', 'r1775', 'r90', 'r1650', 'r871', 'r1447', 'r1563', 'r1982', 'r194', 'r1890', 'r1583', 'r1833', 'r1442', 'r1724', 'r1884', 'r776', 'r1578', 'r2195', 'r1824', 'r2274', 'r2263', 'r1747', 'r186', 'r884', 'r2262', 'r787', 'r163', 'r2213', 'r1574', 'r1717', 'r1869', 'r2209', 'r171', 'r883', 'r295', 'r545', 'r62', 'r592', 'r1755', 'r1001', 'r786', 'r923', 'r307', 'r1567', 'r1778', 'r1722', 'r1753', 'r2215', 'r1704', 'r812', 'r2278', 'r1495', 'r1189', 'r1475', 'r799', 'r717', 'r1805', 'r2279', 'r2227', 'r1518', 'r1965', 'r2352', 'r1368', 'r924', 'r505', 'r1693', 'r1388', 'r1581', 'r551', 'r280', 'r252', 'r2267', 'r1476', 'r769', 'r1382', 'r1073', 'r1217', 'r2102', 'r1700', 'r775', 'r1708', 'r1673', 'r1446', 'r376', 'r836', 'r2261', 'r1140', 'r2101', 'r2265', 'r1097', 'r613', 'r1796', 'r896', 'r2355', 'r1092', 'r1134', 'r525', 'r2091', 'r1947', 'r2105', 'r1429', 'r285', 'r818', 'r2107', 'r1069', 'r569', 'r205', 'r2230', 'r1532', 'r1231', 'r1770', 'r880', 'r1789', 'r612', 'r2210', 'r2272', 'r181', 'r2140', 'r1767', 'r882', 'r1972', 'r2172', 'r1196', 'r1554', 'r1946', 'r1771', 'r1960', 'r1950', 'r1472', 'r1967', 'r2134', 'r2186', 'r1123', 'r1506', 'r1470', 'r1963', 'r1897', 'r2115', 'r1893', 'r172', 'r1825', 'r1806', 'r1886', 'r1441', 'r704', 'r1464', 'r2201', 'r915', 'r1615', 'r2144', 'r550', 'r1224', 'r2266', 'r2165', 'r1079', 'r1450', 'r728', 'r1688', 'r800', 'r835', 'r2133', 'r616', 'r1948', 'r1698', 'r938', 'r881', 'r2229', 'r1956', 'r378', 'r2092', 'r1977', 'r49', 'r2187', 'r1380', 'r2204', 'r1953', 'r1888', 'r1794', 'r2216', 'r2218', 'r419', 'r1428', 'r1961', 'r993', 'r2129', 'r1576', 'r888', 'r188', 'r2176', 'r1807', 'r1030', 'r2106', 'r1689', 'r1558', 'r2270', 'r1681', 'r546', 'r2353', 'r1733', 'r2223', 'r615', 'r105', 'r1697', 'r1754', 'r2109', 'r1675', 'r1703', 'r1962', 'r2116', 'r2327', 'r1885', 'r135', 'r1779', 'r642', 'r907', 'r2103', 'r1120', 'r1718', 'r1759', 'r614', 'r974', 'r184', 'r2277', 'r1118', 'r1883', 'r1952', 'r1356', 'r2110', 'r150', 'r1783', 'r2164', 'r2264', 'r1512', 'r1458', 'r2226', 'r1826', 'r50', 'r2171', 'r1024', 'r692', 'r2231', 'r547', 'r947', 'r1887', 'r1895', 'r748', 'r1945', 'r602', 'r1793', 'r1743', 'r379', 'r1943', 'r503', 'r1707', 'r2269', 'r1494', 'r299', 'r1710', 'r531', 'r808', 'r440', 'r2260', 'r2268', 'r2276', 'r944', 'r1238', 'r1559', 'r1643', 'r1768', 'r768', 'r389', 'r529', 'r966', 'r2358', 'r548', 'r1081', 'r1892', 'r2113', 'r568', 'r2088', 'r1980', 'r1762', 'r518', 'r393', 'r530', 'r2127', 'r767', 'r2114', 'r182', 'r2175', 'r813', 'r779', 'r191', 'r1032'})

TESTDATA_PRECOMPUTED_GROWTH_CP = set({'r1217', 'r2274', 'r1972', 'r158', 'r2144', 'r1661', 'r2247', 'r2135', 'r782', 'r2106', 'r798', 'r62', 'r1952', 'r1663', 'r2112', 'r2252', 'r2257', 'r2223', 'r2244', 'r2201', 'r2212', 'r2174', 'r1202', 'r775', 'r550', 'r2104', 'r545', 'r2107', 'r1223', 'r783', 'r1959', 'r1556', 'r1224', 'r1979', 'r754', 'r1100', 'r2113', 'r1951', 'r2241', 'r1960', 'r2239', 'r333', 'r2102', 'added_biomass_sink', 'r2261', 'r1967', 'r2275', 'r1189', 'r1946', 'r2114', 'r285', 'r1891', 'r2207', 'r1149', 'r691', 'r1079', 'r776', 'r1140', 'r2270', 'r1678', 'r1955', 'r1615', 'r2255', 'r548', 'r857', 'r2249', 'r1974', 'r2265', 'r1179', 'r2263', 'r1557', 'r2220', 'r2264', 'r2278', 'r2110', 'r2253', 'r2237', 'r1080', 'r2271', 'r2098', 'r2210', 'r1209', 'r2234', 'r1555', 'r2351', 'r2276', 'r1954', 'r1238', 'r2103', 'r1961', 'r2242', 'r68', 'r389', 'r1947', 'r2116', 'r2240', 'r2115', 'r525', 'r2260', 'r2209', 'r1897', 'r1237', 'r1177', 'r2216', 'r2227', 'r1895', 'r2136', 'r2218', 'r2111', 'r1231', 'r1517', 'r1081', 'r2279', 'r2251', 'r392', 'r496', 'r551', 'r2258', 'r2236', 'r1078', 'r2233', 'r1949', 'r1188', 'r391', 'r1953', 'r2108', 'r1945', 'r1896', 'r1962', 'r779', 'r2215', 'r2262', 'r1554', 'r1187', 'r1195', 'r2229', 'r2109', 'r2259', 'r1122', 'r2360', 'r2213', 'r1893', 'r2277', 'r2243', 'r1082', 'r1148', 'r947', 'r2268', 'r2142', 'r2138', 'r2269', 'r1109', 'r2170', 'r2169', 'r1982', 'r2272', 'r2339', 'r549', 'r1512', 'r2105', 'r2231', 'r2245', 'r1137', 'r1892', 'r1981', 'r1088', 'r2248', 'r1957', 'r513', 'r1980', 'r2250', 'r1950', 'r2273', 'r1965', 'r1216', 'r1166', 'r1958', 'r1203', 'r1097', 'r1210', 'r2238', 'r2232', 'r2230', 'r2', 'r1178', 'r1090', 'r514', 'r1230', 'r2267', 'r1183', 'r1956', 'r2266', 'r2200', 'r2256', 'r1196', 'r2226', 'r1894', 'r1902', 'r390', 'r1121'})


import os, sys
import pytest
import logging
import subprocess
import xlrd
import math
from enum import Enum

sys.path.append("../findCPcore/")
from CobraMetabolicModel import CobraMetabolicModel


def generate_dem():
    model = CobraMetabolicModel(TEST_MODEL)
    EPSILON = model.epsilon()

    model.find_dem()
    model.dem()

    sets = set()
    for c in model.compartments():
        for dem in model.dem()[c]:
            sets.add(dem.id)

    print(sets)

def generate_chokepoints():
    model = CobraMetabolicModel(TEST_MODEL)
    EPSILON = model.epsilon()

    cps = set()

    model.find_chokepoints()
    for r, m in model.chokepoints():
        cps.add(r.id)

    print(cps)

def generate_growth_chokepoints():
    model = CobraMetabolicModel(TEST_MODEL)
    EPSILON = model.epsilon()

    model.fva(update_flux=True)

    cps = set()

    model.find_chokepoints()
    for r, m in model.chokepoints():
        cps.add(r.id)

    print(cps)

